/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.utils.menu.HotVisitorNg;
import ru.softlogic.gui.utils.menu.MenuItemByIdExtractor;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.Menu;
import ru.softlogic.reference.menu.MenuGroupKey;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemSchedule;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;

public class MenuUtils {
    private static final SimpleDateFormat dayFormat = new SimpleDateFormat("ddMMyyyy");
    private static Menu m;
    private static Short autoassignFreeHotkeys;
    private static ServiceType serviceTypesToProcessMGK;
    private static boolean searchInMenuGroupKey;

    public static void processMenu(MenuVisitor mv) {
        try {
            m = ReferenceManager.getInstance().getMenu();
            searchInMenuGroupKey = false;
            if (m != null) {
                MenuUtils._processMenu(m.getTypes(), mv);
                if (mv.onEnd()) {
                    MenuUtils._processMenu(m.getTypes(), mv);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processMenu(MenuVisitor mv, ServiceType st) {
        try {
            m = ReferenceManager.getInstance().getMenu();
            if (m != null) {
                MenuVisitor mvActual = mv;
                autoassignFreeHotkeys = m.getAutoassignFreeHotkeys();
                if (autoassignFreeHotkeys == null) {
                    autoassignFreeHotkeys = 0;
                }
                ServiceType[] stToProc = new ServiceType[]{st};
                if (st != null && m.getTypes().length == 1 && m.getTypes()[0].equals((Object)st)) {
                    searchInMenuGroupKey = false;
                    mvActual = mv;
                } else if (st != null && st.getMenuGroupKeys() != null && !st.getMenuGroupKeys().isEmpty()) {
                    serviceTypesToProcessMGK = st;
                    searchInMenuGroupKey = true;
                    mvActual = new MenuItemByIdExtractor(MenuUtils.getMGKIds(st.getMenuGroupKeys()));
                }
                if (searchInMenuGroupKey) {
                    MenuUtils._processMenu(m.getTypes(), mvActual);
                    List<MenuItem> mItems = ((MenuItemByIdExtractor)mvActual).getMenuItems();
                    List<ServiceType> sTypes = ((MenuItemByIdExtractor)mvActual).getServiceTypes();
                    LinkedList<SMI> smis = new LinkedList<SMI>();
                    for (MenuGroupKey mgk : serviceTypesToProcessMGK.getMenuGroupKeys()) {
                        for (MenuItem mi : mItems) {
                            if (mi.getIdMenuItem() != mgk.getIdMenuItem()) continue;
                            smis.add(new SMI(mi, mgk.getHotkeyPosition()));
                        }
                        for (ServiceType stp : sTypes) {
                            if (stp.getId() != mgk.getIdMenuItem()) continue;
                            smis.add(new SMI(stp, mgk.getHotkeyPosition()));
                        }
                    }
                    Collections.sort(smis);
                    if (mv instanceof HotVisitorNg) {
                        ((HotVisitorNg)mv).setMenuGroupKeyMenuItems(smis);
                    }
                } else {
                    MenuUtils._processMenu(stToProc, mvActual);
                }
                mvActual = mv;
                searchInMenuGroupKey = false;
                if (mvActual.onEnd()) {
                    if (autoassignFreeHotkeys == 1) {
                        MenuUtils._processMenu(stToProc, mvActual);
                    } else {
                        MenuUtils._processMenu(m.getTypes(), mvActual);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean _processMenu(ServiceType[] types, MenuVisitor mv) {
        if (types == null || types.length == 0) {
            return true;
        }
        if (!searchInMenuGroupKey) {
            for (ServiceType st : types) {
                if (!mv.processGroup(st)) continue;
                if (!mv.onGroup(st)) {
                    return false;
                }
                if (st.getMenuItems() != null) {
                    for (MenuItem menuItem : st.getMenuItems()) {
                        if (mv.onMenuItem(menuItem)) continue;
                        return false;
                    }
                }
                if (MenuUtils._processMenu(st.getTypes(), mv)) continue;
                return false;
            }
            return true;
        }
        if (mv instanceof MenuItemByIdExtractor) {
            for (ServiceType st : types) {
                mv.onGroup(st);
                if (st.getMenuItems() == null) continue;
                for (MenuItem menuItem : st.getMenuItems()) {
                    if (mv.onMenuItem(menuItem)) continue;
                    return false;
                }
                if (MenuUtils._processMenu(st.getTypes(), mv)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMenuItemBlockedSchedule(MenuItem mi) {
        if (mi == null || mi.getSchedules() == null) {
            return false;
        }
        GregorianCalendar cal = new GregorianCalendar();
        int day = cal.get(7);
        int hour = cal.get(11);
        int prevDay = cal.get(7) - 1;
        if (prevDay == 0) {
            prevDay = 7;
        }
        Date now = new Date();
        for (MenuItemSchedule mis : mi.getSchedules()) {
            if (!(mis.getDay() != null && mis.getDay() == day || mis.getDate() != null && dayFormat.format(mis.getDate()).equals(dayFormat.format(now)) ? (mis.getToHour() != null ? hour >= mis.getFromHour() && hour < mis.getToHour() : mis.getDuratuionHours() != null && hour >= mis.getFromHour() && hour < mis.getFromHour() + mis.getDuratuionHours()) : mis.getDay() != null && mis.getDay() == prevDay && mis.getDuratuionHours() != null && mis.getFromHour() + mis.getDuratuionHours() > 24 && hour < mis.getFromHour() + mis.getDuratuionHours() - 24)) continue;
            return false;
        }
        return true;
    }

    public static void clearBlockedSchedule(List<Object> list, boolean forcedRemove) {
        if (list == null) {
            return;
        }
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof MenuItem)) continue;
            MenuItem mi = (MenuItem)obj;
            if (!MenuUtils.isMenuItemBlockedSchedule((MenuItem)obj) || !forcedRemove && !mi.isHideUnactive()) continue;
            iterator.remove();
        }
    }

    public static void clearHidden(List<Object> list, MenuItemState[] menuItemStates) {
        if (list == null || menuItemStates == null || menuItemStates.length == 0) {
            return;
        }
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceType st;
            String stName;
            Object obj = iterator.next();
            if (obj instanceof MenuItem) {
                MenuItem mi = (MenuItem)obj;
                MenuItemState mis = StateUtil.getState(mi, menuItemStates);
                if (mis == null || mis.getButtonStatus() != ButtonStatus.Hidden) continue;
                iterator.remove();
                continue;
            }
            if (!(obj instanceof ServiceType) || ((stName = (st = (ServiceType)obj).getName()) == null || !stName.trim().startsWith("#")) && !st.getHidden()) continue;
            iterator.remove();
        }
    }

    private static Set<Integer> getMGKIds(List<MenuGroupKey> mgks) {
        HashSet<Integer> menuItemSet = new HashSet<Integer>();
        for (MenuGroupKey mgk : mgks) {
            menuItemSet.add(mgk.getIdMenuItem());
        }
        return menuItemSet;
    }

    public static class SMI
    implements Comparable<SMI> {
        private Object object;
        private Short hotkeyPos;

        public SMI(Object obj, Short hotkeyPosition) {
            this.object = obj;
            this.hotkeyPos = hotkeyPosition;
        }

        public Object getObject() {
            return this.object;
        }

        public Short getHotkeyPos() {
            return this.hotkeyPos;
        }

        @Override
        public int compareTo(SMI o) {
            return this.hotkeyPos.compareTo(o.hotkeyPos);
        }
    }
}

