/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.utils.menu.ComplexMenuItem;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.gui.utils.menu.compare.GroupComparable;
import ru.softlogic.gui.utils.menu.compare.HotComparable;
import ru.softlogic.gui.utils.menu.compare.HotkeyItemComparatorNg;
import ru.softlogic.gui.utils.menu.compare.HotkeyItemComparatorNgRates;
import ru.softlogic.gui.utils.menu.compare.MenuComparable;
import ru.softlogic.gui.utils.menu.compare.MenuItemComparable;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;

public class HotVisitorNg
extends MenuVisitorAdapter {
    private int count;
    private int maxCount;
    private boolean addToMaxCount;
    private MenuItemState[] menuItemStates;
    private boolean hotState;
    private boolean incHidden;
    private boolean noBlockedSchedule;
    private boolean useHotkeyRates;
    private Short autoassignFreeHotkeys;
    private boolean assignHotkeysFromMGKs;
    private List<ComplexMenuItem> items;
    private List<ComplexMenuItem> itemsHotkeyRated;
    private List<ServiceType> types;
    private List<MenuUtils.SMI> itemsFromMenuGroupKeys;
    private List<ComplexMenuItem> menuItemsFromMenuGroupKeys;
    private List<ServiceType> typesFromMenuGroupKeys;
    private List<ComplexMenuItem> reserveItems;
    private static final SimpleDateFormat dayFormat = new SimpleDateFormat("ddMMyyyy");

    public HotVisitorNg(int maxCount, boolean addToMaxCount) {
        this.maxCount = maxCount;
        this.addToMaxCount = addToMaxCount;
        this.hotState = true;
        this.useHotkeyRates = false;
        this.autoassignFreeHotkeys = 0;
        this.assignHotkeysFromMGKs = false;
        this.items = new LinkedList<ComplexMenuItem>();
        this.itemsHotkeyRated = new LinkedList<ComplexMenuItem>();
        this.itemsFromMenuGroupKeys = new LinkedList<MenuUtils.SMI>();
        this.menuItemsFromMenuGroupKeys = new LinkedList<ComplexMenuItem>();
        this.types = new LinkedList<ServiceType>();
        this.typesFromMenuGroupKeys = new LinkedList<ServiceType>();
        this.reserveItems = new LinkedList<ComplexMenuItem>();
        try {
            this.menuItemStates = ReferenceManager.getInstance().getMenuItemStates();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        try {
            this.useHotkeyRates = (ReferenceManager.getInstance().getMenu().getFlags() & 1) > 0;
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        try {
            this.autoassignFreeHotkeys = ReferenceManager.getInstance().getMenu().getAutoassignFreeHotkeys();
            if (this.autoassignFreeHotkeys == null) {
                this.autoassignFreeHotkeys = 0;
            }
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
    }

    public HotVisitorNg(int maxCount, boolean addToMaxCount, boolean incHidden) {
        this(maxCount, addToMaxCount);
        this.incHidden = incHidden;
    }

    public HotVisitorNg(int maxCount, boolean addToMaxCount, boolean incHidden, boolean noBlockedSchedule) {
        this(maxCount, addToMaxCount, incHidden);
        this.noBlockedSchedule = noBlockedSchedule;
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (this.hotState && mi.getHotkeyPosition() == null) {
            return true;
        }
        if (this.noBlockedSchedule && MenuUtils.isMenuItemBlockedSchedule(mi)) {
            return true;
        }
        MenuItemState mis = StateUtil.getState(mi, this.menuItemStates);
        if (mis != null && mis.getButtonStatus() == ButtonStatus.Hidden) {
            return true;
        }
        if (this.hotState) {
            this.items.add(new ComplexMenuItem(mi, mis));
            ++this.count;
            return this.count != this.maxCount;
        }
        if (this.autoassignFreeHotkeys == 0) {
            if (!(this.serviceInHotGroup(mi.getService()) || this.serviceInMenuItemList(mi.getService(), this.items) || this.serviceInMenuItemList(mi.getService(), this.menuItemsFromMenuGroupKeys))) {
                this.items.add(new ComplexMenuItem(mi, mis));
                ++this.count;
            }
            return this.count != this.maxCount;
        }
        if (!this.useHotkeyRates) {
            if (!(this.reserveItems.size() >= this.maxCount || this.serviceInHotGroup(mi.getService()) || this.serviceInMenuItemList(mi.getService(), this.reserveItems) || this.serviceInMenuItemList(mi.getService(), this.items) || this.serviceInMenuItemList(mi.getService(), this.menuItemsFromMenuGroupKeys))) {
                this.reserveItems.add(new ComplexMenuItem(mi, mis));
                ++this.count;
            }
            return this.count != this.maxCount;
        }
        if (mi.getHotkeyPosition() != null || mi.getRate() == null || mi.getRate() == 0) {
            if (!(this.reserveItems.size() >= this.maxCount || this.serviceInHotGroup(mi.getService()) || this.serviceInMenuItemList(mi.getService(), this.reserveItems) || this.serviceInMenuItemList(mi.getService(), this.items) || this.serviceInMenuItemList(mi.getService(), this.menuItemsFromMenuGroupKeys))) {
                this.reserveItems.add(new ComplexMenuItem(mi, mis));
            }
            return true;
        }
        if (!(this.serviceInHotGroup(mi.getService()) || this.serviceInMenuItemList(mi.getService(), this.items) || this.serviceInMenuItemList(mi.getService(), this.menuItemsFromMenuGroupKeys) || this.serviceInMenuItemList(mi.getService(), this.itemsHotkeyRated))) {
            this.itemsHotkeyRated.add(new ComplexMenuItem(mi, mis));
        }
        return true;
    }

    @Override
    public boolean onGroup(ServiceType st) {
        if (this.hotState && st.getHotkeyPosition() != null) {
            this.types.add(st);
            ++this.count;
            if (this.count == this.maxCount) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onEnd() {
        if (this.addToMaxCount && this.count < this.maxCount) {
            this.hotState = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean processGroup(ServiceType st) {
        return this.incHidden || (st.getName() == null || !st.getName().startsWith("#")) && !st.getHidden();
    }

    public void setMenuGroupKeyMenuItems(List<MenuUtils.SMI> items) {
        this.assignHotkeysFromMGKs = true;
        for (MenuUtils.SMI smi : items) {
            if (smi.getObject() instanceof MenuItem) {
                MenuItem mi = (MenuItem)smi.getObject();
                MenuItemState mis = StateUtil.getState(mi, this.menuItemStates);
                if (mis != null && mis.getButtonStatus() == ButtonStatus.Hidden) continue;
                this.menuItemsFromMenuGroupKeys.add(new ComplexMenuItem(mi, mis));
                this.itemsFromMenuGroupKeys.add(new MenuUtils.SMI(new ComplexMenuItem(mi, mis), smi.getHotkeyPos()));
                ++this.count;
            } else if (smi.getObject() instanceof ServiceType) {
                ServiceType stp = (ServiceType)smi.getObject();
                if (!this.processGroup(stp)) continue;
                this.typesFromMenuGroupKeys.add(stp);
                this.itemsFromMenuGroupKeys.add(smi);
                ++this.count;
            }
            if (this.count != this.maxCount) continue;
            break;
        }
        Collections.sort(this.itemsFromMenuGroupKeys);
    }

    public List<HotComparable> getSortedItems() {
        List<HotComparable> list = new LinkedList<HotComparable>();
        if (this.autoassignFreeHotkeys == 0) {
            for (ComplexMenuItem complexMenuItem : this.items) {
                list.add(new MenuItemComparable(complexMenuItem));
            }
            for (ServiceType serviceType : this.types) {
                list.add(new GroupComparable(serviceType));
            }
            Collections.sort(list, new HotkeyItemComparatorNg());
            LinkedList<MenuComparable> hotListMGK = new LinkedList<MenuComparable>();
            for (MenuUtils.SMI smi : this.itemsFromMenuGroupKeys) {
                if (smi.getObject() instanceof ComplexMenuItem) {
                    hotListMGK.add(new MenuItemComparable((ComplexMenuItem)smi.getObject()));
                    continue;
                }
                if (!(smi.getObject() instanceof ServiceType)) continue;
                hotListMGK.add(new GroupComparable((ServiceType)smi.getObject()));
            }
            list.addAll(0, hotListMGK);
        } else {
            LinkedList<MenuUtils.SMI> listForSort = new LinkedList<MenuUtils.SMI>();
            LinkedList<HotComparable> linkedList = new LinkedList<HotComparable>();
            listForSort.addAll(this.itemsFromMenuGroupKeys);
            for (ComplexMenuItem cmi : this.items) {
                linkedList.add(new MenuItemComparable(cmi));
            }
            for (ServiceType st : this.types) {
                linkedList.add(new GroupComparable(st));
            }
            Collections.sort(linkedList, new HotkeyItemComparatorNg());
            this.convertAndAddHCtoSMI(linkedList, listForSort, true);
            int itemsLimit = this.maxCount - listForSort.size();
            if (itemsLimit > 0) {
                this.convertAndAddHCtoSMI(this.getRateSortedLimitedMenuItems(itemsLimit), listForSort, false);
            }
            if ((itemsLimit = this.maxCount - listForSort.size()) > 0) {
                this.convertAndAddHCtoSMI(this.getStubLimitedMenuItems(itemsLimit), listForSort, false);
            }
            Collections.sort(listForSort);
            list = this.convertSMItoHC(listForSort);
        }
        return list;
    }

    private List<HotComparable> convertSMItoHC(List<MenuUtils.SMI> from) {
        LinkedList<HotComparable> to = new LinkedList<HotComparable>();
        for (MenuUtils.SMI smi : from) {
            if (smi.getObject() instanceof ComplexMenuItem) {
                to.add(new MenuItemComparable((ComplexMenuItem)smi.getObject()));
                continue;
            }
            if (!(smi.getObject() instanceof ServiceType)) continue;
            to.add(new GroupComparable((ServiceType)smi.getObject()));
        }
        return to;
    }

    private void convertAndAddHCtoSMI(List<HotComparable> from, List<MenuUtils.SMI> to, boolean incHotPosition) {
        List<Integer> freePlacesList = this.getFreePlaces(to);
        for (HotComparable hc : from) {
            if (hc instanceof MenuItemComparable) {
                ComplexMenuItem cmi = ((MenuItemComparable)hc).getItem();
                to.add(new MenuUtils.SMI(cmi, incHotPosition ? cmi.getMenuItem().getHotkeyPosition().shortValue() : freePlacesList.remove(0).shortValue()));
                continue;
            }
            if (!(hc instanceof GroupComparable)) continue;
            ServiceType st = ((GroupComparable)hc).getServiceType();
            to.add(new MenuUtils.SMI(st, incHotPosition ? st.getHotkeyPosition().shortValue() : freePlacesList.remove(0).shortValue()));
        }
    }

    private List<Integer> getFreePlaces(List<MenuUtils.SMI> smis) {
        LinkedList<Integer> places = new LinkedList<Integer>();
        for (int i = 0; i < this.maxCount; ++i) {
            places.add(i + 1);
        }
        for (MenuUtils.SMI smi : smis) {
            if (!places.contains(smi.getHotkeyPos().intValue())) continue;
            places.remove((Object)smi.getHotkeyPos().intValue());
        }
        return places;
    }

    private List<HotComparable> getRateSortedLimitedMenuItems(int itemsLimit) {
        LinkedList<HotComparable> addList = new LinkedList<HotComparable>();
        for (ComplexMenuItem cmi : this.itemsHotkeyRated) {
            if (this.serviceInHotGroup(cmi.getMenuItem().getService())) continue;
            addList.add(new MenuItemComparable(cmi));
        }
        Collections.sort(addList, new HotkeyItemComparatorNgRates());
        if (addList.size() <= itemsLimit) {
            return addList;
        }
        return addList.subList(0, itemsLimit);
    }

    private List<HotComparable> getStubLimitedMenuItems(int itemsLimit) {
        LinkedList<HotComparable> addList = new LinkedList<HotComparable>();
        for (ComplexMenuItem cmi : this.reserveItems) {
            Service srv = cmi.getMenuItem().getService();
            if (this.serviceInHotGroup(srv) || this.serviceInMenuItemList(srv, this.items) || this.serviceInMenuItemList(srv, this.menuItemsFromMenuGroupKeys) || this.serviceInMenuItemList(srv, this.itemsHotkeyRated)) continue;
            addList.add(new MenuItemComparable(cmi));
        }
        if (addList.size() <= itemsLimit) {
            return addList;
        }
        return addList.subList(0, itemsLimit);
    }

    private boolean serviceInHotGroup(Service srvID) {
        for (ServiceType st : this.types) {
            for (MenuItem mi : st.getMenuItems()) {
                if (mi.getService().getId() != srvID.getId()) continue;
                return true;
            }
            if (!this.serviceInHotSubGroup(st.getTypes(), srvID)) continue;
            return true;
        }
        for (ServiceType st : this.typesFromMenuGroupKeys) {
            for (MenuItem mi : st.getMenuItems()) {
                if (mi.getService().getId() != srvID.getId()) continue;
                return true;
            }
            if (!this.serviceInHotSubGroup(st.getTypes(), srvID)) continue;
            return true;
        }
        return false;
    }

    private boolean serviceInHotSubGroup(ServiceType[] sts, Service srvID) {
        for (ServiceType st : sts) {
            for (MenuItem mi : st.getMenuItems()) {
                if (mi.getService().getId() != srvID.getId()) continue;
                return true;
            }
            if (!this.serviceInHotSubGroup(st.getTypes(), srvID)) continue;
            return true;
        }
        return false;
    }

    private boolean serviceInMenuItemList(Service srv, List<ComplexMenuItem> itemsList) {
        for (ComplexMenuItem cmi : itemsList) {
            if (cmi.getMenuItem().getService().getId() != srv.getId()) continue;
            return true;
        }
        return false;
    }
}

