/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;

public abstract class HotVisitor
extends MenuVisitorAdapter {
    private int count;
    private int maxCount;
    private boolean addToMaxCount;
    private MenuItemState[] menuItemStates;
    private boolean hotState;
    private boolean incHidden;

    public HotVisitor(int maxCount, boolean addToMaxCount) {
        this.maxCount = maxCount;
        this.addToMaxCount = addToMaxCount;
        this.hotState = true;
        try {
            this.menuItemStates = ReferenceManager.getInstance().getMenuItemStates();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
    }

    public HotVisitor(int maxCount, boolean addToMaxCount, boolean incHidden) {
        this(maxCount, addToMaxCount);
        this.incHidden = incHidden;
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (mi.isHotKey() != this.hotState) {
            return true;
        }
        MenuItemState mis = StateUtil.getState(mi, this.menuItemStates);
        if (mis != null && mis.getButtonStatus() == ButtonStatus.Hidden) {
            return true;
        }
        if (this.onHotItem(this.count, mi, mis)) {
            ++this.count;
        }
        return this.count != this.maxCount;
    }

    @Override
    public boolean onEnd() {
        if (this.addToMaxCount && this.count < this.maxCount) {
            this.hotState = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean processGroup(ServiceType st) {
        return this.incHidden || !st.getName().startsWith("#") && !st.getHidden();
    }

    public boolean isHotState() {
        return this.hotState;
    }

    public abstract boolean onHotItem(int var1, MenuItem var2, MenuItemState var3);
}

