/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import org.apache.log4j.Logger;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ServiceType;

public class GroupByMenuItemVisitor
extends MenuVisitorAdapter {
    private MenuItem menuItem;
    private ServiceType serviceType;
    private Logger log;

    public GroupByMenuItemVisitor(MenuItem menuItem) {
        if (menuItem == null) {
            throw new NullPointerException("MenuItem");
        }
        this.menuItem = menuItem;
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (mi.getService().getId() == this.menuItem.getService().getId()) {
            return false;
        }
        return mi.getService().getChildServices() == null || !mi.getService().getChildServices().contains(this.menuItem.getService().getId());
    }

    @Override
    public boolean onGroup(ServiceType st) {
        this.serviceType = st;
        return true;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }
}

