/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.gui.utils.PropertiesUtil;
import ru.softlogic.input.model.InputElement;

public class TemplatePropertiesUtil {
    public static Properties getTemplateTitleProperties(String guiName) {
        return PropertiesUtil.loadPropertiesFileName(guiName, "templateparams.properties");
    }

    public static Map<String, Object> mergeTemplateItemProperties(List<InputElement> elements, Properties p) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (p.stringPropertyNames() != null && !p.stringPropertyNames().isEmpty()) {
                for (Map.Entry<Object, Object> propEObject : p.entrySet()) {
                    String[] resourceStrs;
                    if (!(propEObject.getValue() instanceof String) || !((String)propEObject.getKey()).contains("template.selector")) continue;
                    block3: for (String key : resourceStrs = ((String)propEObject.getValue()).split(",")) {
                        for (InputElement ie : elements) {
                            if (!key.equals(ie.getKey())) continue;
                            result.put((String)propEObject.getKey(), ie.getValue());
                            continue block3;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger((String)"gui").error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static Map<String, Object> createTemplateItemVSMap(List<InputElement> elements, Properties p) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (p == null || elements == null) {
                return result;
            }
            for (InputElement ie : elements) {
                result.put(ie.getKey(), ie.getValue());
            }
            result.putAll(TemplatePropertiesUtil.mergeTemplateItemProperties(elements, p));
        }
        catch (Exception ex) {
            Logger.getLogger((String)"gui").error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }
}

