/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SwingUtil {
    public static final GridBagConstraints signleCellConstraints;
    private static final GridBagConstraints gbc;

    public static JPanel wrapInBackgroundImage(JComponent component, Icon backgroundIcon) {
        return SwingUtil.wrapInBackgroundImage(component, backgroundIcon, 1, 10);
    }

    public static JPanel wrapInBackgroundImage(JComponent component, Icon backgroundIcon, int verticalAlignment, int horizontalAlignment) {
        JPanel backgroundPanel = new JPanel(new GridBagLayout());
        component.setOpaque(false);
        backgroundPanel.add((Component)component, gbc);
        JButton backgroundImage = new JButton(backgroundIcon);
        backgroundImage.setPreferredSize(new Dimension(1, 1));
        backgroundImage.setMinimumSize(new Dimension(1, 1));
        backgroundImage.setVerticalAlignment(verticalAlignment);
        backgroundImage.setHorizontalAlignment(horizontalAlignment);
        backgroundPanel.add((Component)backgroundImage, gbc);
        return backgroundPanel;
    }

    public static MouseAdapter createEmptyMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Logger.getLogger((String)"gui").info((Object)("Top:mousePressed: " + e.getPoint()));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Logger.getLogger((String)"gui").info((Object)("Top:mouseReleased: " + e.getPoint()));
            }
        };
    }

    public static void requestFocus(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
            }
        });
    }

    static {
        gbc = new GridBagConstraints();
        SwingUtil.gbc.gridx = 0;
        SwingUtil.gbc.gridy = 0;
        SwingUtil.gbc.weightx = 1.0;
        SwingUtil.gbc.weighty = 1.0;
        SwingUtil.gbc.fill = 1;
        SwingUtil.gbc.anchor = 18;
        signleCellConstraints = new GridBagConstraints();
        SwingUtil.signleCellConstraints.gridx = 0;
        SwingUtil.signleCellConstraints.gridy = 0;
        SwingUtil.signleCellConstraints.weightx = 1.0;
        SwingUtil.signleCellConstraints.weighty = 1.0;
        SwingUtil.signleCellConstraints.fill = 0;
        SwingUtil.signleCellConstraints.anchor = 10;
    }
}

