/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.system.util.PathUtils;

public class PropertiesUtil {
    public static Properties loadPropertiesFileName(String guiName, String fileName) {
        Properties p = new Properties();
        try {
            String menuDesignPath = null;
            if (ReferenceManager.getInstance() != null && ReferenceManager.getInstance().getMenu() != null) {
                menuDesignPath = ReferenceManager.getInstance().getMenu().getMenuDesign();
            }
            menuDesignPath = menuDesignPath != null ? File.separator + menuDesignPath + File.separator : "";
            p = PropertiesUtil.loadPropertiesByPath(PathUtils.getAppHome() + File.separator + "img" + File.separator + guiName + menuDesignPath + File.separator + fileName);
            if (p == null) {
                p = PropertiesUtil.loadPropertiesByPath(PathUtils.getAppHome() + File.separator + "img" + File.separator + guiName + File.separator + fileName);
            }
        }
        catch (Exception ex) {
            Logger.getLogger((String)"gui").error((Object)ex.getMessage(), (Throwable)ex);
        }
        return p;
    }

    public static Properties loadResourcesPropertiesFileName(String fileName) {
        return PropertiesUtil.loadPropertiesByPath(PathUtils.getAppHome() + File.separator + "resources" + File.separator + fileName);
    }

    public static Properties loadPropertiesByPath(String pathName) {
        Properties p = new Properties();
        File file = new File(pathName);
        if (file.exists() && file.isFile()) {
            try (InputStreamReader isreader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");){
                p.load(isreader);
            }
            catch (Exception ex) {
                Logger.getLogger((String)"gui").error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            Logger.getLogger((String)"gui").info((Object)"templateparams.properties not found");
            return null;
        }
        return p;
    }
}

