/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.util.TreeMap;

public class LevenshteinDistance {
    public static int getDamerauLevenshteinDistance(String source, String target) {
        int i;
        int inf;
        if (source == null || source.isEmpty()) {
            if (target == null || target.isEmpty()) {
                return 0;
            }
            return target.length();
        }
        if (target == null || target.isEmpty()) {
            return source.length();
        }
        char[] sourceArray = source.toCharArray();
        char[] targetArray = target.toCharArray();
        int m = sourceArray.length;
        int n = targetArray.length;
        int[][] h = new int[m + 2][n + 2];
        h[0][0] = inf = m + n;
        for (int i2 = 0; i2 <= m; ++i2) {
            h[i2 + 1][1] = i2;
            h[i2 + 1][0] = inf;
        }
        for (int j = 0; j <= n; ++j) {
            h[1][j + 1] = j;
            h[0][j + 1] = inf;
        }
        TreeMap<Character, Integer> map = new TreeMap<Character, Integer>();
        for (i = 0; i < targetArray.length; ++i) {
            if (map.containsKey(Character.valueOf(targetArray[i]))) continue;
            map.put(Character.valueOf(targetArray[i]), 0);
        }
        for (i = 0; i < sourceArray.length; ++i) {
            if (map.containsKey(Character.valueOf(sourceArray[i]))) continue;
            map.put(Character.valueOf(sourceArray[i]), 0);
        }
        for (i = 1; i <= m; ++i) {
            int db = 0;
            for (int j = 1; j <= n; ++j) {
                int i1 = (Integer)map.get(Character.valueOf(targetArray[j - 1]));
                int j1 = db;
                if (sourceArray[i - 1] == targetArray[j - 1]) {
                    h[i + 1][j + 1] = h[i][j];
                    db = j;
                } else {
                    h[i + 1][j + 1] = Math.min(h[i][j], Math.min(h[i + 1][j], h[i][j + 1])) + 1;
                }
                h[i + 1][j + 1] = Math.min(h[i + 1][j + 1], h[i1][j1] + (i - i1 - 1) + 1 + (j - j1 - 1));
            }
            map.put(Character.valueOf(sourceArray[i - 1]), i);
        }
        return h[m + 1][n + 1];
    }
}

