/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.popup.dialog;

import java.awt.EventQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.useraction.UserAction;

public class DialogTimer {
    private List<DialogInterface> dialogs = new LinkedList<DialogInterface>();
    private static DialogTimer instance = new DialogTimer();

    private DialogTimer() {
        Thread th = new Thread((Runnable)new Scanner(), "DialogTimer");
        th.setDaemon(true);
        th.start();
    }

    public synchronized void addDialog(DialogInterface dialog) {
        if (dialog != null) {
            if (!this.dialogs.isEmpty()) {
                for (DialogInterface di : this.dialogs) {
                    di.processDefaultActon();
                }
                this.dialogs.clear();
            }
            this.dialogs.add(dialog);
        }
    }

    public static DialogTimer getInstance() {
        return instance;
    }

    private synchronized void process() {
        long now = System.currentTimeMillis();
        Iterator<DialogInterface> iterator = this.dialogs.iterator();
        while (iterator.hasNext()) {
            final DialogInterface dialog = iterator.next();
            if (dialog.isUseUserAction()) {
                if (!UserAction.getInstance().isElapsed(dialog.getTimeOut())) continue;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.processDefaultActon();
                    }
                });
                iterator.remove();
                continue;
            }
            long show = dialog.getShowTime();
            if (show == 0L || now - show < (long)(dialog.getTimeOut() * 1000)) continue;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dialog.processDefaultActon();
                }
            });
            iterator.remove();
        }
    }

    private class Scanner
    implements Runnable {
        private Scanner() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                DialogTimer.this.process();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

