/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.popup.dialog;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.screen.popup.dialog.AdvtDialogPanel;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.PanelListener;

public class BaseAdvtCustomPanel
implements CustomPanel {
    private AdvtDialogPanel dialogPanel;
    private PanelListener listener;

    public BaseAdvtCustomPanel(AdvtDialogPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 PinCodePanel");
        }
        this.dialogPanel = panel;
    }

    public void init(DialogType type, String message, DisplayedUserCase[] cases, Image image, ImageIcon gifImage) {
        if (type == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogType");
        }
        this.dialogPanel.setMessage(message);
        ImagePanel bannerPanel = this.dialogPanel.getBannerPanel();
        if (image != null) {
            bannerPanel.setVisible(false);
            bannerPanel.removeAll();
            bannerPanel.setImage(image, false);
            bannerPanel.setVisible(true);
        } else {
            bannerPanel.setVisible(false);
            bannerPanel.removeAll();
            bannerPanel.setImage(null, false);
            bannerPanel.add(new JLabel(gifImage));
            bannerPanel.setVisible(true);
        }
        bannerPanel.addMouseListener(new LocalMouseListener());
        if (cases != null) {
            for (DisplayedUserCase duc : cases) {
                ClickButton button = this.dialogPanel.createButton(duc.getText());
                button.putClientProperty("case", (Object)duc.getUserCase());
                button.addActionListener(new LocalActionListener());
            }
        }
    }

    @Override
    public JPanel getPanel() {
        return this.dialogPanel.getPanel();
    }

    @Override
    public void setListener(PanelListener listener) {
        this.listener = listener;
    }

    private class LocalMouseListener
    implements MouseListener {
        private ClickButton dataButton = new ClickButton();

        public LocalMouseListener() {
            this.dataButton.putClientProperty("case", (Object)UserCase.Cancel);
            this.dataButton.addActionListener(new LocalActionListener());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Logger.getLogger((String)"start").info((Object)"mouseClicked");
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Logger.getLogger((String)"start").info((Object)"mousePressed");
            this.dataButton.doClick();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Logger.getLogger((String)"start").info((Object)"mouseReleased");
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof ClickButton) {
                ClickButton cb = (ClickButton)e.getSource();
                cb.setEnabled(false);
                if (BaseAdvtCustomPanel.this.listener != null) {
                    BaseAdvtCustomPanel.this.listener.onUserAction((Object)((UserCase)((Object)cb.getClientProperty("case"))));
                }
            }
        }
    }
}

