/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.popup.cbc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import ru.softlogic.gui.screen.popup.cbc.ErrorShower;
import ru.softlogic.gui.screen.popup.cbc.PinCodePanel;
import ru.softlogic.gui.screen.popup.cbc.PinCodeValidator;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.PanelListener;
import ru.softlogic.gui2.keyboard.listener.SimpleKeyboardListener;
import ru.softlogic.gui2.screen.textfield.TextFieldModel;
import ru.softlogic.gui2.screen.textfield.ValidateUpdaterListener;
import ru.softlogic.gui2.screen.textfield.ViewUpdaterListener;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.RegexFormatter;
import ru.softlogic.input.model.field.text.VoidFilter;

public class BasePinCodeScreen
implements CustomPanel {
    protected PinCodePanel panel;
    protected TextFieldModel model;
    protected PanelListener listener;

    public BasePinCodeScreen() {
    }

    public BasePinCodeScreen(PinCodePanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 PinCodePanel");
        }
        this.panel = panel;
        panel.getActivateButton().addActionListener(new LocalActivateListener());
        panel.getCloseButton().addActionListener(new LocalCloseListener());
        this.model = new TextFieldModel(16, null, null, false, (Filter)new VoidFilter());
        this.model.addListener(new ValidateUpdaterListener(panel.getActivateButton(), new PinCodeValidator()));
        RegexFormatter formatter = new RegexFormatter();
        formatter.setDefaultMask("****-****-****-****");
        formatter.setByStep(true);
        this.model.addListener(new ViewUpdaterListener(panel.getViewLabel(), (Formatter)formatter));
        this.model.addListener(new ErrorShower(panel.getFailLabel(), new PinCodeValidator()));
        panel.getKeyboard().init(new Keyboard(KeyboardType.Digital));
        panel.getKeyboard().addKeyboardListener(new SimpleKeyboardListener(this.model));
    }

    public void init(Locale locale) {
        this.model.setValue("");
        this.panel.getCloseButton().setEnabled(true);
        this.panel.init(locale);
    }

    @Override
    public JPanel getPanel() {
        return this.panel.getPanel();
    }

    @Override
    public void setListener(PanelListener listener) {
        this.listener = listener;
    }

    public class LocalCloseListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JButton btn = (JButton)e.getSource();
            btn.setEnabled(false);
            if (BasePinCodeScreen.this.listener != null) {
                BasePinCodeScreen.this.listener.onUserAction(null);
            }
        }
    }

    public class LocalActivateListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JButton btn = (JButton)e.getSource();
            btn.setEnabled(false);
            if (BasePinCodeScreen.this.listener != null) {
                BasePinCodeScreen.this.listener.onUserAction(BasePinCodeScreen.this.model.getValue());
            }
        }
    }
}

