/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content.barcode;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.gui.screen.content.barcode.BarcodeField;
import ru.softlogic.gui.screen.content.barcode.BarcodeListener;
import ru.softlogic.gui.screen.content.barcode.BarcodePanel;
import ru.softlogic.gui.screen.content.barcode.BarcodeScreen;
import ru.softlogic.gui.screen.content.barcode.BarcodeStage;
import ru.softlogic.gui.screen.content.barcode.parser.BarcodeData;
import ru.softlogic.gui.screen.content.barcode.parser.BarcodeParser;
import ru.softlogic.gui.screen.content.barcode.parser.BarcodeParserFactory;
import ru.softlogic.reference.menu.MenuItem;

public class BaseBarcodeScreen
implements BarcodeScreen {
    private BarcodePanel panel;
    private Set<BarcodeListener> listeners;
    private BarcodeStage stage;
    private BarcodeParser parser;
    private BarcodeField field;
    private BarcodeData result;
    private Logger log;

    public BaseBarcodeScreen(BarcodePanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043f\u0430\u043d\u0435\u043b\u0438");
        }
        this.panel = panel;
        panel.getTextArea().addKeyListener(new KeyListener());
        panel.getNext().addActionListener(new LocalActionListener());
        panel.getExit().addActionListener(new LocalExitListener());
        this.listeners = new HashSet<BarcodeListener>();
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
    }

    @Override
    public void setField(MenuItem menuItem, BarcodeField barcodeField, Locale locale) {
        if (barcodeField == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 BarcodeField");
        }
        this.log.info((Object)("\u041f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043a \u044d\u043a\u0440\u0430\u043d\u0443 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u043e\u0432: " + barcodeField + ", locale=" + locale));
        this.field = barcodeField;
        this.panel.init(locale);
        this.panel.setInfo(menuItem.getService().getImage());
        this.setStage(BarcodeStage.Idle);
        this.parser = BarcodeParserFactory.createParcer(barcodeField.getParser());
    }

    @Override
    public void addListener(BarcodeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private void setStage(BarcodeStage stage) {
        this.stage = stage;
        this.panel.setStage(stage);
    }

    private void analyze() {
        String data = this.panel.getTextArea().getText();
        this.panel.getTextArea().setText("");
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0430: " + data));
        this.result = this.parser.parce(data);
        if (this.result == null) {
            this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435");
            this.setStage(BarcodeStage.Idle);
            this.panel.setError();
        } else {
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435: " + this.result));
            this.panel.setView(this.result.getData().values().toArray(new String[this.result.getData().size()]));
        }
    }

    @Override
    public void afterShow() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseBarcodeScreen.this.panel.getTextArea().requestFocus();
            }
        });
    }

    @Override
    public void afterHide() {
    }

    private class LocalExitListener
    implements ActionListener {
        private LocalExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (BarcodeListener bl : BaseBarcodeScreen.this.listeners) {
                bl.onExit();
            }
        }
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (BarcodeListener bl : BaseBarcodeScreen.this.listeners) {
                bl.onBarcode(BaseBarcodeScreen.this.field, BaseBarcodeScreen.this.result.getSumTrade(), BaseBarcodeScreen.this.result.getData());
            }
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                BaseBarcodeScreen.this.log.info((Object)"\u0414\u0430\u043d\u043d\u044b\u0435 \u0441\u0447\u0438\u0442\u0430\u043d\u044b");
                BaseBarcodeScreen.this.analyze();
                BaseBarcodeScreen.this.setStage(BarcodeStage.Finish);
            } else if (BaseBarcodeScreen.this.stage == BarcodeStage.Idle || BaseBarcodeScreen.this.stage == BarcodeStage.Finish) {
                BaseBarcodeScreen.this.setStage(BarcodeStage.Scan);
            }
        }
    }
}

