/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content.banner;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.gui.screen.content.banner.BannerManager;
import ru.softlogic.system.util.OsDetector;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.component.EmbeddedMediaPlayerComponent;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class VideoHelper
implements Serializable {
    private static boolean vlcLoaded;

    public static synchronized void play(final JPanel panel, final String path) {
        try {
            if (!vlcLoaded) {
                String vlcLibPath = null;
                vlcLibPath = SystemProp.getVlcLibPath() != null ? SystemProp.getVlcLibPath() : (OsDetector.current() == 2 ? "C:\\Program Files\\VideoLAN\\VLC" : "/usr/lib");
                NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)vlcLibPath);
                Native.loadLibrary((String)RuntimeUtil.getLibVlcLibraryName(), LibVlc.class);
                vlcLoaded = true;
            }
        }
        catch (Throwable e) {
            vlcLoaded = true;
            e.printStackTrace();
        }
        try {
            File f = new File(path);
            if (f.exists()) {
                final EmbeddedMediaPlayerComponent player = new EmbeddedMediaPlayerComponent();
                panel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{-1.0}));
                panel.add((Component)player, "0,0,f,f");
                panel.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                        player.getMediaPlayer().prepareMedia(path, new String[0]);
                        player.getMediaPlayer().setRepeat(true);
                        player.getMediaPlayer().play();
                        panel.removeAncestorListener(this);
                    }
                });
                BannerManager.getInstance().addStopMediaPlayerCallback(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            player.getMediaPlayer().stop();
                            player.release(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

