/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content.banner;

import java.awt.BorderLayout;
import java.awt.Image;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.softlogic.gui.adv.AdvDescription;
import ru.softlogic.gui.adv.AdvExtractor;
import ru.softlogic.gui.adv.ContentType;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.RedirectListener;
import ru.softlogic.gui.screen.content.banner.BannerManager;
import ru.softlogic.gui.screen.content.banner.BannerManagerTask;
import ru.softlogic.gui.screen.content.banner.BannerMouseListener;
import ru.softlogic.gui.screen.content.banner.VideoHelper;
import ru.softlogic.gui.utils.ComponentUtil;
import ru.softlogic.reference.service.Service;

public class AdvHelper {
    public static JPanel getImageBanner(JPanel target, Service service, String place, int width, int height, RedirectListener listener, Runnable callback, List<Integer> bi, boolean reset) {
        AdvDescription desc;
        if (reset) {
            BannerManager.getInstance().reset();
        }
        if ((desc = AdvExtractor.getInstance().extract(ComponentFactory.getInstance().getSkinCode(), place, service != null ? Integer.valueOf(service.getId()) : null)) == null || desc.getBanner() == null) {
            if (target != null) {
                target.removeAll();
                target.revalidate();
            }
        } else {
            if (desc.getContentType() == ContentType.Video) {
                JPanel panel = target;
                if (panel == null) {
                    panel = ComponentUtil.createJPanelBySize(width, height);
                } else {
                    panel.removeAll();
                }
                panel.setOpaque(false);
                VideoHelper.play(panel, desc.getPath());
                panel.revalidate();
                if (bi != null) {
                    bi.add(desc.getBanner().getId());
                }
                return panel;
            }
            if (desc.getContentType() != ContentType.Flash && desc.getContentType() == ContentType.Image) {
                if (desc.getBanner().getUrl() != null && desc.getBanner().getUrl().endsWith(".gif")) {
                    ImageIcon gifImage = ComponentFactory.getInstance().getImageStore().getGIFBannerBySize(desc.getBanner().getUrl(), width, height);
                    if (gifImage != null) {
                        JPanel panel = target;
                        if (panel == null) {
                            panel = ComponentUtil.createJPanelBySize(width, height);
                        } else {
                            panel.removeAll();
                        }
                        panel.setOpaque(false);
                        panel.setLayout(new BorderLayout());
                        panel.add(new JLabel(ComponentFactory.getInstance().getImageStore().getGIFBannerBySize(desc.getBanner().getUrl(), width, height)));
                        panel.revalidate();
                        if (desc.getBanner().getIdReferService() != null || desc.getBanner().getLabel() != null || desc.getBanner().getPopupUrl() != null) {
                            JComponent popupBanner = AdvHelper.getPopupBanner(desc.getBanner().getPopupUrl(), width, height);
                            panel.addMouseListener(new BannerMouseListener(desc.getBanner(), listener, popupBanner, panel));
                        }
                        if (desc.getBanner() != null && desc.getBanner().getShowTime() != null) {
                            BannerManager.getInstance().addTask(new BannerManagerTask(System.currentTimeMillis(), desc.getBanner().getShowTime() * 1000, panel, service, place, width, height, listener, callback));
                        }
                        if (bi != null) {
                            bi.add(desc.getBanner().getId());
                        }
                        return panel;
                    }
                } else {
                    Image image = ComponentFactory.getInstance().getImageStore().getBannerBySize(desc.getBanner().getUrl(), width, height);
                    if (image != null) {
                        ImagePanel ip = new ImagePanel(image, false);
                        ip.setOpaque(false);
                        JPanel panel = target;
                        if (panel == null) {
                            panel = ComponentUtil.createJPanelBySize(width, height);
                        } else {
                            panel.removeAll();
                        }
                        panel.setOpaque(false);
                        panel.setLayout(new BorderLayout());
                        panel.add(ip);
                        panel.revalidate();
                        if (desc.getBanner().getIdReferService() != null || desc.getBanner().getLabel() != null || desc.getBanner().getPopupUrl() != null) {
                            JComponent popupBanner = AdvHelper.getPopupBanner(desc.getBanner().getPopupUrl(), width, height);
                            ip.addMouseListener(new BannerMouseListener(desc.getBanner(), listener, popupBanner, panel));
                        }
                        if (desc.getBanner() != null && desc.getBanner().getShowTime() != null) {
                            BannerManager.getInstance().addTask(new BannerManagerTask(System.currentTimeMillis(), desc.getBanner().getShowTime() * 1000, panel, service, place, width, height, listener, callback));
                        }
                        if (bi != null) {
                            bi.add(desc.getBanner().getId());
                        }
                        return panel;
                    }
                }
            }
        }
        return null;
    }

    public static JComponent getPopupBanner(String url, int width, int height) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        if (url.endsWith(".gif")) {
            ImageIcon gifImage = ComponentFactory.getInstance().getImageStore().getGIFBannerBySize(url, width, height);
            if (gifImage != null) {
                return new JLabel(ComponentFactory.getInstance().getImageStore().getGIFBannerBySize(url, width, height));
            }
        } else {
            Image image = ComponentFactory.getInstance().getImageStore().getBannerBySize(url, width, height);
            if (image != null) {
                ImagePanel ip = new ImagePanel(image, false);
                ip.setOpaque(false);
                return ip;
            }
        }
        return null;
    }
}

