/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content;

import java.util.Set;
import ru.softlogic.gui.screen.content.BannerRedirectListener;
import ru.softlogic.gui.screen.content.RedirectListener;
import ru.softlogic.gui.screen.menu.BannerMenuLayerListener;
import ru.softlogic.gui.screen.menu.MenuLayerListener;
import ru.softlogic.gui.utils.menu.GroupByLabelVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;

public class MenuRedirectListener
implements BannerRedirectListener,
RedirectListener {
    private Set<MenuLayerListener> listeners;

    public MenuRedirectListener(Set<MenuLayerListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void onRedirect(int serviceId) {
        for (MenuLayerListener mll : this.listeners) {
            mll.onRedirect(serviceId);
        }
    }

    @Override
    public void onRedirect(int serviceId, Integer bannerId) {
        for (MenuLayerListener mll : this.listeners) {
            if (mll instanceof BannerMenuLayerListener) {
                BannerMenuLayerListener l = (BannerMenuLayerListener)mll;
                l.onRedirect(serviceId, bannerId);
                continue;
            }
            mll.onRedirect(serviceId);
        }
    }

    @Override
    public void toLabel(int label) {
        GroupByLabelVisitor visitor = new GroupByLabelVisitor(label);
        MenuUtils.processMenu(visitor);
        if (visitor.getServiceType() != null) {
            for (MenuLayerListener mll : this.listeners) {
                mll.onGroup(visitor.getServiceType());
            }
        }
    }

    @Override
    public void toLabel(int label, Integer bannerId) {
        this.toLabel(label);
    }
}

