/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.components.button;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import ru.softlogic.gui.components.button.ClickButton;

public class IconifiedClickButton
extends ClickButton {
    private JLabel iconLabel = new JLabel();
    private JLabel titleLabel = new JLabel();
    private boolean onButton = true;

    public IconifiedClickButton(int iconSize, int borderSize, int titleSize) {
        this.setLayout((LayoutManager)new TableLayout(new double[]{borderSize, iconSize, -1.0, titleSize, borderSize}, new double[]{borderSize, -1.0, borderSize}));
        this.add((Component)this.iconLabel, "1,1,c,c");
        this.add((Component)this.titleLabel, "3,1,f,f");
        this.titleLabel.setSize(new Dimension(titleSize, 0));
    }

    public IconifiedClickButton(int borderSize, int titleSize) {
        this.setLayout((LayoutManager)new TableLayout(new double[]{borderSize, -2.0, -1.0, titleSize, borderSize}, new double[]{borderSize, -1.0, borderSize}));
        this.add((Component)this.iconLabel, "1,1,c,c");
        this.add((Component)this.titleLabel, "3,1,f,f");
        this.titleLabel.setSize(new Dimension(titleSize, 0));
    }

    public IconifiedClickButton(int titleSize, String iconPosition, String titlePosition, TableLayout layout) {
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.titleLabel, titlePosition);
        this.add((Component)this.iconLabel, iconPosition);
        this.titleLabel.setSize(new Dimension(titleSize, 0));
    }

    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    @Override
    public void setText(String text) {
        if (this.onButton) {
            super.setText(text);
        } else if (this.titleLabel != null) {
            this.titleLabel.setText(text);
        }
    }

    public void setOnButton(boolean onButton) {
        this.onButton = onButton;
    }
}

