/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.components.button;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.DataButtonListener;

public class DataButton<V>
extends ClickButton {
    private V data;
    private Set<DataButtonListener<V>> listeners = new HashSet<DataButtonListener<V>>();

    public DataButton(String text, String symbol, int pressTime) {
        super(text, symbol, pressTime);
    }

    public DataButton(int pressTime) {
        super(pressTime);
    }

    public DataButton(String text, String symbol) {
        super(text, symbol);
    }

    public DataButton(String text) {
        super(text);
    }

    public DataButton() {
    }

    public DataButton(V data) {
        this.data = data;
    }

    public V getData() {
        return this.data;
    }

    public void setData(V data) {
        this.data = data;
    }

    public void addDataListener(DataButtonListener<V> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeDataListeners() {
        this.listeners.clear();
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        super.fireActionPerformed(event);
        for (DataButtonListener<V> dbl : this.listeners) {
            dbl.update(this.data);
        }
    }
}

