/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.component;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;

public class AdaptiveLabel
extends JLabel {
    private Font baseFont;
    private Font minFont;
    private double hWidth = 0.9;
    private double hHeight = 0.75;
    private Dimension lastSize;
    private Dimension minSize = null;

    public AdaptiveLabel(Font baseFont, Dimension minSize) {
        if (baseFont == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u044d\u0442\u0430\u043b\u043e\u043d\u043d\u043e\u043c \u0448\u0440\u0438\u0444\u0442\u0435");
        }
        this.baseFont = baseFont;
        this.minSize = minSize;
    }

    public AdaptiveLabel(Font baseFont) {
        if (baseFont == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u044d\u0442\u0430\u043b\u043e\u043d\u043d\u043e\u043c \u0448\u0440\u0438\u0444\u0442\u0435");
        }
        this.baseFont = baseFont;
    }

    public AdaptiveLabel(Font baseFont, double hWidth) {
        if (baseFont == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u044d\u0442\u0430\u043b\u043e\u043d\u043d\u043e\u043c \u0448\u0440\u0438\u0444\u0442\u0435");
        }
        this.baseFont = baseFont;
        this.hWidth = hWidth;
    }

    public AdaptiveLabel(Font baseFont, double hWidth, double hHeight) {
        if (baseFont == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u044d\u0442\u0430\u043b\u043e\u043d\u043d\u043e\u043c \u0448\u0440\u0438\u0444\u0442\u0435");
        }
        this.baseFont = baseFont;
        this.hWidth = hWidth;
        this.hHeight = hHeight;
    }

    public void setBaseFont(Font baseFont) {
        this.baseFont = baseFont;
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public void setMinFont(Font minFont) {
        this.minFont = minFont;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.processFont();
    }

    @Override
    public void repaint() {
        Dimension size = this.getSize();
        if (size.height != 0 && !size.equals(this.lastSize)) {
            this.lastSize = size;
            this.processFont();
        }
        super.repaint();
    }

    private void processFont() {
        int height;
        int width;
        String t = this.getText();
        if (t == null) {
            return;
        }
        t = t.replaceAll("<[^>]*>", "");
        if (this.minSize != null) {
            width = (int)((double)this.minSize.width * this.hWidth);
            height = (int)((double)this.minSize.height * this.hHeight);
        } else {
            width = (int)((double)this.getSize().width * this.hWidth);
            height = (int)((double)this.getSize().height * this.hHeight);
        }
        if (this.baseFont != null) {
            int fontSize = this.baseFont.getSize();
            while (true) {
                Font newFont = this.baseFont.deriveFont((float)fontSize);
                if (this.minFont != null && this.minFont.getSize() > newFont.getSize()) {
                    this.setFont(newFont);
                    break;
                }
                FontMetrics fm = this.getFontMetrics(newFont);
                if (!(fm.stringWidth(t) > width && width != 0 || fm.getHeight() > height && height != 0)) {
                    this.setFont(newFont);
                    break;
                }
                --fontSize;
            }
        }
    }
}

