/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.utils;

import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import ru.softlogic.gui.bundle.RefsHelper;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.gui.components.button.LabeledClickButton;
import ru.softlogic.gui.screen.menu.MenuButtonHelper;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.menu.ComplexMenuItem;
import ru.softlogic.gui.utils.menu.HotKeyVisitor;
import ru.softlogic.gui.utils.menu.HotVisitorNg;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui.utils.menu.compare.GroupComparable;
import ru.softlogic.gui.utils.menu.compare.MenuItemComparable;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;

public class ButtonHelper {
    private static final String keyItem = "item";
    private static final String langItem = "lang";
    private static final Logger log = Logger.getLogger((String)"gui");

    public static void initSmallButton(LabeledClickButton cb, MenuItem mi, MenuItemState mis) {
        Object obj = cb.getClientProperty((Object)keyItem);
        boolean needUpdate = false;
        if (obj == null || !(obj instanceof MenuItem)) {
            needUpdate = true;
        } else {
            MenuItem mi2 = (MenuItem)obj;
            boolean bl = needUpdate = mi2.getService().getId() != mi.getService().getId();
        }
        if (needUpdate) {
            Icon icon = BsImageStore.getInstance().getOperatorButtonImage(mi.getService().getImage());
            if (icon == null) {
                cb.setIcon(BsImageStore.getInstance().getOperatorButtonImage(null));
                cb.setPressedIcon(BsImageStore.getInstance().getOperatorButtonPressImage(null));
                cb.setFont(FontFactory.getInstance().createBoldFont("mainmenu.service"));
                cb.setText("<html><p style='width:90%' align='center'>" + mi.getService().getName());
                cb.setForeground(BsConstants.textColor);
                cb.setBorder(BorderFactory.createEmptyBorder(Scaler.y((int)10), Scaler.x((int)10), Scaler.y((int)10), Scaler.x((int)10)));
            } else {
                cb.setIcon(icon);
                cb.setPressedIcon(BsImageStore.getInstance().getOperatorButtonPressImage(mi.getService().getImage()));
            }
        }
        cb.putClientProperty((Object)keyItem, (Object)mi);
        if (mis != null && (mis.getButtonStatus() == ButtonStatus.Blocked || mis.getButtonStatus() == ButtonStatus.Hidden)) {
            cb.setEnabled(false);
        } else {
            cb.setEnabled(true);
        }
    }

    public static void initButton(LabeledClickButton cb, String image, String text) {
        ImageIcon icon = BsImageStore.getInstance().getIcon("/icon/service/" + image);
        if (icon != null) {
            cb.getJLabel().setIcon(icon);
            cb.getJLabel().setText(null);
        } else {
            cb.getJLabel().setIcon(null);
            if (cb.getIcon() != null) {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getIcon().getIconWidth(), (Font)cb.getFont());
            } else {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
    }

    public static void initBigButton(LabeledClickButton cb, String image, String text) {
        ImageIcon icon = BsImageStore.getInstance().getIcon("/icon/service/big/" + image);
        if (icon == null) {
            icon = BsImageStore.getInstance().getIcon("/icon/service/" + image);
        }
        if (icon != null) {
            cb.getJLabel().setIcon(icon);
            cb.getJLabel().setText(null);
        } else {
            cb.getJLabel().setIcon(null);
            if (cb.getIcon() != null) {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getIcon().getIconWidth(), (Font)cb.getFont());
            } else {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
    }

    public static void initButton2(LabeledClickButton cb, String image, String text) {
        ImageIcon icon = BsImageStore.getInstance().getIcon("/icon/face/" + image);
        if (icon != null) {
            cb.getJLabel().setIcon(icon);
            cb.getJLabel().setText(null);
        } else {
            cb.getJLabel().setIcon(null);
            if (cb.getIcon() != null) {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getIcon().getIconWidth(), (Font)cb.getFont());
            } else {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
    }

    public static void initButton2_2(LabeledClickButton cb, String image, String text) {
        ImageIcon icon = BsImageStore.getInstance().getIcon("/icon/face2/" + image);
        ImageIcon iconpress = BsImageStore.getInstance().getIcon("/icon/face2/" + image.replace(".png", "_press.png"));
        cb.getJLabel().setIcon(null);
        if (icon != null) {
            cb.setIcon((Icon)icon);
            cb.setPressedIcon((Icon)iconpress);
            cb.getJLabel().setText(null);
        } else {
            cb.setIcon((Icon)cb.getClientProperty((Object)"def_icon"));
            cb.setPressedIcon((Icon)cb.getClientProperty((Object)"def_icon_press"));
            if (cb.getIcon() != null) {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getIcon().getIconWidth(), (Font)cb.getFont());
            } else {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
    }

    public static void initSmallButton(LabeledClickButton cb, ServiceType st) {
        Object obj = cb.getClientProperty((Object)keyItem);
        boolean needUpdate = false;
        if (obj == null || !(obj instanceof ServiceType)) {
            needUpdate = true;
        } else {
            ServiceType st2 = (ServiceType)obj;
            boolean bl = needUpdate = !st.equals((Object)st2);
        }
        if (needUpdate) {
            ButtonHelper.initButton(cb, st.getImage(), st.getName());
        }
        cb.putClientProperty((Object)keyItem, (Object)st);
        cb.setEnabled(true);
    }

    public static void initSmallButton(LabeledClickButton cb, MenuItem mi, MenuItemState mis, Locale locale) {
        Object obj = cb.getClientProperty((Object)keyItem);
        Locale l = (Locale)cb.getClientProperty((Object)langItem);
        boolean needUpdate = false;
        if (obj == null || !(obj instanceof MenuItem) || !locale.equals(l)) {
            needUpdate = true;
        } else {
            MenuItem mi2 = (MenuItem)obj;
            boolean bl = needUpdate = mi2.getService().getId() != mi.getService().getId();
        }
        if (needUpdate) {
            ButtonHelper.initButton(cb, mi.getService().getImage(), RefsHelper.get((Service)mi.getService(), (Locale)locale).getName());
        }
        cb.putClientProperty((Object)keyItem, (Object)mi);
        cb.putClientProperty((Object)langItem, (Object)locale);
        if (mis != null && (mis.getButtonStatus() == ButtonStatus.Blocked || mis.getButtonStatus() == ButtonStatus.Hidden)) {
            cb.setEnabled(false);
        } else {
            cb.setEnabled(true);
        }
    }

    public static void initSmallServiceButton(IconifiedClickButton cb, ServiceType st) {
        Object obj = cb.getClientProperty((Object)keyItem);
        boolean needUpdate = false;
        if (obj == null || !(obj instanceof ServiceType)) {
            needUpdate = true;
        } else {
            ServiceType st2 = (ServiceType)obj;
            boolean bl = needUpdate = !st.equals((Object)st2);
        }
        if (needUpdate) {
            ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, st.getImage(), BsImageStore.imagePrefixS, cb.getPreferredSize(), false);
            cb.getIconLabel().setIcon(icon);
            cb.getTitleLabel().setText("");
            if (icon == null) {
                MenuButtonHelper.setTextOnButton((IconifiedClickButton)cb, (String)st.getName(), (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
        cb.putClientProperty((Object)keyItem, (Object)st);
        cb.setEnabled(true);
    }

    public static void initSmallServiceButton(IconifiedClickButton cb, MenuItem mi, MenuItemState mis, Locale locale) {
        Object obj = cb.getClientProperty((Object)keyItem);
        Locale l = (Locale)cb.getClientProperty((Object)langItem);
        boolean needUpdate = false;
        if (obj == null || !(obj instanceof MenuItem) || !locale.equals(l)) {
            needUpdate = true;
        } else {
            MenuItem mi2 = (MenuItem)obj;
            boolean bl = needUpdate = mi2.getService().getId() != mi.getService().getId();
        }
        if (needUpdate) {
            ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, mi.getService().getImage(), BsImageStore.imagePrefixS, cb.getPreferredSize(), false);
            cb.getIconLabel().setIcon(icon);
            cb.getTitleLabel().setText("");
            if (icon == null) {
                MenuButtonHelper.setTextOnButton((IconifiedClickButton)cb, (String)RefsHelper.get((Service)mi.getService(), (Locale)locale).getName(), (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
        cb.putClientProperty((Object)keyItem, (Object)mi);
        cb.putClientProperty((Object)langItem, (Object)locale);
        if (mis != null && (mis.getButtonStatus() == ButtonStatus.Blocked || mis.getButtonStatus() == ButtonStatus.Hidden)) {
            cb.setEnabled(false);
        } else {
            cb.setEnabled(true);
        }
    }

    public static void initButton(IconifiedClickButton cb, ServiceType st, Locale locale, String size) {
        Object obj = cb.getClientProperty((Object)keyItem);
        boolean needUpdate = false;
        if (obj == null || !(obj instanceof ServiceType)) {
            needUpdate = true;
        } else {
            ServiceType st2 = (ServiceType)obj;
            boolean bl = needUpdate = !st.equals((Object)st2);
        }
        if (needUpdate) {
            ButtonHelper.initGroupButton(cb, st.getImage(), RefsHelper.get((ServiceType)st, (Locale)locale).getName(), size);
        } else {
            Locale l = (Locale)cb.getClientProperty((Object)langItem);
            if (!locale.equals(l)) {
                MenuButtonHelper.setTextOnButton((JLabel)cb.getTitleLabel(), (String)RefsHelper.get((ServiceType)st, (Locale)locale).getName(), (int)cb.getTitleLabel().getSize().width, (Font)cb.getFont());
            }
        }
        cb.putClientProperty((Object)keyItem, (Object)st);
        cb.putClientProperty((Object)langItem, (Object)locale);
        cb.setEnabled(!Boolean.TRUE.equals(st.getBlocked()));
    }

    public static void initButton(IconifiedClickButton cb, MenuItem mi, MenuItemState mis, Locale locale, String size) {
        Object obj = cb.getClientProperty((Object)keyItem);
        Locale l = (Locale)cb.getClientProperty((Object)langItem);
        boolean needUpdate = false;
        if (obj == null || !(obj instanceof MenuItem) || !locale.equals(l)) {
            needUpdate = true;
        } else {
            MenuItem mi2 = (MenuItem)obj;
            boolean bl = needUpdate = mi2.getService().getId() != mi.getService().getId();
        }
        if (needUpdate) {
            ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, mi.getService().getImage(), size, cb.getPreferredSize(), false);
            if (icon != null) {
                cb.getIconLabel().setIcon(icon);
            } else {
                cb.getIconLabel().setIcon(null);
                MenuButtonHelper.setTextOnButton((IconifiedClickButton)cb, (String)RefsHelper.get((Service)mi.getService(), (Locale)locale).getName(), (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
        cb.putClientProperty((Object)keyItem, (Object)mi);
        cb.putClientProperty((Object)langItem, (Object)locale);
        if (mis != null && (mis.getButtonStatus() == ButtonStatus.Blocked || mis.getButtonStatus() == ButtonStatus.Hidden)) {
            cb.setEnabled(false);
        } else {
            cb.setEnabled(true);
        }
    }

    public static void initButton(LabeledClickButton cb, String image, String text, String size) {
        ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, image, size, cb.getPreferredSize(), false);
        if (icon != null) {
            cb.getJLabel().setIcon(icon);
            cb.getJLabel().setText(null);
        } else {
            cb.getJLabel().setIcon(null);
            if (cb.getIcon() != null) {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getIcon().getIconWidth(), (Font)cb.getFont());
            } else {
                MenuButtonHelper.setTextOnButton((LabeledClickButton)cb, (String)text, (int)cb.getSize().width, (Font)cb.getFont());
            }
        }
    }

    public static void initGroupButton(IconifiedClickButton cb, String image, String text, String size) {
        ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageGroupPath, image, size, new Dimension(Scaler.x((int)296), Scaler.y((int)130)), false);
        cb.getIconLabel().setIcon(icon);
        MenuButtonHelper.setTextOnButton((JLabel)cb.getTitleLabel(), (String)text, (int)cb.getTitleLabel().getSize().width, (Font)cb.getFont());
    }

    public static void initSmallImagedLabel(JLabel titleLabel, ServiceType st, Dimension size, String imageSize, String path) {
        titleLabel.setFont(FontFactory.getInstance().createFont("mainmenu.hotkeybutton"));
        ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(path, st.getImage(), imageSize, size, false);
        if (icon != null) {
            titleLabel.setIcon(icon);
        } else {
            titleLabel.setIcon(null);
            MenuButtonHelper.setTextOnButton((JLabel)titleLabel, (String)st.getName(), (int)size.width, (Font)titleLabel.getFont());
        }
    }

    public static int initHotKeys(IconifiedClickButton bigButton, IconifiedClickButton[] hotButtons, int hotMax, boolean addHotToMax, Locale locale, ServiceType currentST) {
        for (IconifiedClickButton hotButton : hotButtons) {
            hotButton.setVisible(false);
        }
        HotVisitorNg hkv = new HotVisitorNg(hotMax, addHotToMax, false, true);
        MenuUtils.processMenu((MenuVisitor)hkv, (ServiceType)currentST);
        List res = hkv.getSortedItems();
        if (res == null || res.isEmpty()) {
            return 0;
        }
        int index = 0;
        for (int i = 0; i < res.size() && i < (bigButton != null ? hotButtons.length + 1 : hotButtons.length); ++i) {
            if (res.get(i) instanceof MenuItemComparable) {
                MenuItemComparable mic = (MenuItemComparable)res.get(i);
                ComplexMenuItem mi = mic.getItem();
                if (index == 0 && bigButton != null) {
                    ButtonHelper.initButton(bigButton, mi.getMenuItem(), mi.getState(), locale, BsImageStore.imagePrefixL);
                    if (mi.getState() != null && (mi.getState().getButtonStatus() == ButtonStatus.Blocked || mi.getState().getButtonStatus() == ButtonStatus.Hidden)) {
                        bigButton.setEnabled(false);
                    } else {
                        bigButton.setEnabled(true);
                    }
                    ++index;
                    continue;
                }
                ButtonHelper.initSmallServiceButton(hotButtons[i - index], mi.getMenuItem(), mi.getState(), locale);
                hotButtons[i - index].setVisible(true);
                continue;
            }
            if (!(res.get(i) instanceof GroupComparable)) continue;
            GroupComparable gc = (GroupComparable)res.get(i);
            ServiceType st = gc.getServiceType();
            if (index == 0 && bigButton != null) {
                ButtonHelper.initButton(bigButton, st, locale, BsImageStore.imagePrefixL);
                if (st.getBlocked().booleanValue() || st.getHidden()) {
                    bigButton.setEnabled(false);
                } else {
                    bigButton.setEnabled(true);
                }
                ++index;
                continue;
            }
            ButtonHelper.initSmallServiceButton(hotButtons[i - index], st);
            hotButtons[i - index].setVisible(true);
        }
        return res.size();
    }

    public static int initHotKeys(IconifiedClickButton bigButton, IconifiedClickButton[] hotButtons, int hotMax, boolean addHotToMax, Locale locale) {
        HotKeyVisitor hkv = new HotKeyVisitor(hotMax, addHotToMax);
        MenuUtils.processMenu((MenuVisitor)hkv);
        ComplexMenuItem[] items = hkv.getSortedItems();
        ButtonHelper.initButton(bigButton, items[0].getMenuItem(), items[0].getState(), locale, BsImageStore.imagePrefixL);
        if (items[0] != null && items[0].getState() != null && (items[0].getState().getButtonStatus() == ButtonStatus.Blocked || items[0].getState().getButtonStatus() == ButtonStatus.Hidden)) {
            bigButton.setEnabled(false);
        } else {
            bigButton.setEnabled(true);
        }
        for (int i = 1; i < items.length && i < hotButtons.length; ++i) {
            ComplexMenuItem cmi = items[i];
            IconifiedClickButton button = hotButtons[i];
            ButtonHelper.initSmallServiceButton(button, cmi.getMenuItem(), cmi.getState(), locale);
            if (cmi != null && cmi.getState() != null && (cmi.getState().getButtonStatus() == ButtonStatus.Blocked || cmi.getState().getButtonStatus() == ButtonStatus.Hidden)) {
                button.setEnabled(false);
            } else {
                button.setEnabled(true);
            }
            button.setVisible(true);
        }
        return items.length;
    }
}

