/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.popup.panel;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.screen.popup.dialog.custom.CompleteInit;
import ru.softlogic.gui.screen.popup.dialog.custom.CompletePanel;
import ru.softlogic.gui.screen.popup.dialog.custom.PanelListener;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui.utils.ComponentUtil;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.bwlist.PersonalNumberType;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.CommissionUnit;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.factory.BsButtonFactory;
import ru.softlogic.skin.kengu24.popup.panel.BsDialogPanel;

public class ComissionDialogPanel
extends BsDialogPanel
implements CompletePanel {
    private Logger log = Logger.getLogger((String)"gui");
    private ClickButton closeButton;
    private PanelListener listener;
    private JLabel titleLabel;
    private JPanel emptyPanel;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JPanel headerPanel;
    private JPanel tablePanel;
    private Commission commission;
    private int xIndexHeader = 1;
    private int yIndexHeader = 1;
    private int colorIndex = 0;
    private List<Color> colorList = new ArrayList<Color>();
    private JScrollPane scroll;

    public ComissionDialogPanel() {
        this.colorList.add(new Color(203, 205, 142));
        this.colorList.add(new Color(148, 118, 103));
        this.colorList.add(new Color(183, 206, 228));
        this.mainPanel = ComponentUtil.createImagePanelBySize((Dimension)new Dimension(Scaler.x((int)800), Scaler.y((int)600)));
        this.mainPanel.setBackground(Color.WHITE);
        this.mainPanel.setBorder(BorderFactory.createLineBorder(BsConstants.borderColorCommissionDialog, 5));
        this.mainPanel.setOpaque(true);
        this.mainPanel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{Scaler.y((int)25), Scaler.y((int)40), Scaler.y((int)20), -1.0, Scaler.y((int)80), Scaler.y((int)25)}));
        this.emptyPanel = new JPanel();
        this.emptyPanel.setOpaque(false);
        this.emptyPanel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{-1.0}));
        String noCommText = kb.getString("Screen.std.sum.nocomm");
        if (!noCommText.contains("<html>")) {
            noCommText = "<html><p align='center'>" + kb.getString("Screen.std.sum.nocomm");
        }
        JLabel emptyLabel = new JLabel();
        emptyLabel.setVerticalAlignment(0);
        emptyLabel.setHorizontalAlignment(0);
        emptyLabel.setFont(FontFactory.getInstance().createBoldFont("content.infoscreen"));
        emptyLabel.setText(noCommText);
        emptyLabel.setForeground(BsConstants.textColorBlack);
        this.emptyPanel.add((Component)emptyLabel, "0,0");
        this.contentPanel = new JPanel();
        this.contentPanel.setOpaque(false);
        this.contentPanel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)80), -1.0, Scaler.x((int)80)}, new double[]{0.0, -2.0, -2.0, -1.0}));
        this.titleLabel = new JLabel();
        this.titleLabel.setVerticalAlignment(1);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setFont(FontFactory.getInstance().createBoldFont("content.infoscreen"));
        this.titleLabel.setText(kb.getString("Screen.std.comission.screen.title"));
        this.titleLabel.setForeground(BsConstants.textColorBlack);
        this.mainPanel.add((Component)this.titleLabel, "0,1");
        this.headerPanel = new JPanel();
        this.headerPanel.setOpaque(false);
        this.contentPanel.add((Component)this.headerPanel, "1,1");
        this.tablePanel = new JPanel();
        this.tablePanel.setOpaque(false);
        this.contentPanel.add((Component)this.tablePanel, "1,2");
        this.closeButton = BsButtonFactory.createDialogButton(kb.getString("button.close"));
        this.closeButton.addActionListener((ActionListener)new CloseListener());
        this.mainPanel.add((Component)this.closeButton, "0,4");
        this.scroll = new JScrollPane();
        this.scroll.setViewportView(this.contentPanel);
        this.scroll.setOpaque(false);
        this.scroll.setBorder(null);
        this.scroll.setViewportBorder(null);
        this.scroll.getViewport().setOpaque(false);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                UserAction.getInstance().update();
            }
        });
        this.mainPanel.add((Component)this.scroll, "0,3");
        this.emptyPanel.setVisible(false);
        this.mainPanel.add((Component)this.emptyPanel, "0,0,0,3");
    }

    public void setListener(PanelListener listener) {
        this.listener = listener;
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    private Commission selectMaxPrioritetCommission(CompleteInit init) {
        Sum maxCom;
        Sum com;
        Sum minCom;
        Sum compareSum;
        Commission miCommission;
        InputElement personalNumbers = (PersonalNumber[])init.getData().get("pernumbers");
        this.log.info((Object)("personalNumbers = " + Arrays.toString((Object[])personalNumbers)));
        Commission currentCommission = miCommission = init.getMenuItem().getCommission();
        Commission maxCommission = init.getService().getCommission();
        Commission minCommission = init.getService().getMinComm();
        boolean ignoreMinMaxCommission = init.getMenuItem().isIgnoreMinMaxCommission();
        Map screenData = (Map)init.getData().get("screen-data");
        Sum sum = null;
        Sum keeperSum = (Sum)init.getData().get("keeper-sum");
        if (keeperSum != null && keeperSum instanceof Sum) {
            sum = keeperSum;
        }
        if (screenData != null) {
            Object obj = screenData.get("#sum");
            if (obj != null) {
                InputElement sumIE;
                if (obj instanceof TransactionSum) {
                    TransactionSum ts = (TransactionSum)obj;
                    sum = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
                } else if (obj instanceof InputElement && (sumIE = (InputElement)obj).getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                    sum = new Sum(Double.parseDouble(sumIE.getValue()));
                }
            }
            if (personalNumbers != null && ((Object[])personalNumbers).length > 0) {
                block0: for (InputElement pn : personalNumbers) {
                    for (String key : screenData.keySet()) {
                        InputElement value;
                        obj = screenData.get(key);
                        if (obj == null || !(obj instanceof InputElement) || key.equals("#sum") || !(value = (InputElement)obj).getValue().equals(pn.getNumber()) || pn.getType() != PersonalNumberType.White) continue;
                        currentCommission = pn.getCommission();
                        continue block0;
                    }
                }
            }
        }
        if (currentCommission == null || ignoreMinMaxCommission) {
            return currentCommission;
        }
        if (minCommission != null && maxCommission != null && maxCommission.getId() == minCommission.getId()) {
            return maxCommission;
        }
        Sum sum2 = compareSum = sum != null ? sum : new Sum(1000);
        if (minCommission != null && (minCom = CommissionCalculator.calculateCommissionSum((Sum)compareSum, null, (Commission)minCommission, null, null, null, (Date)init.getDateOfStartPayment(), (String)init.getCashSource())).compareTo(com = CommissionCalculator.calculateCommissionSum((Sum)compareSum, null, (Commission)currentCommission, null, null, null, (Date)init.getDateOfStartPayment(), (String)init.getCashSource())) > 0) {
            currentCommission = minCommission;
        }
        if (maxCommission != null && (maxCom = CommissionCalculator.calculateCommissionSum((Sum)compareSum, null, (Commission)maxCommission, null, null, null, (Date)init.getDateOfStartPayment(), (String)init.getCashSource())).compareTo(com = CommissionCalculator.calculateCommissionSum((Sum)compareSum, null, (Commission)currentCommission, null, null, null, (Date)init.getDateOfStartPayment(), (String)init.getCashSource())) < 0) {
            currentCommission = maxCommission;
        }
        return currentCommission;
    }

    public void init(CompleteInit init) {
        try {
            this.scroll.getVerticalScrollBar().setValue(0);
            this.scroll.repaint();
            this.contentPanel.setVisible(true);
            this.titleLabel.setVisible(true);
            this.emptyPanel.setVisible(false);
            this.commission = this.selectMaxPrioritetCommission(init);
            this.log.info((Object)("CommissionDialog init: init.getCommission() = " + this.commission));
            this.colorIndex = 0;
            this.xIndexHeader = 1;
            this.yIndexHeader = 1;
            kb.setLocale(init.getLocale());
            ArrayList<String> headersArray = new ArrayList<String>();
            if (this.commission != null) {
                int index;
                if (this.commission.getMin() != null && this.commission.getMin().getBasicSum() > 0) {
                    headersArray.add(kb.getString("Screen.std.sum.mincomm") + this.commission.getMin().toString());
                }
                if (this.commission.getMax() != null && this.commission.getMax().getBasicSum() > 0) {
                    headersArray.add(kb.getString("Screen.std.sum.maxcomm") + this.commission.getMax().toString());
                }
                if (this.commission.getFixedValue() != null && this.commission.getFixedValue().getBasicSum() > 0) {
                    headersArray.add(MessageFormat.format(kb.getString("Screen.std.comission.screen.fix"), this.commission.getFixedValue().toString()));
                }
                if (this.commission.getPercentValue() > 0.0) {
                    headersArray.add(MessageFormat.format(kb.getString("Screen.std.comission.screen.percent"), this.commission.getPercentValue()));
                }
                int allRowsSize = 0;
                ArrayList rowsMapList = new ArrayList();
                ArrayList<ArrayList> headersMapList = new ArrayList<ArrayList>();
                Color tableHeaderColor = new Color(183, 206, 228);
                if (this.commission.getSteps() != null) {
                    ArrayList<CommissionStep> comStepList = new ArrayList<CommissionStep>();
                    for (CommissionStep cs : this.commission.getSteps()) {
                        if (!CommissionCalculator.isStepEnable((CommissionStep)cs, (Date)init.getDateOfStartPayment(), (String)"CASH")) continue;
                        comStepList.add(cs);
                    }
                    if (!comStepList.isEmpty()) {
                        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
                        headersMapList.add(new ArrayList<String>(){
                            {
                                this.add(kb.getString("Screen.std.sum.income2"));
                                this.add(kb.getString("Screen.std.sum.commval"));
                            }
                        });
                        ++allRowsSize;
                        CommissionStep[] comStepsArray = comStepList.toArray(new CommissionStep[comStepList.size()]);
                        for (index = 0; index < comStepsArray.length; ++index) {
                            CommissionStep cs = comStepsArray[index];
                            Object key = "";
                            String value = "";
                            if (index < comStepsArray.length - 1) {
                                CommissionStep cs2 = comStepsArray[index + 1];
                                key = MessageFormat.format(kb.getString("Screen.std.comission.screen.fromto"), cs.getSum(), cs2.getSum());
                            } else {
                                key = MessageFormat.format(kb.getString("Screen.std.comission.screen.from"), cs.getSum());
                            }
                            value = cs.getFixedValue().getSum() > 0.0 && cs.getPercentValue() > 0.0 ? MessageFormat.format(kb.getString("Screen.std.comission.screen.step.percentfix"), cs.getPercentValue(), cs.getFixedValue()) : (cs.getPercentValue() > 0.0 ? MessageFormat.format(kb.getString("Screen.std.comission.screen.step.percent"), cs.getPercentValue()) : cs.getFixedValue().toString());
                            map.put(key, value);
                            ++allRowsSize;
                        }
                        rowsMapList.add(map);
                    }
                }
                if (this.commission.getUnits() != null && !this.commission.getUnits().isEmpty()) {
                    Sum percent;
                    Map<Sum, Sum> notes = this.getNotes();
                    Map<Sum, Sum> coins = this.getCoins();
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    boolean flag = true;
                    Sum lastPercent = null;
                    if (notes != null && !notes.isEmpty()) {
                        for (Sum nominal : notes.keySet()) {
                            percent = notes.get(nominal).div(nominal.getSum()).mul(100);
                            if (lastPercent == null) {
                                lastPercent = percent;
                            } else if (!percent.equals((Object)lastPercent)) {
                                flag = false;
                            }
                            map.put(nominal.toString(), notes.get(nominal).toString());
                        }
                        if (flag) {
                            map.clear();
                            headersArray.add(kb.getString("Screen.std.sum.notecomm") + " " + MessageFormat.format(kb.getString("Screen.std.comission.screen.step.percent"), lastPercent.getSum()));
                        } else {
                            allRowsSize += map.size();
                        }
                        if (map.size() > 0 && !flag) {
                            rowsMapList.add(map);
                            headersMapList.add(new ArrayList<String>(){
                                {
                                    this.add(kb.getString("Screen.std.comission.screen.unit.edtitle"));
                                    this.add(kb.getString("Screen.std.sum.notecomm"));
                                }
                            });
                            ++allRowsSize;
                        }
                    }
                    map = new LinkedHashMap();
                    flag = true;
                    lastPercent = null;
                    if (coins != null && !coins.isEmpty()) {
                        for (Sum nominal : coins.keySet()) {
                            percent = coins.get(nominal).div(nominal.getSum()).mul(100);
                            if (lastPercent == null) {
                                lastPercent = percent;
                            } else if (!percent.equals((Object)lastPercent)) {
                                flag = false;
                            }
                            map.put(nominal.toString(), coins.get(nominal).toString());
                        }
                        if (flag) {
                            map.clear();
                            headersArray.add(kb.getString("Screen.std.sum.coincomm") + " " + MessageFormat.format(kb.getString("Screen.std.comission.screen.step.percent"), lastPercent.getSum()));
                        } else {
                            allRowsSize += map.size();
                        }
                        if (map.size() > 0 && !flag) {
                            rowsMapList.add(map);
                            headersMapList.add(new ArrayList<String>(){
                                {
                                    this.add(kb.getString("Screen.std.comission.screen.unit.edtitle"));
                                    this.add(kb.getString("Screen.std.sum.coincomm"));
                                }
                            });
                            ++allRowsSize;
                        }
                    }
                }
                if (headersArray.size() > 0) {
                    double[] headerList = new double[headersArray.size() + 2];
                    headerList[0] = Scaler.y((int)0);
                    for (int i = 1; i <= headersArray.size(); i += 2) {
                        headerList[i] = Scaler.y((int)40);
                        headerList[i + 1] = Scaler.y((int)10);
                    }
                    this.headerPanel.removeAll();
                    if (headersArray.size() > 1) {
                        this.headerPanel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)0), Scaler.x((int)307), Scaler.x((int)16), Scaler.x((int)307), Scaler.x((int)0)}, headerList));
                    } else {
                        this.headerPanel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0, Scaler.x((int)307), -1.0}, headerList));
                    }
                    for (String name : headersArray) {
                        this.addLabelToHeaderTextColor(name);
                    }
                }
                double[] yRowsLayout = new double[allRowsSize + 1];
                int curI = 0;
                for (int i = 0; i < rowsMapList.size(); ++i) {
                    Map rowsMap = (Map)rowsMapList.get(i);
                    yRowsLayout[curI] = Scaler.y((int)50);
                    ++curI;
                    for (int j = 0; j < rowsMap.size(); ++j) {
                        yRowsLayout[curI] = Scaler.y((int)37);
                        ++curI;
                    }
                }
                this.tablePanel.removeAll();
                this.tablePanel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)320), Scaler.x((int)320)}, yRowsLayout));
                int y = 0;
                for (index = 0; index < rowsMapList.size(); ++index) {
                    Map rowsMap = (Map)rowsMapList.get(index);
                    ArrayList headers = (ArrayList)headersMapList.get(index);
                    if (rowsMap.size() <= 0) continue;
                    if (headers.size() > 0) {
                        JLabel header1Label = BsButtonFactory.createComissionInfoLabelBackground(tableHeaderColor, false);
                        header1Label.setText((String)headers.get(0));
                        this.tablePanel.add((Component)header1Label, "0," + y);
                        if (headers.size() > 1) {
                            JLabel header2Label = BsButtonFactory.createComissionInfoLabelBackground(tableHeaderColor, false);
                            header2Label.setText((String)headers.get(1));
                            this.tablePanel.add((Component)header2Label, "1," + y);
                        }
                        ++y;
                    }
                    for (String key : rowsMap.keySet()) {
                        JLabel keyLabel = BsButtonFactory.createComissionTableLabel(tableHeaderColor);
                        keyLabel.setText(key);
                        this.tablePanel.add((Component)keyLabel, "0, " + y);
                        JLabel valueLabel = BsButtonFactory.createComissionTableLabel(tableHeaderColor);
                        valueLabel.setText((String)rowsMap.get(key));
                        this.tablePanel.add((Component)valueLabel, "1, " + y);
                        if (++y < yRowsLayout.length) continue;
                        break;
                    }
                    if (y >= yRowsLayout.length) break;
                }
                if (allRowsSize == 0 && headersArray.isEmpty()) {
                    this.contentPanel.setVisible(false);
                    this.titleLabel.setVisible(false);
                    this.emptyPanel.setVisible(true);
                }
            } else {
                this.contentPanel.setVisible(false);
                this.titleLabel.setVisible(false);
                this.emptyPanel.setVisible(true);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("CommissionDialogPanel.init: " + ex.getMessage()));
            this.log.error((Object)("CommissionDialogPanel.init.stackTrace: " + Arrays.toString(ex.getStackTrace())));
        }
    }

    private Map<Sum, Sum> getNotes() {
        HashSet units = this.commission.getUnits();
        TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
        if (units != null && !units.isEmpty()) {
            HashMap<Integer, CashUnit> unitsList = new HashMap<Integer, CashUnit>();
            for (CashUnit cu : CashFactory.getDefaultInstance().getCoinUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            for (CashUnit cu : CashFactory.getDefaultInstance().getCashUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            for (CommissionUnit unit : units) {
                CashUnit cu;
                if (unit.getFixedValue().getSum() == 0.0 || (cu = (CashUnit)unitsList.get(unit.getCashUnit())) == null || cu.getType() != 3) continue;
                notes.put(cu.getNominal(), unit.getFixedValue());
            }
        }
        return notes;
    }

    private Map<Sum, Sum> getCoins() {
        HashSet units = this.commission.getUnits();
        TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
        if (units != null && !units.isEmpty()) {
            HashMap<Integer, CashUnit> unitsList = new HashMap<Integer, CashUnit>();
            for (CashUnit cu : CashFactory.getDefaultInstance().getCoinUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            for (CashUnit cu : CashFactory.getDefaultInstance().getCashUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            for (CommissionUnit unit : units) {
                CashUnit cu;
                if (unit.getFixedValue().getSum() == 0.0 || (cu = (CashUnit)unitsList.get(unit.getCashUnit())) == null || cu.getType() != 4) continue;
                coins.put(cu.getNominal(), unit.getFixedValue());
            }
        }
        return coins;
    }

    private void addLabelToHeaderTextColor(String text) {
        if (this.colorIndex >= this.colorList.size()) {
            this.colorIndex = 0;
        }
        Color backColor = this.colorList.get(this.colorIndex);
        ++this.colorIndex;
        JLabel label = BsButtonFactory.createComissionInfoLabelBackground(backColor, true);
        label.setText(text);
        this.headerPanel.add((Component)label, this.xIndexHeader + "," + this.yIndexHeader);
        this.xIndexHeader += 2;
        if (this.xIndexHeader > 3) {
            this.xIndexHeader = 1;
            this.yIndexHeader += 2;
        }
    }

    private class CloseListener
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ComissionDialogPanel.this.listener != null) {
                ComissionDialogPanel.this.listener.onUserAction(null);
            }
        }
    }
}

