/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.popup.panel;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import ru.softlogic.gui.screen.popup.lock.LockScreen;
import ru.softlogic.gui.screen.popup.lock.LockScreenClick;
import ru.softlogic.gui.screen.popup.lock.LockScreenListener;
import ru.softlogic.gui.utils.ComponentUtil;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.bundle.FontFactory;

public class BsLockScreen
implements LockScreen {
    private JLabel label;
    private JProgressBar progressBar;
    private JPanel panel = ComponentUtil.createImagePanelBySize((Dimension)new Dimension(Scaler.x((int)800), Scaler.y((int)600)));
    private LocalMouseLisener localMouseLisener;
    private LockScreenListener listener;

    public BsLockScreen() {
        this.panel.setBackground(BsConstants.backColor);
        this.panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)20), -1.0, Scaler.x((int)20)}, new double[]{Scaler.y((int)20), -1.0, Scaler.y((int)20), Scaler.y((int)20)}));
        this.label = new JLabel();
        this.label.setVerticalAlignment(1);
        this.label.setFont(FontFactory.getInstance().createFont("popup.dialog.label"));
        this.label.setForeground(BsConstants.textColorBlue);
        this.panel.add((Component)this.label, "1,1");
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximumSize(new Dimension(this.panel.getWidth() / 2, this.panel.getHeight() / 2));
        this.progressBar.setIndeterminate(true);
        this.panel.add((Component)this.progressBar, "1,2");
        this.localMouseLisener = new LocalMouseLisener();
        this.panel.addMouseListener(this.localMouseLisener);
        this.label.addMouseListener(this.localMouseLisener);
        this.progressBar.addMouseListener(this.localMouseLisener);
    }

    public void setText(String text) {
        this.label.setText("<html><p style='margin-left:20px;' align='center'>" + text.toUpperCase() + "</font></p></html>");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setListener(LockScreenListener listener) {
        this.listener = listener;
    }

    private class LocalMouseLisener
    extends MouseAdapter {
        private LocalMouseLisener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int h = BsLockScreen.this.panel.getHeight();
            int w = BsLockScreen.this.panel.getWidth();
            int x = e.getLocationOnScreen().x - BsLockScreen.this.panel.getX();
            int y = e.getLocationOnScreen().y - BsLockScreen.this.panel.getY();
            int area = -1;
            area = y < h / 2 ? (x < w / 3 ? 1 : (x < w * 2 / 3 ? 2 : 3)) : (x < w / 3 ? 4 : (x < w * 2 / 3 ? 5 : 6));
            if (area > 0 && BsLockScreen.this.listener != null) {
                BsLockScreen.this.listener.onAreaClick(new LockScreenClick(area));
            }
        }
    }
}

