/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.LabeledClickButton;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui2.keyboard.GuiKeyboard;
import ru.softlogic.gui2.keyboard.KeySettings;
import ru.softlogic.gui2.keyboard.KeyboardListener;
import ru.softlogic.gui2.keyboard.SetConfiguration;
import ru.softlogic.gui2.keyboard.letter.StandartKeyFactory;
import ru.softlogic.gui2.keyboard.loader.SetLoader;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.factory.CpLetterKeyFactory;

public class CpLetterKeyboard
implements GuiKeyboard {
    private SetLoader setLoader;
    private JPanel main;
    private Set<KeyboardListener> listeners;
    private Locale locale;
    private Keyboard keyboard;
    private ClickButton[][] letters;
    private LabeledClickButton set11;
    private LabeledClickButton set12rus;
    private LabeledClickButton set12eng;
    private LabeledClickButton set2;
    private LabeledClickButton set3;
    private LabeledClickButton caps;
    private LabeledClickButton space;
    private LabeledClickButton lshift;
    private LabeledClickButton rshift;
    private LabeledClickButton enter;
    private LabeledClickButton tab;
    private LabeledClickButton cleanrus;
    private LabeledClickButton cleaneng;
    private ClickButton clear;
    private String currentSetName;
    private String lastSetName;
    private KeyboardCase currentCase;
    private SetConfiguration currentSet;
    private Map<String, String> keyMapping;
    private boolean shiftPressed;
    private CapsActionListener capsListener;
    private ImagePanel rus;
    private ImagePanel eng;

    public CpLetterKeyboard(StandartKeyFactory factory, SetLoader setLoader) {
        int i;
        int i2;
        int i3;
        if (setLoader == null) {
            throw new NullPointerException("SetLoader");
        }
        this.setLoader = setLoader;
        this.main = new JPanel();
        double borderx = -1.0;
        double bordery = Scaler.y((int)5);
        this.main.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{0.0, -2.0, -1.0, bordery, -2.0, bordery, -2.0, bordery, -2.0, bordery, -2.0}));
        this.letters = new ClickButton[4][];
        this.letters[0] = new ClickButton[14];
        this.letters[1] = new ClickButton[13];
        this.letters[2] = new ClickButton[11];
        this.letters[3] = new ClickButton[11];
        JPanel langpnl = new JPanel();
        langpnl.setOpaque(false);
        langpnl.setLayout((LayoutManager)new TableLayout(new double[]{-1.0, -2.0}, new double[]{-2.0}));
        this.rus = new ImagePanel(BsImageStore.getInstance().getImage("buttons/keyboard/eng.png"), true);
        this.eng = new ImagePanel(BsImageStore.getInstance().getImage("buttons/keyboard/rus.png"), true);
        langpnl.add((Component)this.eng, "1,0,c,c");
        langpnl.add((Component)this.rus, "1,0,c,c");
        this.main.add((Component)langpnl, "0,1,f,f");
        JPanel row1 = new JPanel();
        row1.setOpaque(false);
        double[] cols = new double[30];
        for (int i4 = 0; i4 < cols.length; i4 += 2) {
            cols[i4] = -2.0;
            cols[i4 + 1] = borderx;
        }
        cols[cols.length - 1] = 0.0;
        row1.setLayout((LayoutManager)new TableLayout(cols, new double[]{-1.0}));
        this.main.add((Component)row1, "0,2,f,f");
        LocalActionListener al = new LocalActionListener();
        for (int i5 = 0; i5 < this.letters[0].length; ++i5) {
            ClickButton cb = factory.createKey(0, 0);
            cb.addActionListener((ActionListener)al);
            this.letters[0][i5] = cb;
            row1.add((Component)cb, "" + i5 * 2 + ",0,c,c");
        }
        this.clear = factory.createBackspace();
        this.clear.addActionListener((ActionListener)al);
        row1.add((Component)this.clear, "28,0,c,c");
        JPanel row2 = new JPanel();
        row2.setOpaque(false);
        cols = new double[28];
        for (i3 = 0; i3 < cols.length; i3 += 2) {
            cols[i3] = -2.0;
            cols[i3 + 1] = borderx;
        }
        cols[cols.length - 1] = 0.0;
        row2.setLayout((LayoutManager)new TableLayout(cols, new double[]{-1.0}));
        this.main.add((Component)row2, "0,4,f,f");
        this.tab = factory.createCaps();
        this.tab.addActionListener((ActionListener)al);
        row2.add((Component)this.tab, "0,0,c,c");
        for (i3 = 0; i3 < this.letters[1].length; ++i3) {
            ClickButton cb = factory.createKey(0, 0);
            cb.addActionListener((ActionListener)al);
            this.letters[1][i3] = cb;
            row2.add((Component)cb, "" + (i3 + 1) * 2 + ",0,c,c");
        }
        this.letters[1][12].setIcon((Icon)BsImageStore.getInstance().getIcon("buttons/keyboard/caps.png"));
        this.letters[1][12].setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/keyboard/caps_press.png"));
        if (this.letters[1][12].getIcon() != null) {
            Dimension dim = new Dimension(this.letters[1][12].getIcon().getIconWidth(), this.letters[1][12].getIcon().getIconHeight());
            this.letters[1][12].setSize(dim);
            this.letters[1][12].setMinimumSize(dim);
            this.letters[1][12].setMaximumSize(dim);
            this.letters[1][12].setPreferredSize(dim);
        }
        JPanel row3 = new JPanel();
        row3.setOpaque(false);
        cols = new double[26];
        for (i2 = 0; i2 < cols.length; i2 += 2) {
            cols[i2] = -2.0;
            cols[i2 + 1] = borderx;
        }
        cols[cols.length - 1] = 0.0;
        row3.setLayout((LayoutManager)new TableLayout(cols, new double[]{-1.0}));
        this.main.add((Component)row3, "0,6,f,f");
        this.caps = factory.createCaps();
        this.capsListener = new CapsActionListener();
        this.caps.addActionListener((ActionListener)this.capsListener);
        row3.add((Component)this.caps, "0,0,c,c");
        for (i2 = 0; i2 < this.letters[2].length; ++i2) {
            ClickButton cb = factory.createKey(0, 0);
            cb.addActionListener((ActionListener)al);
            this.letters[2][i2] = cb;
            row3.add((Component)cb, "" + (i2 + 1) * 2 + ",0,c,c");
        }
        this.enter = (LabeledClickButton)factory.createEnter();
        this.enter.addActionListener((ActionListener)al);
        row3.add((Component)this.enter, "24,0,c,c");
        JPanel row4 = new JPanel();
        row4.setOpaque(false);
        cols = new double[28];
        for (i = 0; i < cols.length; i += 2) {
            cols[i] = -2.0;
            cols[i + 1] = borderx;
        }
        cols[cols.length - 1] = 0.0;
        row4.setLayout((LayoutManager)new TableLayout(cols, new double[]{-1.0}));
        this.main.add((Component)row4, "0,8,f,f");
        this.set11 = ((CpLetterKeyFactory)factory).createShift("l");
        this.set11.addActionListener((ActionListener)new Set1ActionListener());
        row4.add((Component)this.set11, "0,0,c,c");
        this.set12rus = ((CpLetterKeyFactory)factory).createShift("l");
        this.set12rus.addActionListener((ActionListener)new Set12ActionListener());
        row4.add((Component)this.set12rus, "0,0,c,c");
        this.set12eng = ((CpLetterKeyFactory)factory).createShift("l");
        this.set12eng.addActionListener((ActionListener)new Set12ActionListener());
        row4.add((Component)this.set12eng, "0,0,c,c");
        this.lshift = ((CpLetterKeyFactory)factory).createShift("l");
        this.lshift.addActionListener((ActionListener)new Set1ActionListener());
        for (i = 0; i < this.letters[3].length; ++i) {
            ClickButton cb = factory.createKey(0, 0);
            cb.addActionListener((ActionListener)al);
            this.letters[3][i] = cb;
            row4.add((Component)cb, "" + (i + 1) * 2 + ",0,c,c");
        }
        this.rshift = ((CpLetterKeyFactory)factory).createShift("r");
        this.rshift.addActionListener((ActionListener)al);
        row4.add((Component)this.rshift, "26,0,c,c");
        JPanel row5 = new JPanel();
        row5.setOpaque(false);
        cols = new double[6];
        for (int i6 = 0; i6 < cols.length; i6 += 2) {
            cols[i6] = -2.0;
            cols[i6 + 1] = borderx;
        }
        cols[cols.length - 1] = 0.0;
        row5.setLayout((LayoutManager)new TableLayout(cols, new double[]{-1.0}));
        this.main.add((Component)row5, "0,10,f,f");
        this.space = factory.createSpace();
        this.space.addActionListener((ActionListener)al);
        row5.add((Component)this.space, "2,0,c,c");
        this.set2 = factory.createSet2();
        this.set2.addActionListener((ActionListener)new Set2ActionListener());
        row5.add((Component)this.set2, "0,0,c,c");
        this.set3 = factory.createSet3();
        this.set3.addActionListener((ActionListener)new Set3ActionListener());
        row5.add((Component)this.set3, "0,0,c,c");
        this.cleanrus = factory.createSet3();
        this.cleanrus.addActionListener((ActionListener)al);
        row5.add((Component)this.cleanrus, "4,0,c,c");
        this.cleaneng = factory.createSet3();
        this.cleaneng.addActionListener((ActionListener)al);
        row5.add((Component)this.cleaneng, "4,0,c,c");
        this.listeners = new HashSet<KeyboardListener>();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            Map keys = this.setLoader.readKeySettings(locale);
            if (keys != null) {
                this.initButton((ClickButton)this.set11, (KeySettings)keys.get("set1on"));
                this.initButton((ClickButton)this.set12rus, (KeySettings)keys.get("set1offrus"));
                this.initButton((ClickButton)this.set12eng, (KeySettings)keys.get("set1offeng"));
                this.initButton((ClickButton)this.set2, (KeySettings)keys.get("set2"));
                this.initButton((ClickButton)this.set3, (KeySettings)keys.get("set3"));
                this.initButton((ClickButton)this.caps, (KeySettings)keys.get("caps"));
                this.initButton((ClickButton)this.space, (KeySettings)keys.get("space"));
                this.initButton(this.clear, (KeySettings)keys.get("clear-all"));
                this.initButton((ClickButton)this.lshift, (KeySettings)keys.get("shift"));
                this.initButton((ClickButton)this.lshift, (KeySettings)keys.get("shift"));
                this.initButton((ClickButton)this.rshift, (KeySettings)keys.get("shift"));
                this.initButton((ClickButton)this.enter, (KeySettings)keys.get("enter"));
                this.initButton((ClickButton)this.cleanrus, (KeySettings)keys.get("cleaneng"));
                this.initButton((ClickButton)this.cleaneng, (KeySettings)keys.get("cleanrus"));
                this.initButton((ClickButton)this.tab, (KeySettings)keys.get("tab"));
                this.initButton((ClickButton)this.set2, (KeySettings)keys.get("eng"));
                this.initButton((ClickButton)this.set3, (KeySettings)keys.get("rus"));
            }
        }
    }

    public void init(Keyboard keyboard) {
        if (this.keyboard == keyboard) {
            return;
        }
        this.keyboard = keyboard;
        if (keyboard.getLayoutNames() != null && keyboard.getLayoutNames().indexOf("dgtl") >= 0) {
            keyboard.getLayoutNames().set(keyboard.getLayoutNames().indexOf("dgtl"), "symb");
        }
        if (this.keyMapping == null) {
            this.keyMapping = this.setLoader.readKeyMapping();
        }
        this.setAccessible();
        this.currentSetName = null;
        this.lastSetName = null;
        if (keyboard.getLayoutNames() != null && !keyboard.getLayoutNames().isEmpty()) {
            this.lastSetName = this.currentSetName = (String)keyboard.getLayoutNames().get(0);
        }
        this.currentCase = keyboard.getDefaultCase();
        this.shiftPressed = false;
        this.refreshSet();
    }

    public void addKeyboardListener(KeyboardListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public JPanel getPanel() {
        return this.main;
    }

    private void refreshSet() {
        this.main.setVisible(false);
        this.currentSet = this.setLoader.readLayout(this.currentSetName);
        if (this.keyMapping.get("set1").equals(this.currentSetName) || this.currentSetName == null) {
            this.set11.setVisible(false);
            if (this.keyMapping.get("set3").equals(this.lastSetName)) {
                this.set2.setVisible(true);
                this.set2.setEnabled(false);
                this.rus.setVisible(true);
                this.set12rus.setVisible(false);
                this.cleanrus.setVisible(true);
                this.set3.setVisible(false);
                this.eng.setVisible(false);
                this.set12eng.setVisible(true);
                this.cleaneng.setVisible(false);
            } else {
                this.set2.setVisible(false);
                this.rus.setVisible(false);
                this.set12rus.setVisible(true);
                this.cleanrus.setVisible(false);
                this.set3.setVisible(true);
                this.set3.setEnabled(false);
                this.eng.setVisible(true);
                this.set12eng.setVisible(false);
                this.cleaneng.setVisible(true);
            }
        } else {
            this.set11.setVisible(true);
            this.set12rus.setVisible(false);
            this.set12eng.setVisible(false);
            this.set2.setEnabled(true);
            this.set3.setEnabled(true);
            if (this.keyMapping.get("set2").equals(this.currentSetName)) {
                this.set2.setVisible(false);
                this.rus.setVisible(false);
                this.cleanrus.setVisible(false);
                this.set3.setVisible(true);
                this.eng.setVisible(true);
                this.cleaneng.setVisible(true);
            } else {
                this.set2.setVisible(true);
                this.rus.setVisible(true);
                this.cleanrus.setVisible(true);
                this.set3.setVisible(false);
                this.eng.setVisible(false);
                this.cleaneng.setVisible(false);
            }
        }
        if (this.currentSet != null) {
            for (int i = 0; i < this.letters.length; ++i) {
                ClickButton[] row = this.letters[i];
                for (int j = 0; j < row.length; ++j) {
                    ClickButton cb = row[j];
                    Character ch = this.currentSet.get(i, j);
                    if (ch != null) {
                        if (this.currentCase == KeyboardCase.Lower) {
                            cb.setText("" + Character.toLowerCase(ch.charValue()));
                        } else {
                            cb.setText("" + Character.toUpperCase(ch.charValue()));
                        }
                    } else {
                        cb.setText(null);
                    }
                    cb.setEnabled(true);
                }
            }
        } else {
            ClickButton cb;
            int j;
            ClickButton[] row;
            int i;
            SetConfiguration set = this.setLoader.readLayout("symb");
            for (i = 0; i < this.letters.length; ++i) {
                row = this.letters[i];
                for (j = 0; j < row.length; ++j) {
                    cb = row[j];
                    Character ch = set.get(i, j);
                    if (ch != null) {
                        if (this.currentCase == KeyboardCase.Lower) {
                            cb.setText("" + Character.toLowerCase(ch.charValue()));
                        } else {
                            cb.setText("" + Character.toUpperCase(ch.charValue()));
                        }
                    } else {
                        cb.setText(null);
                    }
                    cb.setEnabled(true);
                }
            }
            for (i = 0; i < this.letters.length; ++i) {
                row = this.letters[i];
                for (j = 0; j < row.length; ++j) {
                    cb = row[j];
                    if (cb.getText() != null && (cb.getText().matches("\\d") || this.keyboard.getExtraCharacter() != null && cb.getText().equals(this.keyboard.getExtraCharacter().toString()))) continue;
                    cb.setText(null);
                    cb.setEnabled(false);
                }
            }
        }
        this.main.setVisible(true);
    }

    private void setAccessible() {
        this.main.setVisible(false);
        this.caps.setEnabled(this.keyboard.isAllowChangeCase() && this.keyboard.getType() != KeyboardType.Digital);
        this.lshift.setEnabled(this.keyboard.isAllowChangeCase() && this.keyboard.getType() != KeyboardType.Digital);
        this.rshift.setEnabled(this.keyboard.isAllowChangeCase() && this.keyboard.getType() != KeyboardType.Digital);
        this.space.setEnabled(this.keyboard.getType() != KeyboardType.Digital);
        if (this.keyMapping != null && this.keyboard.getLayoutNames() != null && this.keyboard.getLayoutNames().size() > 1) {
            this.set2.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set2")));
            this.set3.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set3")));
            this.set11.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set1")));
            this.set12rus.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set1")));
            this.set12eng.setEnabled(this.keyboard.getLayoutNames().contains(this.keyMapping.get("set1")));
        } else {
            this.set2.setEnabled(false);
            this.set3.setEnabled(false);
            this.set11.setEnabled(false);
            this.set12rus.setEnabled(false);
            this.set12eng.setEnabled(false);
        }
        this.main.setVisible(true);
    }

    private void initButton(ClickButton cb, KeySettings ks) {
        if (ks != null) {
            cb.setText(ks.getTitle());
        } else {
            cb.setText(null);
        }
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CpLetterKeyboard.this.lshift || e.getSource() == CpLetterKeyboard.this.rshift) {
                CpLetterKeyboard.this.shiftPressed = !CpLetterKeyboard.this.shiftPressed;
                CpLetterKeyboard.this.capsListener.actionPerformed(null);
            } else {
                if (e.getSource() == CpLetterKeyboard.this.space) {
                    for (KeyboardListener kl : CpLetterKeyboard.this.listeners) {
                        kl.onKeyPress(' ');
                    }
                } else if (e.getSource() == CpLetterKeyboard.this.clear) {
                    for (KeyboardListener kl : CpLetterKeyboard.this.listeners) {
                        kl.onClearLast();
                    }
                } else if (e.getSource() == CpLetterKeyboard.this.enter) {
                    for (KeyboardListener kl : CpLetterKeyboard.this.listeners) {
                        kl.onEnter();
                    }
                } else if (e.getSource() == CpLetterKeyboard.this.tab) {
                    for (KeyboardListener kl : CpLetterKeyboard.this.listeners) {
                        kl.onEnter();
                    }
                } else if (e.getSource() == CpLetterKeyboard.this.cleanrus || e.getSource() == CpLetterKeyboard.this.cleaneng) {
                    for (KeyboardListener kl : CpLetterKeyboard.this.listeners) {
                        kl.onClear();
                    }
                } else {
                    ClickButton cb = (ClickButton)e.getSource();
                    if (cb.getText() != null && !cb.getText().isEmpty()) {
                        char ch = cb.getText().charAt(0);
                        for (KeyboardListener kl : CpLetterKeyboard.this.listeners) {
                            kl.onKeyPress(ch);
                        }
                    }
                }
                if (CpLetterKeyboard.this.shiftPressed) {
                    CpLetterKeyboard.this.shiftPressed = false;
                    CpLetterKeyboard.this.capsListener.actionPerformed(null);
                }
            }
        }
    }

    private class Set3ActionListener
    implements ActionListener {
        private Set3ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CpLetterKeyboard.this.lastSetName = CpLetterKeyboard.this.currentSetName;
            CpLetterKeyboard.this.currentSetName = (String)CpLetterKeyboard.this.keyMapping.get("set3");
            CpLetterKeyboard.this.refreshSet();
        }
    }

    private class Set2ActionListener
    implements ActionListener {
        private Set2ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CpLetterKeyboard.this.lastSetName = CpLetterKeyboard.this.currentSetName;
            CpLetterKeyboard.this.currentSetName = (String)CpLetterKeyboard.this.keyMapping.get("set2");
            CpLetterKeyboard.this.refreshSet();
        }
    }

    private class Set12ActionListener
    implements ActionListener {
        private Set12ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CpLetterKeyboard.this.currentSetName = CpLetterKeyboard.this.lastSetName;
            CpLetterKeyboard.this.refreshSet();
        }
    }

    private class Set1ActionListener
    implements ActionListener {
        private Set1ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CpLetterKeyboard.this.lastSetName = CpLetterKeyboard.this.currentSetName;
            CpLetterKeyboard.this.currentSetName = (String)CpLetterKeyboard.this.keyMapping.get("set1");
            CpLetterKeyboard.this.refreshSet();
        }
    }

    private class CapsActionListener
    implements ActionListener {
        private CapsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CpLetterKeyboard.this.currentCase == KeyboardCase.Lower) {
                CpLetterKeyboard.this.currentCase = KeyboardCase.Upper;
            } else {
                CpLetterKeyboard.this.currentCase = KeyboardCase.Lower;
            }
            CpLetterKeyboard.this.refreshSet();
        }
    }
}

