/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.factory;

import info.clearthought.layout.TableLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.AbstractBorder;
import org.apache.log4j.Logger;
import ru.softlogic.gui.component.AdaptiveLabel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.DataButton;
import ru.softlogic.gui.components.button.DataButtonListener;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.gui.components.button.LabeledClickButton;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.bundle.kb;

public class BsButtonFactory {
    public static JLabel createCashInSumWarning() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont("sumscreen.sum.warning"));
        view.setForeground(BsConstants.textColorBlue);
        view.setFont(FontFactory.getInstance().createBoldFont(36));
        return view;
    }

    public static JLabel createMobileViewTitle() {
        AdaptiveLabel info = new AdaptiveLabel(FontFactory.getInstance().createBoldFont(35));
        info.setForeground(BsConstants.textColorBlue);
        info.setBorder(BorderFactory.createEmptyBorder(0, Scaler.x((int)5), 0, 0));
        return info;
    }

    public static JLabel createMobileViewLabel() {
        AdaptiveLabel view = new AdaptiveLabel(FontFactory.getInstance().createBoldFont("inputscreen.mobile.view"));
        view.setForeground(BsConstants.textColorWhite);
        view.setBorder(BorderFactory.createEmptyBorder(0, Scaler.x((int)20), 0, 0));
        return view;
    }

    public static JLabel createSearchViewLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont("inputscreen.view"));
        view.setForeground(BsConstants.textColorBlue);
        view.setFont(FontFactory.getInstance().createBoldFont(30));
        view.setBorder(BorderFactory.createEmptyBorder(0, Scaler.x((int)5), 0, 0));
        return view;
    }

    public static LabeledClickButton createCheckStatusButton() {
        LabeledClickButton b = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)20), "l,c");
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/service/status.png");
        if (icon != null) {
            b.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        b.setIcon((Icon)icon);
        b.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/service/status_press.png"));
        b.getJLabel().setIcon(BsImageStore.getInstance().getIcon("buttons/status_icon.png"));
        b.getJLabel().setHorizontalAlignment(2);
        b.getJLabel().setIconTextGap(Scaler.x((int)20));
        b.getJLabel().setForeground(BsConstants.textColorMenuButton);
        b.getJLabel().setFont(FontFactory.getInstance().createFont("navigation.button"));
        return b;
    }

    public static LabeledClickButton createSearchProvider() {
        LabeledClickButton b = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)20), "l,c");
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/service/search.png");
        if (icon != null) {
            b.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        b.setIcon((Icon)icon);
        b.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/service/search_press.png"));
        b.getJLabel().setIcon(BsImageStore.getInstance().getIcon("buttons/search_icon.png"));
        b.getJLabel().setHorizontalAlignment(2);
        b.getJLabel().setIconTextGap(Scaler.x((int)20));
        b.getJLabel().setForeground(BsConstants.textColorMenuButton);
        b.getJLabel().setFont(FontFactory.getInstance().createFont("navigation.button"));
        return b;
    }

    public static LabeledClickButton createInfoButton() {
        LabeledClickButton b = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)20), "l,c");
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/service/info.png");
        if (icon != null) {
            b.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        b.setIcon((Icon)icon);
        b.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/service/info_press.png"));
        b.getJLabel().setIcon(BsImageStore.getInstance().getIcon("buttons/info_icon.png"));
        b.getJLabel().setHorizontalAlignment(2);
        b.getJLabel().setIconTextGap(Scaler.x((int)20));
        b.getJLabel().setForeground(BsConstants.textColorMenuButton);
        b.getJLabel().setFont(FontFactory.getInstance().createFont("navigation.button"));
        return b;
    }

    public static LabeledClickButton createPrintCheckButton() {
        LabeledClickButton b = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)20), "l,c");
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/service/info.png");
        if (icon != null) {
            b.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        b.setIcon((Icon)icon);
        b.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/service/info_press.png"));
        b.getJLabel().setIcon(BsImageStore.getInstance().getIcon("buttons/printer_icon.png"));
        b.getJLabel().setHorizontalAlignment(2);
        b.getJLabel().setIconTextGap(Scaler.x((int)20));
        b.getJLabel().setForeground(BsConstants.textColorMenuButton);
        b.getJLabel().setFont(FontFactory.getInstance().createFont("navigation.button"));
        return b;
    }

    public static DataButton<MenuItem> createServiceButton(MenuItem mi, DataButtonListener<MenuItem> listener) {
        DataButton button = new DataButton();
        button.setData((Object)mi);
        Icon icon = BsImageStore.getInstance().getOperatorButtonImage(mi.getService().getImage());
        if (icon == null) {
            button.setIcon(BsImageStore.getInstance().getOperatorButtonImage(null));
            button.setPressedIcon(BsImageStore.getInstance().getOperatorButtonPressImage(null));
            button.setFont(FontFactory.getInstance().createFont("mainmenu.hotkeybutton"));
            button.setText("<html><p style='width:90%' align='center'>" + mi.getService().getName());
            button.setForeground(BsConstants.textColorMenuButton);
            button.setBorder(BorderFactory.createEmptyBorder(Scaler.y((int)10), Scaler.x((int)10), Scaler.y((int)10), Scaler.x((int)10)));
        } else {
            button.setIcon(icon);
            button.setPressedIcon(BsImageStore.getInstance().getOperatorButtonPressImage(mi.getService().getImage()));
        }
        button.addDataListener(listener);
        return button;
    }

    public static IconifiedClickButton createSmallServiceButton() {
        ImageIcon ii = BsImageStore.getInstance().getIcon("/buttons/service/group1.png");
        int titlesize = ii.getIconWidth() - Scaler.x((int)10);
        TableLayout tbl = new TableLayout(new double[]{-1.0, -2.0, -1.0}, new double[]{-1.0, -2.0, -2.0, -1.0});
        IconifiedClickButton icb = new IconifiedClickButton(titlesize, "1,1,f,f", "1,2,c,c", tbl);
        icb.setIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group1.png"));
        icb.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group1_press.png"));
        if (icb.getIcon() != null) {
            Dimension dim = new Dimension(icb.getIcon().getIconWidth(), icb.getIcon().getIconHeight());
            icb.setSize(dim);
            icb.setMinimumSize(dim);
            icb.setMaximumSize(dim);
            icb.setPreferredSize(dim);
        }
        icb.getTitleLabel().setHorizontalAlignment(0);
        icb.getTitleLabel().setForeground(BsConstants.textColorMenuButton);
        icb.setFont(FontFactory.getInstance().createFont("mainmenu.hotkeybutton"));
        return icb;
    }

    public static IconifiedClickButton createBigServiceButton() {
        ImageIcon ii = BsImageStore.getInstance().getIcon("/buttons/service/group1_big.png");
        int titlesize = ii.getIconWidth() - Scaler.x((int)10);
        TableLayout tbl = new TableLayout(new double[]{-1.0, -2.0, -1.0}, new double[]{-1.0, -2.0, -2.0, -1.0});
        IconifiedClickButton icb = new IconifiedClickButton(titlesize, "1,1,f,f", "1,2,c,c", tbl);
        icb.setIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group1_big.png"));
        icb.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group1_big_press.png"));
        if (icb.getIcon() != null) {
            Dimension dim = new Dimension(icb.getIcon().getIconWidth(), icb.getIcon().getIconHeight());
            icb.setSize(dim);
            icb.setMinimumSize(dim);
            icb.setMaximumSize(dim);
            icb.setPreferredSize(dim);
        }
        icb.getTitleLabel().setHorizontalAlignment(0);
        icb.getTitleLabel().setForeground(BsConstants.textColorMenuButton);
        icb.setFont(FontFactory.getInstance().createFont("mainmenu.hotkeybutton"));
        return icb;
    }

    public static IconifiedClickButton createGroupIconifiedButton(int n) {
        ImageIcon ii = BsImageStore.getInstance().getIcon("/buttons/service/group" + n + ".png");
        int titlesize = ii.getIconWidth() - Scaler.x((int)10);
        TableLayout tbl = new TableLayout(new double[]{-1.0, -2.0, -1.0}, new double[]{-1.0, -2.0, Scaler.y((int)16), -2.0, -1.0});
        IconifiedClickButton icb = new IconifiedClickButton(titlesize, "1,1,c,c", "1,3,c,c", tbl);
        icb.setIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group" + n + ".png"));
        icb.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group" + n + "_press.png"));
        if (icb.getIcon() != null) {
            Dimension dim = new Dimension(icb.getIcon().getIconWidth(), icb.getIcon().getIconHeight());
            icb.setSize(dim);
            icb.setMinimumSize(dim);
            icb.setMaximumSize(dim);
            icb.setPreferredSize(dim);
        }
        icb.getTitleLabel().setHorizontalAlignment(0);
        icb.getTitleLabel().setForeground(BsConstants.textColorMenuButton);
        icb.setFont(FontFactory.getInstance().createFont(23));
        return icb;
    }

    public static LabeledClickButton createPrev() {
        LabeledClickButton button = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)80), (double)Scaler.x((int)20));
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/back.png");
        if (icon != null) {
            button.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        button.setIcon((Icon)icon);
        button.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/back_press.png"));
        button.getJLabel().setForeground(BsConstants.textColorMenuButton);
        button.getJLabel().setFont(FontFactory.getInstance().createFont("navigation.button"));
        return button;
    }

    public static LabeledClickButton createNext() {
        LabeledClickButton button = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)80));
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/next.png");
        if (icon != null) {
            button.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        button.setIcon((Icon)icon);
        button.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/next_press.png"));
        button.getJLabel().setForeground(BsConstants.textColorMenuButton);
        button.getJLabel().setFont(FontFactory.getInstance().createFont("navigation.button"));
        return button;
    }

    public static LabeledClickButton createExit() {
        LabeledClickButton button = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)20), "l,c");
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/close.png");
        if (icon != null) {
            button.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        button.setIcon((Icon)icon);
        button.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/close_press.png"));
        button.getJLabel().setIcon(BsImageStore.getInstance().getIcon("buttons/close_icon.png"));
        button.getJLabel().setHorizontalAlignment(2);
        button.getJLabel().setIconTextGap(Scaler.x((int)20));
        button.getJLabel().setForeground(BsConstants.textColorMenuButton);
        button.getJLabel().setFont(FontFactory.getInstance().createFont("navigation.button"));
        return button;
    }

    public static LabeledClickButton createSearch() {
        LabeledClickButton button = new LabeledClickButton((double)Scaler.y((int)15), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)20), "l,c");
        ImageIcon icon = BsImageStore.getInstance().getIcon("buttons/search.png");
        if (icon != null) {
            button.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
        button.setIcon((Icon)icon);
        button.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/search_press.png"));
        button.getJLabel().setIcon(BsImageStore.getInstance().getIcon("buttons/search_icon.png"));
        button.getJLabel().setHorizontalAlignment(2);
        button.getJLabel().setVerticalAlignment(0);
        button.getJLabel().setIconTextGap(Scaler.x((int)20));
        button.getJLabel().setText(kb.getString("shell.button.providersearch"));
        button.getJLabel().setForeground(BsConstants.textColorMenuButton);
        button.setFont(FontFactory.getInstance().createFont("navigation.button"));
        return button;
    }

    public static JLabel createMainMenuInfoLabel() {
        JLabel info = new JLabel();
        info.setFont(FontFactory.getInstance().createBoldFont("shell.info"));
        info.setForeground(BsConstants.textColorWhite);
        return info;
    }

    public static JLabel createMainMenuInfoLabel2() {
        AdaptiveLabel info = new AdaptiveLabel(FontFactory.getInstance().createBoldFont("shell.header"));
        info.setForeground(BsConstants.textColorWhite);
        info.setHorizontalAlignment(0);
        return info;
    }

    public static JLabel createMobileConfirmViewLabel() {
        AdaptiveLabel view = new AdaptiveLabel(FontFactory.getInstance().createBoldFont("sumscreen.mobileview"));
        view.setHorizontalAlignment(0);
        view.setForeground(BsConstants.textColorBlue);
        return view;
    }

    public static JLabel createLetterViewLabel() {
        AdaptiveLabel view = new AdaptiveLabel(FontFactory.getInstance().createBoldFont("inputscreen.view"));
        ImageIcon icon = BsImageStore.getInstance().getIcon("elements/letter.png");
        view.setIcon(icon);
        view.setIconTextGap(-((int)((double)icon.getIconWidth() * 0.98)));
        view.setForeground(BsConstants.textColorBlue);
        return view;
    }

    public static JLabel createSumView() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont("sumscreen.income"));
        view.setForeground(BsConstants.textColorBlue);
        view.setHorizontalTextPosition(0);
        view.setHorizontalAlignment(2);
        return view;
    }

    public static JLabel createSumLimitView() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont("sumscreen.servicesums"));
        view.setForeground(BsConstants.textColorBlue);
        view.setHorizontalTextPosition(0);
        view.setHorizontalAlignment(2);
        return view;
    }

    public static JLabel createSumViewLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont("sumscreen.income"));
        view.setForeground(BsConstants.textColorBlue);
        view.setHorizontalTextPosition(0);
        view.setHorizontalAlignment(4);
        return view;
    }

    public static JLabel createComissionLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createFont("sumscreen.comission"));
        view.setForeground(BsConstants.textColorBlue);
        view.setHorizontalTextPosition(0);
        view.setHorizontalAlignment(0);
        return view;
    }

    public static JLabel createSumLimitViewLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont("sumscreen.servicesums"));
        view.setForeground(BsConstants.textColorBlue);
        view.setHorizontalTextPosition(0);
        view.setHorizontalAlignment(2);
        return view;
    }

    public static JLabel createInvitationLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont("inputscreen.invitation"));
        view.setForeground(BsConstants.textColorBlue);
        return view;
    }

    public static JLabel createHelpLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createFont("inputscreen.help"));
        view.setForeground(BsConstants.textColor);
        return view;
    }

    public static ClickButton createPinCodeButton1() {
        ClickButton button = new ClickButton();
        button.setFont(FontFactory.getInstance().createBoldFont("pincode.button"));
        button.setIcon((Icon)BsImageStore.getInstance().getIcon("buttons/cbc_activate.png"));
        button.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/cbc_activate_press.png"));
        button.setForeground(BsConstants.textColor);
        return button;
    }

    public static ClickButton createPinCodeButton2() {
        ClickButton button = new ClickButton();
        button.setFont(FontFactory.getInstance().createBoldFont("pincode.button"));
        button.setIcon((Icon)BsImageStore.getInstance().getIcon("buttons/cbc_cancel.png"));
        button.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/cbc_cancel_press.png"));
        button.setForeground(BsConstants.textColor);
        return button;
    }

    public static JLabel createPinCodeViewLabel() {
        AdaptiveLabel view = new AdaptiveLabel(FontFactory.getInstance().createBoldFont("pincode.view"));
        view.setIcon(BsImageStore.getInstance().getIcon("elements/input_pin.png"));
        view.setHorizontalTextPosition(0);
        view.setForeground(BsConstants.textColor);
        return view;
    }

    public static JLabel createPinCodeInvitationLabel() {
        JLabel invitation = new JLabel();
        invitation.setFont(FontFactory.getInstance().createBoldFont("pincode.invitation"));
        invitation.setForeground(BsConstants.textColorBlue);
        return invitation;
    }

    public static JLabel createPinCodeFailLabel() {
        JLabel invitation = new JLabel();
        invitation.setFont(FontFactory.getInstance().createBoldFont("pincode.invitation"));
        invitation.setForeground(BsConstants.textColorRed);
        return invitation;
    }

    public static ClickButton createDialogButton(String text) {
        ClickButton button = new ClickButton(text);
        button.setMultiClickThreshhold(1000L);
        button.setIcon((Icon)BsImageStore.getInstance().getIcon("buttons/action.png"));
        button.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/action_press.png"));
        button.setFont(FontFactory.getInstance().createBoldFont("popup.dialog.button"));
        button.setForeground(BsConstants.textColorWhite);
        return button;
    }

    public static JLabel createGroupLetterInvitationLabel2() {
        JLabel view = new JLabel();
        view.setBorder(BorderFactory.createEmptyBorder(0, Scaler.x((int)5), 0, 0));
        view.setFont(FontFactory.getInstance().createBoldFont("groupscreen.titles2"));
        view.setForeground(BsConstants.textColorWhite);
        return view;
    }

    public static JLabel createGroupLetterViewLabel2() {
        AdaptiveLabel view = new AdaptiveLabel(FontFactory.getInstance().createBoldFont("groupscreen.fields2"));
        ImageIcon icon = BsImageStore.getInstance().getIcon("elements/input_letter.png");
        view.setIcon((Icon)icon);
        view.setIconTextGap(-((int)((double)icon.getIconWidth() * 0.97)));
        view.setForeground(BsConstants.textColorBlue);
        return view;
    }

    public static void createServiceIcon(String image, String text, JLabel label, Dimension imageSize) {
        if (label == null) {
            return;
        }
        ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, image, BsImageStore.imagePrefixS, imageSize, false);
        if (icon == null) {
            label.setIcon(null);
            if (text != null) {
                label.setText("<html><p align='center'>" + text);
            } else {
                label.setText(null);
            }
        } else {
            label.setText(null);
            label.setIcon(icon);
        }
    }

    public static LabeledClickButton createServiceButton() {
        LabeledClickButton button = new LabeledClickButton();
        button.setIcon(BsImageStore.getInstance().getOperatorButtonImage(null));
        button.setPressedIcon(BsImageStore.getInstance().getOperatorButtonPressImage(null));
        button.setFont(FontFactory.getInstance().createFont("mainmenu.hotkeybutton"));
        button.setForeground(BsConstants.textColorBlue);
        button.getJLabel().setForeground(BsConstants.textColorMenuButton);
        button.setBorder(BorderFactory.createEmptyBorder(Scaler.y((int)10), Scaler.x((int)10), Scaler.y((int)10), Scaler.x((int)10)));
        return button;
    }

    public static JLabel createLetterTitleLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont(26));
        view.setForeground(BsConstants.textColorWhite);
        return view;
    }

    public static JLabel createTitleLabel() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createBoldFont(36));
        view.setForeground(BsConstants.textColorWhite);
        view.setHorizontalAlignment(0);
        return view;
    }

    public static JLabel createWarning() {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createFont(24));
        view.setForeground(Color.WHITE);
        return view;
    }

    public static LabeledClickButton createPinRestoreButton() {
        LabeledClickButton button = new LabeledClickButton((double)Scaler.y((int)10), (double)Scaler.y((int)10), (double)Scaler.x((int)20), (double)Scaler.x((int)20), "c,c");
        button.getJLabel().setForeground(BsConstants.textColorBlue);
        button.getJLabel().setFont(FontFactory.getInstance().createBoldFont("numberscreen.pincode.button"));
        button.getJLabel().setOpaque(false);
        button.setBackground(BsConstants.backColor);
        return button;
    }

    public static ClickButton createCommisionShowButton() {
        ClickButton button = new ClickButton();
        button.setPreferredSize(new Dimension(Scaler.x((int)365), Scaler.y((int)105)));
        button.setOpaque(true);
        button.setIcon((Icon)BsImageStore.getInstance().getIcon("buttons/show_comm_icon.png"));
        return button;
    }

    public static JLabel createComissionInfoLabelBackground(Color backColor, boolean rounded) {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createFont(20));
        view.setForeground(BsConstants.textColorBlack);
        view.setBackground(backColor);
        view.setOpaque(true);
        view.setHorizontalAlignment(0);
        if (rounded) {
            TextBubbleBorder brdr = new TextBubbleBorder(backColor, 2, 16, 0);
            view.setBorder(brdr);
        }
        return view;
    }

    public static JLabel createComissionTableLabel(Color borderColor) {
        JLabel view = new JLabel();
        view.setFont(FontFactory.getInstance().createFont(20));
        view.setForeground(BsConstants.textColorBlack);
        view.setOpaque(false);
        view.setBorder(BorderFactory.createMatteBorder(0, 0, Scaler.x((int)2), 0, borderColor));
        view.setHorizontalAlignment(0);
        return view;
    }

    public static JLabel createChangeMainLabel() {
        JLabel view = new JLabel();
        view.setBackground(new Color(211, 47, 46));
        view.setFont(FontFactory.getInstance().createBoldBoldFont(25));
        view.setForeground(BsConstants.textColorWhite);
        view.setHorizontalTextPosition(0);
        view.setHorizontalAlignment(0);
        view.setOpaque(true);
        return view;
    }

    public static class TextBubbleBorder
    extends AbstractBorder {
        private Color color;
        private int thickness = 4;
        private int radii = 8;
        private int pointerSize = 7;
        private Insets insets = null;
        private BasicStroke stroke = null;
        private int strokePad;
        private int pointerPad = 4;
        RenderingHints hints;

        TextBubbleBorder(Color color) {
            new TextBubbleBorder(color, 4, 8, 7);
        }

        TextBubbleBorder(Color color, int thickness, int radii, int pointerSize) {
            this.thickness = thickness;
            this.radii = radii;
            this.pointerSize = pointerSize;
            this.color = color;
            this.stroke = new BasicStroke(thickness);
            this.strokePad = thickness / 2;
            this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int pad = radii + this.strokePad;
            int bottomPad = pad + pointerSize + this.strokePad;
            this.insets = new Insets(pad, pad, bottomPad, pad);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return this.getBorderInsets(c);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            try {
                Graphics2D g2 = (Graphics2D)g;
                int bottomLineY = height - this.thickness - this.pointerSize;
                RoundRectangle2D.Double bubble = new RoundRectangle2D.Double(0 + this.strokePad, 0 + this.strokePad, width - this.thickness, bottomLineY, this.radii, this.radii);
                Polygon pointer = new Polygon();
                pointer.addPoint(this.strokePad + this.radii + this.pointerPad, bottomLineY);
                pointer.addPoint(this.strokePad + this.radii + this.pointerPad + this.pointerSize, bottomLineY);
                pointer.addPoint(this.strokePad + this.radii + this.pointerPad + this.pointerSize / 2, height - this.strokePad);
                Area area = new Area(bubble);
                area.add(new Area(pointer));
                g2.setRenderingHints(this.hints);
                Container parent = c.getParent();
                if (parent != null) {
                    Color bg = Color.WHITE;
                    Rectangle rect = new Rectangle(0, 0, width, height);
                    Area borderRegion = new Area(rect);
                    borderRegion.subtract(area);
                    g2.setClip(borderRegion);
                    g2.setColor(bg);
                    g2.fillRect(0, 0, width, height);
                    g2.setClip(null);
                }
                g2.setColor(this.color);
                g2.setStroke(this.stroke);
                g2.draw(area);
            }
            catch (Exception ex) {
                Logger.getLogger((String)"gui").info((Object)("TextBubbleBorder.paintBorder: " + ex.getMessage()));
            }
        }
    }
}

