/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.universal.selector;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui2.screen.ComboBoxItem;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.listener.SelectorListener;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.content.universal.selector.Selector;

public class VariantSelector
implements Selector {
    private JPanel panel;
    private ActionListener actionListener;
    private SelectorListener listener;

    public VariantSelector(SelectorListener listener) {
        this.listener = listener;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)50), Scaler.x((int)365), -1.0, Scaler.x((int)365), -1.0, Scaler.x((int)365), Scaler.x((int)50)}, new double[]{-1.0, Scaler.y((int)135), -1.0, Scaler.y((int)135), -1.0, Scaler.y((int)135), -1.0, Scaler.y((int)135), -1.0}));
        this.actionListener = new SelectListener();
    }

    @Override
    public void init(ScreenDescription sd, ScreenInit si, ComboBoxItem[] items) {
        this.panel.setVisible(false);
        this.panel.removeAll();
        for (int i = 0; i < 4 && i < items.length; ++i) {
            this.panel.add((Component)this.createButton(items[i]), "1," + (i % 4 * 2 + 1));
            JLabel help = this.createHelp(items[i]);
            if (help == null) continue;
            this.panel.add((Component)help, "3," + (i % 4 * 2 + 1) + ",5," + (i % 4 * 2 + 1));
        }
        this.panel.setVisible(true);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private JButton createButton(ComboBoxItem cbi) {
        ClickButton b = new ClickButton();
        b.setIcon((Icon)BsImageStore.getInstance().getIcon("buttons/selector/text_ad.png"));
        b.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/selector/text_ad_press.png"));
        b.setFont(FontFactory.getInstance().createFont("content.selector.button"));
        b.setText("<html><p align='center'>" + cbi.getTitle());
        b.setBorderPainted(true);
        b.setBorder(BorderFactory.createEmptyBorder(Scaler.y((int)5), Scaler.x((int)5), Scaler.y((int)5), Scaler.x((int)5)));
        b.setEnabled(cbi.getItem().isEnable());
        b.addActionListener(this.actionListener);
        b.putClientProperty((Object)"item", (Object)cbi);
        return b;
    }

    private JLabel createHelp(ComboBoxItem cbi) {
        String help = cbi.getItem().getHelp();
        if (help == null) {
            return null;
        }
        JLabel l = new JLabel();
        l.setOpaque(true);
        l.setBackground(BsConstants.backColor);
        l.setForeground(BsConstants.textColor);
        l.setFont(FontFactory.getInstance().createFont(21));
        l.setText(help.startsWith("<html>") ? help : "<html>" + help);
        l.setBorder(BorderFactory.createEmptyBorder(Scaler.y((int)5), Scaler.x((int)5), Scaler.y((int)5), Scaler.x((int)5)));
        return l;
    }

    private class SelectListener
    implements ActionListener {
        private SelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            ComboBoxItem cbi = (ComboBoxItem)b.getClientProperty("item");
            VariantSelector.this.listener.onSelect(cbi, b);
        }
    }
}

