/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.universal.selector;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui2.screen.ComboBoxItem;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.listener.SelectorListener;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.content.panel.add.CpInfoPanel;
import ru.softlogic.skin.kengu24.content.universal.detail.DetailRender;
import ru.softlogic.skin.kengu24.content.universal.selector.Selector;

public class ListSelector
implements Selector {
    private JPanel panel;
    private JList list;
    private JScrollPane pane;
    private ClickButton nextButton;
    private SelectorListener listener;
    private CpInfoPanel infoPanel;

    public ListSelector(SelectorListener listener, ClickButton nextButton) {
        this.listener = listener;
        this.panel = new JPanel();
        this.panel.setBackground(new Color(255, 255, 255, 0));
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)50), -1.0, Scaler.x((int)50)}, new double[]{Scaler.y((int)50), -1.0, Scaler.y((int)28)}));
        this.list = new JList();
        this.list.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.list.setFont(FontFactory.getInstance().createBoldFont("listselector.list"));
        this.list.addListSelectionListener(new LocalListListener());
        this.list.setFixedCellHeight(Scaler.y((int)50));
        this.pane = new JScrollPane(this.list);
        this.pane.setViewportBorder(null);
        this.panel.add((Component)this.pane, "1,1");
        this.nextButton = nextButton;
        nextButton.addActionListener((ActionListener)new NextListener());
        this.infoPanel = new CpInfoPanel();
        this.panel.add((Component)this.infoPanel.getPanel(), "0,0,2,0");
    }

    @Override
    public void init(ScreenDescription sd, ScreenInit si, ComboBoxItem[] items) {
        DetailRender.setTitle(this.infoPanel.getInfo2(), sd, si);
        this.list.setVisible(false);
        this.list.removeAll();
        this.list.setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
        this.list.setVisible(true);
        this.nextButton.setEnabled(false);
        this.nextButton.setVisible(true);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private SelectorItem getData() {
        Object obj = this.list.getSelectedValue();
        if (obj != null) {
            ComboBoxItem cbi = (ComboBoxItem)obj;
            SelectorItem si = cbi.getItem();
            return si;
        }
        return null;
    }

    private class LocalListListener
    implements ListSelectionListener {
        private LocalListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelector.this.nextButton.setEnabled(ListSelector.this.list.getSelectedValue() != null);
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSelector.this.listener.onSelect((ComboBoxItem)ListSelector.this.list.getSelectedValue(), (JButton)ListSelector.this.nextButton);
        }
    }
}

