/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.universal.selector;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.utils.ImageUtil;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui2.screen.ComboBoxItem;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.listener.SelectorListener;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.content.panel.add.CpInfoPanel;
import ru.softlogic.skin.kengu24.content.universal.detail.DetailRender;
import ru.softlogic.skin.kengu24.content.universal.selector.Selector;

public class ButtonSelector
implements Selector {
    private JPanel panel;
    private ActionListener actionListener;
    private SelectorListener listener;
    private CpInfoPanel infoPanel;

    public ButtonSelector(SelectorListener listener) {
        this.listener = listener;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)50), Scaler.x((int)270), -1.0, Scaler.x((int)270), -1.0, Scaler.x((int)270), -1.0, Scaler.x((int)270), Scaler.x((int)50)}, new double[]{Scaler.y((int)50), Scaler.y((int)140), -1.0, Scaler.y((int)140), -1.0, Scaler.y((int)140), -1.0, Scaler.y((int)140), Scaler.y((int)40)}));
        this.actionListener = new SelectListener();
        this.infoPanel = new CpInfoPanel();
    }

    @Override
    public void init(ScreenDescription sd, ScreenInit si, ComboBoxItem[] items) {
        this.panel.setVisible(false);
        this.panel.removeAll();
        DetailRender.setTitle(this.infoPanel.getInfo2(), sd, si);
        this.panel.add((Component)this.infoPanel.getPanel(), "0,0,8,0");
        for (int i = 0; i < 24 && i < items.length; ++i) {
            this.panel.add((Component)this.createButton(items[i]), "" + (i % 4 * 2 + 1) + ", " + (i / 4 * 2 + 1) + ",c,c");
        }
        this.panel.setVisible(true);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private JButton createButton(ComboBoxItem cbi) {
        ClickButton b = new ClickButton();
        b.setMultiClickThreshhold(1000L);
        b.setFont(FontFactory.getInstance().createFont("content.selector.button"));
        if (BsImageStore.getInstance().getImage(BsImageStore.imageServicePath + cbi.getItem().getImage()) != null) {
            ImageIcon baseII = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, cbi.getItem().getImage(), BsImageStore.imagePrefixS, new Dimension(Scaler.x((int)270), Scaler.y((int)140)), false);
            Image img = ImageUtil.mixImage((Image)BsImageStore.getInstance().getOperatorUpIcon().getImage(), (Image)baseII.getImage(), (float)1.0f);
            b.setIcon((Icon)new ImageIcon(img));
            baseII = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, cbi.getItem().getImage(), BsImageStore.imagePrefixS, new Dimension(Scaler.x((int)270), Scaler.y((int)140)), true);
            img = ImageUtil.mixImage((Image)BsImageStore.getInstance().getOperatorDownIcon().getImage(), (Image)baseII.getImage(), (float)0.5f);
            b.setPressedIcon((Icon)new ImageIcon(img));
        } else {
            b.setIcon((Icon)BsImageStore.getInstance().getIcon("buttons/selector/text.png"));
            b.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("buttons/selector/text_press.png"));
            b.setText("<html><p align='center'>" + cbi.getTitle());
        }
        b.setBorderPainted(true);
        b.setBorder(BorderFactory.createEmptyBorder(Scaler.y((int)5), Scaler.x((int)5), Scaler.y((int)5), Scaler.x((int)5)));
        b.setEnabled(cbi.getItem().isEnable());
        b.addActionListener(this.actionListener);
        b.putClientProperty((Object)"item", (Object)cbi);
        return b;
    }

    private class SelectListener
    implements ActionListener {
        private SelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            ComboBoxItem cbi = (ComboBoxItem)b.getClientProperty("item");
            ButtonSelector.this.listener.onSelect(cbi, b);
        }
    }
}

