/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.universal;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.screen.content.RedirectListener;
import ru.softlogic.gui.screen.content.banner.AdvHelper;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.ScreenUtil;
import ru.softlogic.gui2.keyboard.KeyboardAdapter;
import ru.softlogic.gui2.keyboard.KeyboardListener;
import ru.softlogic.gui2.keyboard.loader.FileSetLoader;
import ru.softlogic.gui2.keyboard.loader.SetLoader;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonDynamicScreen;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.listener.SimpleRedirectListener;
import ru.softlogic.gui2.screen.listener.ng.ActionNotifier;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.gui2.screen.textfield.InputFieldModel;
import ru.softlogic.gui2.screen.textfield.TextFieldModel;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.content.panel.add.CpButtonMenuScreen;
import ru.softlogic.skin.kengu24.content.panel.add.CpSearchInputPanel;
import ru.softlogic.skin.kengu24.factory.CpLetterKeyFactory;
import ru.softlogic.skin.kengu24.gui.CpLetterKeyboard;
import ru.softlogic.system.util.PathUtils;

public class CpSearchProviderScreen
implements CommonDynamicScreen {
    private JPanel main;
    private JPanel content;
    private CpButtonMenuScreen buttonScreen;
    private TextFieldModel model;
    private final JList list;
    private final JScrollPane pane;
    private final Color activeColor = new Color(0, 147, 221);
    private CpLetterKeyboard letterKeyboard;
    private ScreenDescription description;
    private ScreenInit initData;
    private ScreenListener listener;
    private LocalKeyboardListener keyboardListener;
    private CpSearchInputPanel inputPanel;
    private SimpleRedirectListener redirectListener;

    public CpSearchProviderScreen() {
        this.main = new ImagePanel(BsImageStore.getInstance().getBackGround("bg"), false);
        this.main.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{Scaler.y((int)200), -1.0, Scaler.y((int)10), -2.0, Scaler.y((int)20)}));
        this.content = new JPanel();
        this.content.setOpaque(false);
        this.content.setBackground(Color.WHITE);
        this.content.setLayout((LayoutManager)new TableLayout(new double[]{-1.0, Scaler.x((int)1232), -1.0}, new double[]{Scaler.y((int)5), Scaler.y((int)78), Scaler.y((int)0), -1.0, Scaler.y((int)7), -2.0}));
        this.main.add((Component)this.content, "0,1");
        this.inputPanel = new CpSearchInputPanel();
        this.content.add((Component)this.inputPanel.getPanel(), "1,1,c,c");
        this.buttonScreen = new CpButtonMenuScreen();
        this.buttonScreen.getPrev().addActionListener((ActionListener)new LocalActionListener("Exit"));
        this.buttonScreen.getNext().addActionListener((ActionListener)new LocalActionListener("Next"));
        this.buttonScreen.getNext().setEnabled(false);
        this.main.add((Component)this.buttonScreen.getPanel(), "0,3");
        this.buttonScreen.getMain().setVisible(false);
        this.list = new JList();
        this.list.setFont(FontFactory.getInstance().createFont("listselector.list"));
        this.list.setFixedCellHeight(Scaler.y((int)40));
        this.list.setBackground(Color.WHITE);
        this.list.setCellRenderer(new DefaultOnlineListRenderer());
        this.list.addListSelectionListener(new LocalSelectorListener());
        this.pane = new JScrollPane(this.list);
        this.pane.setBorder(null);
        JPanel paneBackgroud = new JPanel((LayoutManager)new TableLayout(new double[]{Scaler.x((int)10), -1.0, Scaler.x((int)10)}, new double[]{-1.0}));
        paneBackgroud.setBackground(Color.WHITE);
        paneBackgroud.add((Component)this.pane, "1,0");
        this.content.add((Component)paneBackgroud, "1,3");
        this.keyboardListener = new LocalKeyboardListener();
        this.letterKeyboard = new CpLetterKeyboard(new CpLetterKeyFactory(), (SetLoader)new FileSetLoader(new File(PathUtils.getAppHome(), "/resources/keyboards/"), "kengu24"));
        this.letterKeyboard.getPanel().setOpaque(false);
        this.letterKeyboard.addKeyboardListener((KeyboardListener)this.keyboardListener);
        this.redirectListener = new SimpleRedirectListener();
        this.content.add((Component)this.letterKeyboard.getPanel(), "1,5");
    }

    public JPanel getPanel() {
        return this.main;
    }

    public void init(ScreenDescription sd, ScreenInit si) throws InitException {
        kb.setLocale(si.getLocale());
        ScreenHelper.initButton((ClickButton)this.buttonScreen.getPrev(), (ScreenDescription)sd, (String)"Prev", (String)kb.getString("shell.button.main.back"));
        ScreenHelper.initNext((ClickButton)this.buttonScreen.getNext(), (Map)sd.getButtons(), (String)kb.getString("button.next"));
        this.buttonScreen.getNext().setEnabled(false);
        this.inputPanel.getView().setText("");
        this.letterKeyboard.setLocale(si.getLocale());
        List fields = sd.getSequence().initFields(ScreenUtil.toModel((Map)si.getData()));
        if (fields.size() > 0 && ((IdentityField)fields.get(0)).getType() == FieldType.Letter) {
            TextField f = (TextField)fields.get(0);
            this.model = new TextFieldModel(f.getMaxLength(), null, null, false, (Filter)new VoidFilter());
            this.model.addListener((FieldListener)new LocalTextFieldModelListener());
            this.keyboardListener.setModel((InputFieldModel)this.model);
            this.letterKeyboard.init(f.getKeyboard());
            this.inputPanel.getViewTitle().setText(f.getTitle());
        }
        LinkedList bi = new LinkedList();
        JPanel bannerPanel = AdvHelper.getImageBanner(null, (Service)si.getService(), (String)"TOP", (int)Scaler.x((int)1280), (int)Scaler.y((int)200), (RedirectListener)this.redirectListener, null, bi, (boolean)true);
        if (bannerPanel != null) {
            this.main.add((Component)bannerPanel, "0,0");
        }
    }

    public void setListener(ScreenListener listener) {
        this.listener = listener;
        this.redirectListener.setListener(listener);
    }

    public KeyboardListener getKeyboardListener() {
        return this.keyboardListener;
    }

    public void updateData(Map<String, Object> data) {
        if (data != null && data.get("items") != null) {
            Map items = (Map)data.get("items");
            this.content.setVisible(false);
            DefaultComboBoxModel<ComboBoxItem> listModel = new DefaultComboBoxModel<ComboBoxItem>();
            this.list.setModel(listModel);
            for (String key : items.keySet()) {
                listModel.addElement(new ComboBoxItem(items.get(key), key));
            }
            this.buttonScreen.getNext().setEnabled(false);
            this.content.setVisible(true);
        }
    }

    public void onEvent(Event e) {
    }

    public ActionNotifier getActionNotifier() {
        return null;
    }

    private class LocalKeyboardListener
    extends KeyboardAdapter {
        private InputFieldModel model;
        private InputComponent activeComponent;

        private LocalKeyboardListener() {
        }

        public void setModel(InputFieldModel model) {
            this.model = model;
        }

        public void onKeyPress(char key) {
            if (this.model != null) {
                this.model.add(key);
            }
        }

        public void onClear() {
            if (this.model != null) {
                this.model.clear();
            }
        }

        public void onClearLast() {
            if (this.model != null) {
                this.model.clearLast();
            }
        }

        public void onEnter() {
            CpSearchProviderScreen.this.buttonScreen.getNext().doClick();
        }
    }

    private class ComboBoxItem {
        private Object object;
        private String name;

        public ComboBoxItem(Object object, String name) {
            this.object = object;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getObject() {
            return this.object;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComboBoxItem other = (ComboBoxItem)obj;
            return this.object == other.object || this.object != null && this.object.equals(other.object);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.object != null ? this.object.hashCode() : 0);
            return hash;
        }
    }

    private class LocalSelectorListener
    implements ListSelectionListener {
        private LocalSelectorListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() instanceof JList) {
                JList list = (JList)e.getSource();
                if (list.getSelectedValue() != null) {
                    CpSearchProviderScreen.this.buttonScreen.getNext().setEnabled(true);
                } else {
                    CpSearchProviderScreen.this.buttonScreen.getNext().setEnabled(false);
                }
            }
        }
    }

    public class DefaultOnlineListRenderer
    extends DefaultListCellRenderer {
        Color first = Color.WHITE;
        Color second = Color.WHITE;
        Color selected = new Color(5488872);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                c.setBackground(this.selected);
                c.setForeground(Color.WHITE);
            } else {
                if (index % 2 == 0) {
                    c.setBackground(this.first);
                } else {
                    c.setBackground(this.second);
                }
                c.setForeground(BsConstants.textColorDarkBlue2);
            }
            return c;
        }
    }

    private class LocalActionListener
    implements ActionListener {
        private String type;

        public LocalActionListener(String type) {
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionType.isNext((String)this.type)) {
                if (CpSearchProviderScreen.this.list.getSelectedValue() != null && CpSearchProviderScreen.this.list.getSelectedValue() instanceof ComboBoxItem) {
                    MenuItem mi = (MenuItem)((ComboBoxItem)CpSearchProviderScreen.this.list.getSelectedValue()).getObject();
                    CpSearchProviderScreen.this.listener.onRedirect(mi.getService().getId());
                }
            } else {
                CpSearchProviderScreen.this.listener.onAction(this.type, null, null);
            }
        }
    }

    private class LocalTextFieldModelListener
    implements FieldListener {
        private LocalTextFieldModelListener() {
        }

        public void onChange(String value) {
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("input", CpSearchProviderScreen.this.model.getValue());
            CpSearchProviderScreen.this.inputPanel.getView().setText(value);
            CpSearchProviderScreen.this.listener.onAction("Edit", data, null);
        }
    }
}

