/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.screen.menu;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.screen.content.RedirectListener;
import ru.softlogic.gui.screen.content.banner.AdvHelper;
import ru.softlogic.gui.screen.menu.LayerData;
import ru.softlogic.gui.screen.menu.MenuLayer;
import ru.softlogic.gui.screen.menu.MenuLayerListener;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.menu.GroupByLabelVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.content.panel.add.CpButtonMenuScreen;
import ru.softlogic.skin.kengu24.content.panel.add.CpInfoPanel;

public class VoidMenuLayer
implements MenuLayer {
    private JPanel main = new ImagePanel(BsImageStore.getInstance().getBackGround("bg"), true);
    private JLabel label;
    private CpButtonMenuScreen buttonMenuScreen;
    private Set<MenuLayerListener> listeners;
    private CpInfoPanel infoPanel;

    public VoidMenuLayer() {
        this.main.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{Scaler.y((int)200), Scaler.y((int)30), Scaler.y((int)0), -1.0, -2.0, Scaler.y((int)24)}));
        this.infoPanel = new CpInfoPanel();
        this.main.add((Component)this.infoPanel.getPanel(), "0,1");
        this.label = new JLabel();
        this.label.setFont(FontFactory.getInstance().createFont("mainmenu.void"));
        this.label.setForeground(BsConstants.textColorWhite);
        this.main.add((Component)this.label, "0,3,c,c");
        this.buttonMenuScreen = new CpButtonMenuScreen();
        this.buttonMenuScreen.getMain().addActionListener((ActionListener)new LocalBackListener());
        this.buttonMenuScreen.getNext().setVisible(false);
        this.buttonMenuScreen.getPrev().setVisible(false);
        this.main.add((Component)this.buttonMenuScreen.getPanel(), "0,4");
        this.listeners = new HashSet<MenuLayerListener>();
    }

    public void addListener(MenuLayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void initLayer(LayerData data) {
        kb.setLocale(data.getLocale());
        this.label.setText(kb.getString("mainmenu.void"));
        this.buttonMenuScreen.getMain().setText(kb.getString("shell.button.main.cancel"));
        LinkedList bi = new LinkedList();
        JPanel bannerPanel = AdvHelper.getImageBanner(null, null, (String)"TOP", (int)Scaler.x((int)1280), (int)Scaler.y((int)200), (RedirectListener)new LocalRedirectListener(), null, bi, (boolean)true);
        if (bannerPanel != null) {
            this.main.add((Component)bannerPanel, "0,0");
        }
    }

    public JPanel getPanel() {
        return this.main;
    }

    private class LocalRedirectListener
    implements RedirectListener {
        private LocalRedirectListener() {
        }

        public void onRedirect(int serviceId) {
            for (MenuLayerListener mll : VoidMenuLayer.this.listeners) {
                mll.onRedirect(serviceId);
            }
        }

        public void toLabel(int label) {
            GroupByLabelVisitor visitor = new GroupByLabelVisitor(label);
            MenuUtils.processMenu((MenuVisitor)visitor);
            if (visitor.getServiceType() != null) {
                for (MenuLayerListener mll : VoidMenuLayer.this.listeners) {
                    mll.onGroup(visitor.getServiceType());
                }
            }
        }
    }

    private class LocalBackListener
    implements ActionListener {
        private LocalBackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MenuLayerListener mll : VoidMenuLayer.this.listeners) {
                mll.onExit();
            }
        }
    }
}

