/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.screen.menu;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.DataButtonListener;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.gui.components.button.LabeledClickButton;
import ru.softlogic.gui.screen.content.RedirectListener;
import ru.softlogic.gui.screen.content.banner.AdvHelper;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.screen.menu.LayerData;
import ru.softlogic.gui.screen.menu.MenuLayer;
import ru.softlogic.gui.screen.menu.MenuLayerListener;
import ru.softlogic.gui.screen.menu.listeners.CommonButtonListener;
import ru.softlogic.gui.utils.ComponentUtil;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.menu.ComplexMenuItem;
import ru.softlogic.gui.utils.menu.GroupByLabelVisitor;
import ru.softlogic.gui.utils.menu.HotKeyVisitor;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.content.panel.add.CpInfoPanel;
import ru.softlogic.skin.kengu24.factory.BsButtonFactory;
import ru.softlogic.skin.kengu24.utils.ButtonHelper;

public class MainMenuLayer
implements MenuLayer {
    private JPanel hotKeysPanel;
    private JPanel groupKeyPanel;
    private JPanel mainPanel;
    private JPanel navigateButtonPanel;
    private ResourceBundle bundle;
    private Set<MenuLayerListener> listeners = new HashSet<MenuLayerListener>();
    private LocalGroupListener groupListener;
    private LocalMenuListener menuListener;
    private NaviListener naviListener;
    private final JPanel panel;
    private LabeledClickButton statusButton;
    private LabeledClickButton searchProviderButton;
    private LabeledClickButton infoButton;
    private LabeledClickButton checkButton;
    private CpInfoPanel infoPanel;
    private Logger log;
    private Locale currentLocal;
    private ServiceType[] allServiceTypes;

    public MainMenuLayer() {
        this.mainPanel = new ImagePanel(BsImageStore.getInstance().getBackGround("bg"), true);
        this.mainPanel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{Scaler.y((int)200), -2.0, -1.0}));
        this.infoPanel = new CpInfoPanel();
        this.mainPanel.add((Component)this.infoPanel.getPanel(), "0,1");
        int smallButtonW = 163;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{0.0, -2.0, -2.0, -1.0, -2.0, Scaler.y((int)24)}));
        this.mainPanel.add((Component)this.panel, "0,2");
        this.statusButton = BsButtonFactory.createCheckStatusButton();
        this.statusButton.addActionListener((ActionListener)new LocalStatusListener());
        this.searchProviderButton = BsButtonFactory.createSearchProvider();
        this.searchProviderButton.addActionListener((ActionListener)new LocalSearchProviderListener());
        this.infoButton = BsButtonFactory.createInfoButton();
        this.infoButton.addActionListener((ActionListener)new LocalOfferListener());
        this.checkButton = BsButtonFactory.createPrintCheckButton();
        this.checkButton.addActionListener((ActionListener)new LocalCheckCopyListener());
        this.hotKeysPanel = ComponentUtil.createJPanelBySize((int)Scaler.x((int)1280), (int)Scaler.y((int)(smallButtonW + 37)));
        this.hotKeysPanel.setOpaque(false);
        TableLayout tableLayout = new TableLayout(new double[]{Scaler.x((int)30), Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), Scaler.x((int)30)}, new double[]{Scaler.y((int)20), Scaler.y((int)smallButtonW), Scaler.y((int)17)});
        this.hotKeysPanel.setLayout((LayoutManager)tableLayout);
        this.panel.add((Component)this.hotKeysPanel, "0,1");
        this.groupKeyPanel = new JPanel();
        this.groupKeyPanel.setOpaque(false);
        TableLayout groupTableLayout = new TableLayout(new double[]{Scaler.x((int)30), Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), Scaler.x((int)30)}, new double[]{Scaler.y((int)207), Scaler.y((int)207)});
        groupTableLayout.setVGap(20);
        this.groupKeyPanel.setLayout((LayoutManager)groupTableLayout);
        this.panel.add((Component)this.groupKeyPanel, "0,2");
        this.navigateButtonPanel = new JPanel();
        this.navigateButtonPanel.setOpaque(false);
        TableLayout navigateTableLayout = new TableLayout(new double[]{Scaler.x((int)30), Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), Scaler.x((int)30)}, new double[]{-2.0});
        this.navigateButtonPanel.setLayout((LayoutManager)navigateTableLayout);
        this.panel.add((Component)this.navigateButtonPanel, "0,4");
        this.log = Logger.getLogger((String)"gui");
        this.log.setAdditivity(false);
        this.menuListener = new LocalMenuListener();
        this.groupListener = new LocalGroupListener();
    }

    public void initLayer(LayerData data) {
        kb.setLocale(data.getLocale());
        this.hotKeysPanel.setVisible(false);
        this.hotKeysPanel.removeAll();
        this.navigateButtonPanel.setVisible(false);
        this.statusButton.getJLabel().setText(kb.getString("shell.button.paysearch"));
        this.searchProviderButton.getJLabel().setText(kb.getString("shell.button.providersearch"));
        this.infoButton.getJLabel().setText(kb.getString("shell.button.offer"));
        this.checkButton.getJLabel().setText(kb.getString("shell.button.chcopy"));
        String title = "";
        if (data.getChange() != null && !data.getChange().isEmpty()) {
            title = MessageFormat.format(kb.getString("title.change"), data.getChange());
        }
        if (data.getDeep() > 0) {
            this.infoPanel.getInfo2().setText(title);
        }
        CommonButtonListener hkcbl = new CommonButtonListener(this.listeners);
        if (data.getRoot() != null) {
            IconifiedClickButton button;
            HotKeyVisitor hkv = new HotKeyVisitor(7, true);
            MenuUtils.processMenu((MenuVisitor)hkv);
            ComplexMenuItem[] items = hkv.getSortedItems();
            int idx = 0;
            for (ComplexMenuItem cmi : items) {
                button = BsButtonFactory.createSmallServiceButton();
                button.setSize(new Dimension(Scaler.x((int)163), Scaler.y((int)163)));
                button.setPreferredSize(new Dimension(Scaler.x((int)163), Scaler.y((int)163)));
                ButtonHelper.initSmallServiceButton(button, cmi.getMenuItem(), cmi.getState(), data.getLocale());
                button.addActionListener((ActionListener)hkcbl);
                if (cmi != null && cmi.getState() != null && (cmi.getState().getButtonStatus() == ButtonStatus.Blocked || cmi.getState().getButtonStatus() == ButtonStatus.Hidden)) {
                    button.setEnabled(false);
                } else {
                    button.setEnabled(true);
                }
                this.hotKeysPanel.add((Component)button, "" + (idx * 2 + 1) + ",1");
                if (++idx == 7) break;
            }
            int pos = 0;
            if (data.getRoot().getMenuItems() != null) {
                for (int i = 0; i < 7 && i < data.getRoot().getMenuItems().length; ++i) {
                    MenuItem mi = data.getRoot().getMenuItems()[i];
                    MenuItemState mis = StateUtil.getState((MenuItem)mi, (MenuItemState[])data.getMenuItemStates());
                    button = null;
                    if (button == null) {
                        button = BsButtonFactory.createSmallServiceButton();
                        button.setSize(new Dimension(Scaler.x((int)163), Scaler.y((int)163)));
                    }
                    button.setPreferredSize(new Dimension(Scaler.x((int)163), Scaler.y((int)163)));
                    ButtonHelper.initSmallServiceButton(button, mi, mis, data.getLocale());
                    button.addActionListener((ActionListener)((Object)this.menuListener));
                    if (mis != null && (mis.getButtonStatus() == ButtonStatus.Blocked || mis.getButtonStatus() == ButtonStatus.Hidden)) {
                        button.setEnabled(false);
                    } else {
                        button.setEnabled(true);
                    }
                    this.hotKeysPanel.add((Component)button, "" + (pos * 2 + 1) + ",1");
                    ++pos;
                }
            }
            this.currentLocal = data.getLocale();
            this.allServiceTypes = data.getRoot().getTypes();
            this.naviListener = new NaviListener();
            this.updateRubricGroups(0);
            this.navigateButtonPanel.add((Component)this.statusButton, "1,0,c,c");
            this.navigateButtonPanel.add((Component)this.searchProviderButton, "3,0,c,c");
            this.navigateButtonPanel.add((Component)this.checkButton, "5,0,c,c");
            this.navigateButtonPanel.add((Component)this.infoButton, "7,0,c,c");
        }
        LinkedList bi = new LinkedList();
        JPanel bannerPanel = AdvHelper.getImageBanner(null, null, (String)"TOP", (int)Scaler.x((int)1280), (int)Scaler.y((int)200), (RedirectListener)new LocalRedirectListener(), null, bi, (boolean)true);
        if (bannerPanel != null) {
            this.mainPanel.add((Component)bannerPanel, "0,0");
        }
        this.hotKeysPanel.setVisible(true);
        this.navigateButtonPanel.setVisible(true);
    }

    private void updateRubricGroups(int screenNo) {
        this.groupKeyPanel.setVisible(false);
        this.groupKeyPanel.removeAll();
        CommonButtonListener cbl = new CommonButtonListener(this.listeners);
        ArrayList<ServiceType> visibleSTs = new ArrayList<ServiceType>();
        for (ServiceType st : this.allServiceTypes) {
            if (st.getName().startsWith("#") || st.getHidden()) continue;
            visibleSTs.add(st);
        }
        if (visibleSTs.size() > 0) {
            int serviceCellsCount = 8;
            int screenNum = 1;
            if (visibleSTs.size() - 8 > 0) {
                int count = visibleSTs.size() - 7;
                if (count == 7) {
                    ++screenNum;
                } else {
                    if (count - 7 > 0) {
                        count -= 7;
                        ++screenNum;
                    }
                    screenNum += count / (serviceCellsCount - 2) + (count % (serviceCellsCount - 2) == 0 ? 0 : 1);
                }
            }
            if (visibleSTs.size() > 0) {
                int groupCellCount = 7;
                if (screenNum == 1) {
                    groupCellCount = 8;
                }
                if (screenNo != 0 && screenNo != screenNum - 1) {
                    groupCellCount = 6;
                }
                int groupCount = 7;
                if (screenNo == 0) {
                    groupCount = 0;
                } else if (screenNo > 1) {
                    groupCount += (screenNo - 1) * 6;
                }
                int xPos = 0;
                int yPos = 0;
                if (screenNo != 0 && screenNum > 1) {
                    ++xPos;
                }
                for (int i = 0; i < groupCellCount && i + groupCount < visibleSTs.size(); ++i) {
                    ServiceType st = (ServiceType)visibleSTs.get(i + groupCount);
                    IconifiedClickButton button = BsButtonFactory.createGroupIconifiedButton(i + 1);
                    button.addActionListener((ActionListener)cbl);
                    ButtonHelper.initButton(button, st, this.currentLocal, BsImageStore.imagePrefixM);
                    this.groupKeyPanel.add((Component)button, "" + (xPos * 2 + 1) + ", " + yPos + ",c,c");
                    if (++xPos <= 3) continue;
                    ++yPos;
                    xPos = 0;
                }
                if (screenNum > 1) {
                    IconifiedClickButton button;
                    if (screenNo != screenNum - 1) {
                        ServiceType st = new ServiceType();
                        st.setImage("next.png");
                        st.setName(kb.getString("menu.next"));
                        button = BsButtonFactory.createGroupIconifiedButton(1);
                        button.addActionListener((ActionListener)this.naviListener);
                        button.setPreferredSize(new Dimension(Scaler.x((int)296), Scaler.y((int)207)));
                        ButtonHelper.initButton(button, st, this.currentLocal, BsImageStore.imagePrefixM);
                        button.putClientProperty((Object)"screen", (Object)new Integer(screenNo + 1));
                        this.groupKeyPanel.add((Component)button, "7,1,f,f");
                    }
                    if (screenNo != 0) {
                        ServiceType st = new ServiceType();
                        st.setImage("back.png");
                        st.setName(kb.getString("menu.prev"));
                        button = BsButtonFactory.createGroupIconifiedButton(1);
                        button.addActionListener((ActionListener)this.naviListener);
                        button.setPreferredSize(new Dimension(Scaler.x((int)296), Scaler.y((int)207)));
                        ButtonHelper.initButton(button, st, this.currentLocal, BsImageStore.imagePrefixM);
                        button.putClientProperty((Object)"screen", (Object)new Integer(screenNo - 1));
                        this.groupKeyPanel.add((Component)button, "1,0,f,f");
                    }
                }
            }
        }
        this.groupKeyPanel.setVisible(true);
    }

    public void addListener(MenuLayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    private class LocalRedirectListener
    implements RedirectListener {
        private LocalRedirectListener() {
        }

        public void onRedirect(int serviceId) {
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId);
            MenuUtils.processMenu((MenuVisitor)mbsiv);
            MenuItem mi = mbsiv.getMenuItem();
            for (MenuLayerListener mll : MainMenuLayer.this.listeners) {
                mll.onMenuItem(mi, null);
            }
        }

        public void toLabel(int label) {
            GroupByLabelVisitor visitor = new GroupByLabelVisitor(label);
            MenuUtils.processMenu((MenuVisitor)visitor);
            if (visitor.getServiceType() != null) {
                for (MenuLayerListener mll : MainMenuLayer.this.listeners) {
                    mll.onGroup(visitor.getServiceType());
                }
            }
        }
    }

    private class LocalCheckCopyListener
    implements ActionListener {
        private LocalCheckCopyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppEnvironment.getInstance().open(ProviderType.ChCopyProvider);
        }
    }

    private class LocalSearchProviderListener
    implements ActionListener {
        private LocalSearchProviderListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppEnvironment.getInstance().open(ProviderType.SearchService);
        }
    }

    private class LocalStatusListener
    implements ActionListener {
        private LocalStatusListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppEnvironment.getInstance().open(ProviderType.PaymentStatusProvider);
        }
    }

    private class LocalOfferListener
    implements ActionListener {
        private LocalOfferListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MenuLayerListener mll : MainMenuLayer.this.listeners) {
                mll.onOffer();
            }
        }
    }

    private class LocalMenuListener
    implements DataButtonListener<MenuItem> {
        private LocalMenuListener() {
        }

        public void update(MenuItem data) {
            for (MenuLayerListener mll : MainMenuLayer.this.listeners) {
                mll.onMenuItem(data, null);
            }
        }
    }

    private class LocalGroupListener
    implements DataButtonListener<ServiceType> {
        private LocalGroupListener() {
        }

        public void update(ServiceType data) {
            for (MenuLayerListener mll : MainMenuLayer.this.listeners) {
                mll.onGroup(data);
            }
        }
    }

    private class NaviListener
    implements ActionListener {
        private NaviListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClickButton navi = (ClickButton)e.getSource();
            Integer screen = (Integer)navi.getClientProperty((Object)"screen");
            MainMenuLayer.this.updateRubricGroups(screen);
        }
    }
}

