/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.screen.menu;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.gui.components.button.LabeledClickButton;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.screen.menu.LayerData;
import ru.softlogic.gui.screen.menu.MenuLayer;
import ru.softlogic.gui.screen.menu.MenuLayerListener;
import ru.softlogic.gui.screen.menu.listeners.CommonButtonListener;
import ru.softlogic.gui.utils.ComponentUtil;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.content.panel.add.CpInfoPanel;
import ru.softlogic.skin.kengu24.content.screen.menu.ItemComparator;
import ru.softlogic.skin.kengu24.factory.BsButtonFactory;
import ru.softlogic.skin.kengu24.utils.ButtonHelper;

public class DefaultGroupLayer2
implements MenuLayer {
    private JPanel hotKeysPanel;
    private JPanel groupKeyPanel;
    private JPanel mainPanel;
    private JPanel navigateButtonPanel;
    private JPanel panel;
    private LabeledClickButton checkButton;
    private LabeledClickButton infoButton;
    private LabeledClickButton searchProviderButton;
    private LabeledClickButton statusButton;
    private IconifiedClickButton[] hotButtons;
    private CpInfoPanel infoPanel;
    private Set<MenuLayerListener> listeners;
    private NaviListener naviListener;
    private Logger log;
    private Locale currentLocal;
    private ServiceType[] allServiceTypes;
    private MenuItem[] allMenuItems;
    private MenuItemState[] menuItemStates;
    private boolean addHotToMax = true;

    public DefaultGroupLayer2(boolean nAddHotToMax) {
        this.addHotToMax = nAddHotToMax;
        this.listeners = new HashSet<MenuLayerListener>();
        this.mainPanel = new ImagePanel(BsImageStore.getInstance().getBackGround("bg"), true);
        this.mainPanel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{-2.0, -1.0}));
        int smallButtonW = 163;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{Scaler.y((int)45), -2.0, -2.0, -1.0, -2.0, Scaler.y((int)24)}));
        this.mainPanel.add((Component)this.panel, "0,1");
        this.infoPanel = new CpInfoPanel();
        this.panel.add((Component)this.infoPanel.getPanel(), "0,0");
        this.statusButton = BsButtonFactory.createCheckStatusButton();
        this.statusButton.addActionListener((ActionListener)new LocalStatusListener());
        this.searchProviderButton = BsButtonFactory.createSearchProvider();
        this.searchProviderButton.addActionListener((ActionListener)new LocalSearchProviderListener());
        this.infoButton = BsButtonFactory.createInfoButton();
        this.infoButton.addActionListener((ActionListener)new LocalOfferListener());
        this.checkButton = BsButtonFactory.createExit();
        this.checkButton.addActionListener((ActionListener)new LocalBackListener());
        this.hotKeysPanel = ComponentUtil.createJPanelBySize((int)Scaler.x((int)1280), (int)Scaler.y((int)(smallButtonW + 26)));
        this.hotKeysPanel.setOpaque(false);
        TableLayout tableLayout = new TableLayout(new double[]{Scaler.x((int)30), Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), -1.0, Scaler.x((int)smallButtonW), Scaler.x((int)30)}, new double[]{0.0, Scaler.y((int)smallButtonW), Scaler.y((int)26)});
        this.hotKeysPanel.setLayout((LayoutManager)tableLayout);
        this.panel.add((Component)this.hotKeysPanel, "0,1");
        CommonButtonListener hkcbl = new CommonButtonListener(this.listeners);
        this.hotButtons = new IconifiedClickButton[7];
        for (int i = 0; i < 7; ++i) {
            this.hotButtons[i] = BsButtonFactory.createSmallServiceButton();
            this.hotButtons[i].setSize(new Dimension(Scaler.x((int)163), Scaler.y((int)163)));
            this.hotButtons[i].setPreferredSize(new Dimension(Scaler.x((int)163), Scaler.y((int)163)));
            this.hotButtons[i].addActionListener((ActionListener)hkcbl);
        }
        this.groupKeyPanel = new JPanel();
        this.groupKeyPanel.setOpaque(false);
        TableLayout groupTableLayout = new TableLayout(new double[]{Scaler.x((int)30), Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), Scaler.x((int)30)}, new double[]{Scaler.y((int)207), Scaler.y((int)207), Scaler.y((int)207)});
        groupTableLayout.setVGap(10);
        this.groupKeyPanel.setLayout((LayoutManager)groupTableLayout);
        this.panel.add((Component)this.groupKeyPanel, "0,2");
        this.navigateButtonPanel = new JPanel();
        this.navigateButtonPanel.setOpaque(false);
        TableLayout navigateTableLayout = new TableLayout(new double[]{Scaler.x((int)30), Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), -1.0, Scaler.x((int)296), Scaler.x((int)30)}, new double[]{-2.0});
        this.navigateButtonPanel.setLayout((LayoutManager)navigateTableLayout);
        this.panel.add((Component)this.navigateButtonPanel, "0,4");
        this.log = Logger.getLogger((String)"gui");
        this.log.setAdditivity(false);
    }

    public void initLayer(LayerData data) {
        kb.setLocale(data.getLocale());
        this.hotKeysPanel.setVisible(false);
        this.hotKeysPanel.removeAll();
        this.navigateButtonPanel.setVisible(false);
        this.statusButton.getJLabel().setText(kb.getString("shell.button.paysearch"));
        this.searchProviderButton.getJLabel().setText(kb.getString("shell.button.providersearch"));
        this.infoButton.getJLabel().setText(kb.getString("shell.button.offer"));
        this.checkButton.getJLabel().setText(kb.getString("menu.exit"));
        String title = "";
        if (data.getChange() != null && !data.getChange().isEmpty()) {
            title = MessageFormat.format(kb.getString("title.change"), data.getChange());
        }
        if (data.getDeep() > 0) {
            this.infoPanel.getInfo2().setText(title);
        }
        if (data.getRoot() != null) {
            int serviceCount = ButtonHelper.initHotKeys(null, this.hotButtons, 7, this.addHotToMax, data.getLocale(), data.getRoot());
            if (serviceCount == 0) {
                serviceCount = ButtonHelper.initHotKeys(null, this.hotButtons, 7, this.addHotToMax, data.getLocale());
            }
            int idx = 0;
            for (int i = 0; i < serviceCount && i < this.hotButtons.length; ++i) {
                IconifiedClickButton button = this.hotButtons[i];
                this.hotKeysPanel.add((Component)button, "" + (idx * 2 + 1) + ",1");
                if (++idx == 7) break;
            }
            this.menuItemStates = data.getMenuItemStates();
            this.currentLocal = data.getLocale();
            this.allServiceTypes = data.getRoot().getTypes();
            this.allMenuItems = data.getRoot().getMenuItems();
            this.naviListener = new NaviListener();
            this.updateRubricGroups(0);
            this.navigateButtonPanel.add((Component)this.searchProviderButton, "3,0,c,c");
            this.navigateButtonPanel.add((Component)this.checkButton, "5,0,c,c");
        }
        this.hotKeysPanel.setVisible(true);
        this.navigateButtonPanel.setVisible(true);
    }

    private void updateRubricGroups(int screenNo) {
        this.groupKeyPanel.setVisible(false);
        this.groupKeyPanel.removeAll();
        CommonButtonListener cbl = new CommonButtonListener(this.listeners);
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.allServiceTypes != null) {
            list.addAll(Arrays.asList(this.allServiceTypes));
        }
        if (this.allMenuItems != null) {
            list.addAll(Arrays.asList(this.allMenuItems));
        }
        MenuUtils.clearBlockedSchedule(list, (boolean)false);
        MenuUtils.clearHidden(list, (MenuItemState[])this.menuItemStates);
        Collections.sort(list, new ItemComparator());
        if (list.size() > 0) {
            int serviceCellsCount = 12;
            int screenNum = 1;
            if (list.size() - 12 > 0) {
                int count = list.size() - 11;
                if (count == 11) {
                    ++screenNum;
                } else {
                    if (count - 11 > 0) {
                        count -= 11;
                        ++screenNum;
                    }
                    screenNum += count / (serviceCellsCount - 2) + (count % (serviceCellsCount - 2) == 0 ? 0 : 1);
                }
            }
            if (list.size() > 0) {
                int groupCellCount = 11;
                if (screenNum == 1) {
                    groupCellCount = 12;
                }
                if (screenNo != 0 && screenNo != screenNum - 1) {
                    groupCellCount = 10;
                }
                int groupCount = 11;
                if (screenNo == 0) {
                    groupCount = 0;
                } else if (screenNo > 1) {
                    groupCount += (screenNo - 1) * 10;
                }
                int xPos = 0;
                int yPos = 0;
                if (screenNo != 0 && screenNum > 1) {
                    ++xPos;
                }
                for (int i = 0; i < groupCellCount && i + groupCount < list.size(); ++i) {
                    IconifiedClickButton button;
                    Object obj = list.get(i + groupCount);
                    if (obj instanceof MenuItem) {
                        MenuItem mi = (MenuItem)obj;
                        button = BsButtonFactory.createGroupIconifiedButton(i + 1);
                        button.addActionListener((ActionListener)cbl);
                        MenuItemState mis = StateUtil.getState((MenuItem)mi, (MenuItemState[])this.menuItemStates);
                        button.setPreferredSize(new Dimension(Scaler.x((int)296), Scaler.y((int)207)));
                        ButtonHelper.initButton(button, mi, mis, this.currentLocal, BsImageStore.imagePrefixM);
                        this.groupKeyPanel.add((Component)button, "" + (xPos * 2 + 1) + ", " + yPos + ",c,c");
                        if (++xPos <= 3) continue;
                        ++yPos;
                        xPos = 0;
                        continue;
                    }
                    ServiceType st = (ServiceType)obj;
                    button = BsButtonFactory.createGroupIconifiedButton(i + 1);
                    button.addActionListener((ActionListener)cbl);
                    button.setPreferredSize(new Dimension(Scaler.x((int)296), Scaler.y((int)207)));
                    ButtonHelper.initButton(button, st, this.currentLocal, BsImageStore.imagePrefixM);
                    this.groupKeyPanel.add((Component)button, "" + (xPos * 2 + 1) + ", " + yPos + ",c,c");
                    if (++xPos <= 3) continue;
                    ++yPos;
                    xPos = 0;
                }
                if (screenNum > 1) {
                    IconifiedClickButton button;
                    if (screenNo != screenNum - 1) {
                        ServiceType st = new ServiceType();
                        st.setImage("next.png");
                        st.setName(kb.getString("menu.next"));
                        button = BsButtonFactory.createGroupIconifiedButton(1);
                        button.addActionListener((ActionListener)this.naviListener);
                        button.setPreferredSize(new Dimension(Scaler.x((int)296), Scaler.y((int)207)));
                        ButtonHelper.initButton(button, st, this.currentLocal, BsImageStore.imagePrefixM);
                        button.putClientProperty((Object)"screen", (Object)new Integer(screenNo + 1));
                        this.groupKeyPanel.add((Component)button, "7,2,f,f");
                    }
                    if (screenNo != 0) {
                        ServiceType st = new ServiceType();
                        st.setImage("back.png");
                        st.setName(kb.getString("menu.prev"));
                        button = BsButtonFactory.createGroupIconifiedButton(1);
                        button.addActionListener((ActionListener)this.naviListener);
                        button.setPreferredSize(new Dimension(Scaler.x((int)296), Scaler.y((int)207)));
                        ButtonHelper.initButton(button, st, this.currentLocal, BsImageStore.imagePrefixM);
                        button.putClientProperty((Object)"screen", (Object)new Integer(screenNo - 1));
                        this.groupKeyPanel.add((Component)button, "1,0,f,f");
                    }
                }
            }
        }
        this.groupKeyPanel.setVisible(true);
    }

    public void addListener(MenuLayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    private class LocalBackListener
    implements ActionListener {
        private LocalBackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MenuLayerListener mll : DefaultGroupLayer2.this.listeners) {
                mll.onExit();
            }
        }
    }

    private class LocalSearchProviderListener
    implements ActionListener {
        private LocalSearchProviderListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppEnvironment.getInstance().open(ProviderType.SearchService);
        }
    }

    private class LocalStatusListener
    implements ActionListener {
        private LocalStatusListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppEnvironment.getInstance().open(ProviderType.PaymentStatusProvider);
        }
    }

    private class LocalOfferListener
    implements ActionListener {
        private LocalOfferListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MenuLayerListener mll : DefaultGroupLayer2.this.listeners) {
                mll.onOffer();
            }
        }
    }

    private class NaviListener
    implements ActionListener {
        private NaviListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClickButton navi = (ClickButton)e.getSource();
            Integer screen = (Integer)navi.getClientProperty((Object)"screen");
            DefaultGroupLayer2.this.updateRubricGroups(screen);
        }
    }
}

