/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.screen.menu;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.screen.content.menu.MenuListener;
import ru.softlogic.gui.screen.content.menu.MenuParams;
import ru.softlogic.gui.screen.content.menu.MenuScreen;
import ru.softlogic.gui.screen.menu.LayerData;
import ru.softlogic.gui.screen.menu.MenuLayer;
import ru.softlogic.gui.screen.menu.MenuLayerListener;
import ru.softlogic.gui.utils.VSTemplateProcessor;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ScreenType;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.content.screen.CpOfferScreen;
import ru.softlogic.skin.kengu24.content.screen.menu.MenuLayerFactory;
import ru.softlogic.skin.kengu24.content.screen.menu.VoidMenuLayer;
import ru.softlogic.system.util.PathUtils;

public class BsMenuScreen
implements MenuScreen {
    private MenuListener listener;
    private Logger log;
    private JPanel mainPanel;
    private JPanel menuPanel;
    private MenuParams mp;
    private CpOfferScreen offerScreen;
    private CpOfferScreen helpScreen;
    private LocalBackListener backListener;
    private VSTemplateProcessor processor;
    private VoidMenuLayer voidMenuLayer;
    private Map<String, MenuLayer> layers;
    private Runnable cancelListener;
    private Stack<ServiceType> stack;
    private Sum change;
    private boolean addHotToMax = true;

    public BsMenuScreen(boolean nAddHotToMax) {
        this.addHotToMax = nAddHotToMax;
        this.mainPanel = new JPanel(new BorderLayout());
        this.menuPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.menuPanel);
        this.voidMenuLayer = new VoidMenuLayer();
        this.voidMenuLayer.addListener(new LocalMenuLayerListener());
        this.layers = new HashMap<String, MenuLayer>();
        this.log = Logger.getLogger((String)"gui");
        this.log.setAdditivity(false);
        this.backListener = new LocalBackListener();
        this.offerScreen = new CpOfferScreen();
        this.offerScreen.getButtonMenuScreen().getMain().addActionListener((ActionListener)this.backListener);
        this.helpScreen = new CpOfferScreen();
        this.helpScreen.getButtonMenuScreen().getMain().addActionListener((ActionListener)this.backListener);
        try {
            this.processor = new VSTemplateProcessor(PathUtils.getAppHome());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stack = new Stack();
    }

    public void setMenu(MenuParams mp) {
        this.mp = mp;
        this.localize();
    }

    private void localize() {
        kb.setLocale(this.mp.getLocale());
        this.offerScreen.getButtonMenuScreen().getPrev().setText(kb.getString("shell.button.main.back"));
        this.offerScreen.setTitle(kb.getString("shell.button.offer"));
        this.helpScreen.getButtonMenuScreen().getPrev().setText(kb.getString("shell.button.main.back"));
        this.helpScreen.setTitle(kb.getString("shell.button.assistance"));
    }

    public void toRootLayer() {
        this.backListener.actionPerformed(null);
        this.stack.clear();
        this.stack.push(null);
        this.paintMenuLayer();
    }

    public void toServiceType(ServiceType st) {
        this.log.info((Object)("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043a \u0433\u0440\u0443\u043f\u043f\u0435: " + st));
        this.stack.push(st);
        this.paintMenuLayer();
    }

    public void setListener(MenuListener listener) {
        this.listener = listener;
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    private void paintMenuLayer() {
        MenuLayer ml;
        this.log.info((Object)("Stack: " + this.stack));
        ServiceType parent = this.stack.peek();
        this.offerScreen.initLayer(new LayerData(parent, this.mp.getStates(), this.mp.getDealer(), this.mp.getPoint(), this.getLangs(), this.mp.getLocale(), this.stack.size(), this.stack.size() > 2, this.mp.getChange(), this.mp.getChangeTimeout()));
        if (parent == null) {
            ServiceType st = new ServiceType();
            if (this.mp.getMenu() != null) {
                this.log.debug((Object)("root.size=" + this.mp.getMenu().getTypes().length));
                if (this.mp.getMenu().getTypes() != null && this.mp.getMenu().getTypes().length == 1) {
                    st = this.mp.getMenu().getTypes()[0];
                } else {
                    st.setTypes(this.mp.getMenu().getTypes());
                    st.setScreenType(this.mp.getMenu().getScreenType());
                }
            }
            LayerData ld = new LayerData(st, this.mp.getStates(), this.mp.getDealer(), this.mp.getPoint(), this.getLangs(), this.mp.getLocale(), this.stack.size(), this.stack.size() > 2, this.mp.getChange(), this.mp.getChangeTimeout(), this.mp.getIntentType());
            ml = this.getMenuLayer(st.getScreenType());
            ml.initLayer(ld);
        } else if (parent.getMenuItems() != null && parent.getMenuItems().length > 0 || parent.getTypes() != null && parent.getTypes().length > 0) {
            MediaPlayer.getInstance().play("operator.mp3");
            ml = this.getMenuLayer(parent.getScreenType());
            ml.initLayer(new LayerData(parent, this.mp.getStates(), this.mp.getDealer(), this.mp.getPoint(), this.getLangs(), this.mp.getLocale(), this.stack.size(), this.stack.size() > 2, this.mp.getChange(), this.mp.getChangeTimeout(), this.mp.getIntentType()));
            this.log.info((Object)("\u041f\u0435\u0440\u0435\u0445\u043e\u0434\u0438\u043c \u043d\u0430 \u044d\u043a\u0440\u0430\u043d: " + ml));
        } else {
            this.log.info((Object)"\u0412\u044b\u0432\u043e\u0434\u0438\u043c \u043f\u0443\u0441\u0442\u0443\u044e \u043f\u0430\u043d\u0435\u043b\u044c");
            LayerData ld = new LayerData(parent, this.mp.getStates(), this.mp.getDealer(), this.mp.getPoint(), this.getLangs(), this.mp.getLocale(), this.stack.size(), this.stack.size() > 2, this.mp.getChange(), this.mp.getChangeTimeout(), this.mp.getIntentType());
            this.voidMenuLayer.initLayer(ld);
            ml = this.voidMenuLayer;
        }
        this.menuPanel.setVisible(false);
        this.menuPanel.removeAll();
        this.menuPanel.add(ml.getPanel());
        this.menuPanel.setVisible(true);
    }

    private MenuLayer getMenuLayer(ScreenType screenType) {
        this.log.debug((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0430\u043d\u0435\u043b\u044c \u0434\u043b\u044f: " + screenType));
        String type = screenType == null || screenType.getCode() == null ? (this.stack.size() == 1 ? "default-main" : "default") : screenType.getCode();
        MenuLayer ml = this.layers.get(type);
        if (ml != null) {
            return ml;
        }
        ml = MenuLayerFactory.createLayer(type, this.addHotToMax);
        if (ml != null) {
            ml.addListener((MenuLayerListener)new LocalMenuLayerListener());
            this.layers.put(type, ml);
            return ml;
        }
        String d = this.stack.size() == 1 ? "default-main" : "default";
        ml = this.layers.get(d);
        if (ml == null) {
            ml = MenuLayerFactory.createLayer(d, this.addHotToMax);
            ml.addListener((MenuLayerListener)new LocalMenuLayerListener());
            this.layers.put(d, ml);
        }
        return ml;
    }

    private MenuLayer getMainMenuLayer(ScreenType screenType) {
        if (screenType == null) {
            screenType = new ScreenType();
        }
        this.log.info((Object)("\u0422\u0438\u043f \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u044d\u043a\u0440\u0430\u043d\u0430: " + screenType));
        return this.getMenuLayer(screenType);
    }

    public void afterShow() {
    }

    public void afterHide() {
    }

    public void restore() {
        if (this.cancelListener != null) {
            this.cancelListener.run();
        }
    }

    private void setDefaultIntent() {
        if (this.mp != null) {
            this.mp.setIntentType(null);
        }
    }

    private String getContent(String first, String second) {
        String res = this.processor.process(first);
        if (res != null) {
            return res;
        }
        return this.processor.process(second);
    }

    private String[] getLangs() {
        if (this.mp.getPointOptions() != null && this.mp.getPointOptions().getLanguages() != null && !this.mp.getPointOptions().getLanguages().isEmpty()) {
            String languages = this.mp.getPointOptions().getLanguages();
            String defaultLanguage = this.mp.getPointOptions().getLanguage();
            languages = (defaultLanguage.endsWith(";") ? defaultLanguage : defaultLanguage + ";") + languages;
            return languages.split(";|,");
        }
        return null;
    }

    private class LocalBackListener
    implements ActionListener {
        private LocalBackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BsMenuScreen.this.mainPanel.setVisible(false);
                    BsMenuScreen.this.mainPanel.removeAll();
                    BsMenuScreen.this.mainPanel.add(BsMenuScreen.this.menuPanel);
                    BsMenuScreen.this.mainPanel.setVisible(true);
                }
            });
        }
    }

    private class LocalMenuLayerListener
    implements MenuLayerListener {
        private LocalMenuLayerListener() {
        }

        public void onMenuItem(MenuItem mi, Runnable cancelListener) {
            BsMenuScreen.this.cancelListener = cancelListener;
            if (BsMenuScreen.this.listener != null) {
                BsMenuScreen.this.listener.onUserAction(mi, null);
            }
        }

        public void onGroup(ServiceType st) {
            BsMenuScreen.this.log.info((Object)("\u0412\u044b\u0431\u0440\u0430\u043d\u0430 \u0433\u0440\u0443\u043f\u043f\u0430: " + st));
            BsMenuScreen.this.setDefaultIntent();
            BsMenuScreen.this.stack.push(st);
            BsMenuScreen.this.paintMenuLayer();
        }

        public void onExit() {
            BsMenuScreen.this.log.info((Object)"\u0412\u044b\u0445\u043e\u0434 \u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e");
            BsMenuScreen.this.setDefaultIntent();
            BsMenuScreen.this.toRootLayer();
        }

        public void onBack() {
            BsMenuScreen.this.log.info((Object)"\u0412\u044b\u0445\u043e\u0434 \u043d\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0432\u0432\u0435\u0440\u0445");
            BsMenuScreen.this.setDefaultIntent();
            BsMenuScreen.this.stack.pop();
            BsMenuScreen.this.paintMenuLayer();
        }

        public void onLanguage(String lang) {
            BsMenuScreen.this.mp.setLocale(new Locale(lang, BsMenuScreen.this.mp.getLocale().getCountry()));
            BsMenuScreen.this.localize();
            if (BsMenuScreen.this.listener != null) {
                BsMenuScreen.this.listener.onLangSelection(lang);
            }
        }

        public void onOffer() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BsMenuScreen.this.mainPanel.setVisible(false);
                    BsMenuScreen.this.mainPanel.removeAll();
                    BsMenuScreen.this.offerScreen.setText(BsMenuScreen.this.processor.process("offer.html"));
                    BsMenuScreen.this.offerScreen.getButtonMenuScreen().getMain().setText(kb.getString("shell.button.main.cancel"));
                    BsMenuScreen.this.mainPanel.add(BsMenuScreen.this.offerScreen.getPanel());
                    BsMenuScreen.this.mainPanel.setVisible(true);
                }
            });
        }

        public void onAssistance() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BsMenuScreen.this.mainPanel.setVisible(false);
                    BsMenuScreen.this.mainPanel.removeAll();
                    BsMenuScreen.this.helpScreen.setText(BsMenuScreen.this.getContent("offer" + (BsMenuScreen.this.mp.getLocale() != null ? "_" + BsMenuScreen.this.mp.getLocale().getLanguage() : "") + ".html", "offer.html"));
                    BsMenuScreen.this.mainPanel.add(BsMenuScreen.this.helpScreen.getPanel());
                    BsMenuScreen.this.mainPanel.setVisible(true);
                }
            });
        }

        public void onStateRequest() {
            if (BsMenuScreen.this.listener != null) {
                BsMenuScreen.this.listener.onProvider(ProviderType.PaymentStatusProvider);
            }
        }

        public void onRedirect(int serviceId) {
            if (BsMenuScreen.this.listener != null) {
                BsMenuScreen.this.listener.onRedirect(serviceId);
            }
        }

        public void onGroup(int id) {
        }

        public void onServiceSearch() {
        }
    }
}

