/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.bundle;

import java.awt.Font;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.gui.utils.ScreenUtil;

public class FontFactory {
    private double scale = ScreenUtil.getScreenSize().getWidth() / 1280.0;
    private static FontFactory instance = new FontFactory();
    private ResourceBundle bundle = ResourceBundle.getBundle("ru.softlogic.skin.kengu24.bundle.FontBundle");
    private Font regularFont;
    private Font boldFont;
    private Font boldBoldFont;

    private FontFactory() {
    }

    public void setBoldBoldFont(Font nBoldBoldFont) {
        this.boldBoldFont = nBoldBoldFont;
    }

    public void setBoldFont(Font boldFont) {
        this.boldFont = boldFont;
    }

    public void setRegularFont(Font regularFont) {
        this.regularFont = regularFont;
    }

    public static FontFactory getInstance() {
        return instance;
    }

    public Font createFont(int size) {
        return this.regularFont.deriveFont(this.regularFont.getStyle(), (float)((double)size * this.scale));
    }

    public Font createBoldFont(int size) {
        return this.boldFont.deriveFont(this.boldFont.getStyle(), (float)((double)size * this.scale));
    }

    public Font createBoldBoldFont(int size) {
        return this.boldBoldFont.deriveFont(this.boldBoldFont.getStyle(), (float)((double)size * this.scale));
    }

    public Font createFont(String id) {
        Object obj = this.bundle.getObject(id);
        if (obj instanceof Integer) {
            return this.createFont((Integer)obj);
        }
        if (obj instanceof Font) {
            Font oldFont = (Font)obj;
            return new Font(oldFont.getName(), oldFont.getStyle(), (int)((double)oldFont.getSize() * this.scale));
        }
        return null;
    }

    public Font createBoldFont(String id) {
        Object obj = this.bundle.getObject(id);
        if (obj instanceof Integer) {
            return this.createBoldFont((Integer)obj);
        }
        if (obj instanceof Font) {
            Font oldFont = (Font)obj;
            return new Font(oldFont.getName(), oldFont.getStyle(), (int)((double)oldFont.getSize() * this.scale));
        }
        return null;
    }

    public Font createBoldBoldFont(String id) {
        Object obj = this.bundle.getObject(id);
        if (obj instanceof Integer) {
            return this.createBoldBoldFont((Integer)obj);
        }
        if (obj instanceof Font) {
            Font oldFont = (Font)obj;
            return new Font(oldFont.getName(), oldFont.getStyle(), (int)((double)oldFont.getSize() * this.scale));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Font loadFont(String name) {
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream("ru/softlogic/skin/bluesphere2/fonts/" + name);
            Font font = Font.createFont(0, is);
            return font;
        }
        catch (Exception ex) {
            Logger.getLogger((String)"start").error((Object)ex, (Throwable)ex);
            Font font = null;
            return font;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

