/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24;

import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import ru.softlogic.gui.utils.ImageStore;
import ru.softlogic.gui.utils.ImageUtil;
import ru.softlogic.gui.utils.Scaler;

public class BsImageStore
extends ImageStore {
    public static String imagePrefixL = "_l";
    public static String imagePrefixM = "_m";
    public static String imagePrefixS = "_s";
    public static String imageServicePath = "icon" + File.separator + "service" + File.separator;
    public static String imageGroupPath = "icon" + File.separator + "group" + File.separator;
    public static String imagePayoutPath = "icon" + File.separator + "payout" + File.separator;
    private static final Logger log = Logger.getLogger((String)"start");
    private static BsImageStore instance;
    private Map<String, SoftReference<Icon>> operatorIcon = new HashMap<String, SoftReference<Icon>>();
    protected Map<String, SoftReference<ImageIcon>> miniGroupButtonIcons;
    protected Map<String, SoftReference<ImageIcon>> miniGroupButtonIconsPress;
    protected Map<String, Map<String, SoftReference<ImageIcon>>> iconsMap;
    protected Map<String, Map<String, SoftReference<ImageIcon>>> iconsPressMap;
    private ImageIcon groupUpIcon;
    private ImageIcon groupDownIcon;
    private ImageIcon operatorUpIcon;
    private ImageIcon operatorDownIcon;

    private BsImageStore(String skin) {
        super(skin);
        if (this.groupUp != null) {
            this.groupUpIcon = new ImageIcon(this.groupUp);
        }
        if (this.groupDown != null) {
            this.groupDownIcon = new ImageIcon(this.groupDown);
        }
        if (this.operatorUp != null) {
            this.operatorUpIcon = new ImageIcon(this.operatorUp);
        }
        if (this.operatorDown != null) {
            this.operatorDownIcon = new ImageIcon(this.operatorDown);
        }
        this.miniGroupButtonIcons = new HashMap<String, SoftReference<ImageIcon>>();
        this.miniGroupButtonIconsPress = new HashMap<String, SoftReference<ImageIcon>>();
        this.iconsMap = new HashMap<String, Map<String, SoftReference<ImageIcon>>>();
        this.iconsPressMap = new HashMap<String, Map<String, SoftReference<ImageIcon>>>();
    }

    public static synchronized BsImageStore getInstance() {
        if (instance == null) {
            instance = new BsImageStore("kengu24");
            ImageIO.setUseCache(false);
        }
        return instance;
    }

    public static synchronized BsImageStore getInstance(String skin) {
        if (instance == null) {
            instance = new BsImageStore(skin);
            ImageIO.setUseCache(false);
        }
        return instance;
    }

    protected Map<String, Image> createBackGround() {
        HashMap<String, Image> res = new HashMap<String, Image>();
        try {
            Date d1 = new Date();
            Image bg = ImageIO.read(new File(this.basePath + "bg.png"));
            bg = bg.getScaledInstance(this.screenSize.width, Scaler.y((int)bg.getHeight(null)), 16);
            res.put("bg", bg);
            log.info((Object)("\u0420\u0430\u0437\u043c\u0435\u0440 bg: " + bg.getWidth(null) + "x" + bg.getHeight(null)));
            int hdrH = Scaler.y((int)200);
            Image tmp = null;
            try {
                tmp = ImageIO.read(new File(this.basePath + "topbnr.png"));
            }
            catch (Exception ex) {
                log.info((Object)"\u0424\u043e\u043d \u0434\u043b\u044f \u043d\u0430\u043d\u0435\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0411\u0435\u0440\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0444\u043e\u043d.");
            }
            if (tmp != null) {
                res.put("header", tmp);
                log.info((Object)("\u0420\u0430\u0437\u043c\u0435\u0440 header: " + tmp.getWidth(null) + "x" + tmp.getHeight(null)));
            } else {
                tmp = ImageUtil.cropImage((Image)bg, (int)0, (int)0, (int)bg.getWidth(null), (int)hdrH);
                res.put("header", tmp);
                log.info((Object)("\u0420\u0430\u0437\u043c\u0435\u0440 header: " + tmp.getWidth(null) + "x" + tmp.getHeight(null)));
            }
            int btnH = Scaler.y((int)163);
            tmp = ImageUtil.cropImage((Image)bg, (int)0, (int)(bg.getHeight(null) - btnH), (int)bg.getWidth(null), (int)btnH);
            res.put("button", tmp);
            log.info((Object)("\u0420\u0430\u0437\u043c\u0435\u0440 button: " + tmp.getWidth(null) + "x" + tmp.getHeight(null)));
            tmp = ImageUtil.cropImage((Image)bg, (int)0, (int)hdrH, (int)bg.getWidth(null), (int)(bg.getHeight(null) - btnH - hdrH));
            res.put("content", tmp);
            log.info((Object)("\u0420\u0430\u0437\u043c\u0435\u0440 content: " + tmp.getWidth(null) + "x" + tmp.getHeight(null)));
            Date d2 = new Date();
            log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u0430\u0440\u0442\u0438\u043d\u043e\u043a: " + (d2.getTime() - d1.getTime()) + " \u043cc"));
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        return res;
    }

    public Icon getOperatorButtonImage(String name) {
        if (name == null || name.isEmpty()) {
            return this.operatorUpIcon;
        }
        ImageIcon icon = (ImageIcon)this.operatorButtonIcons.get(name);
        if (icon != null) {
            return icon;
        }
        Image logo = this.getImage(imageServicePath + name);
        if (logo == null) {
            return null;
        }
        Image img = ImageUtil.mixImage((Image)this.operatorUp, (Image)logo, (float)1.0f);
        if (img == null) {
            return null;
        }
        icon = new ImageIcon(img);
        this.operatorButtonIcons.put(name, icon);
        return icon;
    }

    public Icon getOperatorButtonPressImage(String name) {
        if (name == null || name.isEmpty()) {
            return this.operatorDownIcon;
        }
        ImageIcon icon = (ImageIcon)this.operatorButtonIconsPress.get(name);
        if (icon != null) {
            return icon;
        }
        Image logo = this.getImage(imageServicePath + name);
        if (logo == null) {
            return null;
        }
        Image img = ImageUtil.mixImage((Image)this.operatorDown, (Image)logo, (float)0.5f);
        if (img == null) {
            return null;
        }
        icon = new ImageIcon(img);
        this.operatorButtonIconsPress.put(name, icon);
        return icon;
    }

    public Icon getGroupButtonImage(String name) {
        if (name == null) {
            return this.groupUpIcon;
        }
        ImageIcon icon = (ImageIcon)this.groupButtonIcons.get(name);
        if (icon != null) {
            return icon;
        }
        Image logo = this.getImage(imageGroupPath + name);
        if (logo == null) {
            return null;
        }
        icon = new ImageIcon(ImageUtil.mixImage((Image)this.groupUp, (Image)logo, (int)Scaler.x((int)10), (float)1.0f));
        if (icon != null) {
            this.groupButtonIcons.put(name, icon);
        }
        return icon;
    }

    public Icon getGroupButtonPressImage(String name) {
        if (name == null) {
            return this.groupDownIcon;
        }
        ImageIcon icon = (ImageIcon)this.groupButtonIconsPress.get(name);
        if (icon != null) {
            return icon;
        }
        Image logo = this.getImage(imageGroupPath + name);
        if (logo == null) {
            return null;
        }
        icon = new ImageIcon(ImageUtil.mixImage((Image)this.groupDown, (Image)logo, (int)Scaler.x((int)10), (float)0.5f));
        if (icon != null) {
            this.groupButtonIconsPress.put(name, icon);
        }
        return icon;
    }

    public ImageIcon getOperatorUpIcon() {
        return this.operatorUpIcon;
    }

    public ImageIcon getOperatorDownIcon() {
        return this.operatorDownIcon;
    }

    private ImageIcon resizeImageIconBySize(Dimension imageSize, ImageIcon icon) {
        if (imageSize != null && imageSize.height > 0 && imageSize.width > 0) {
            Image image;
            Image newimg = image = icon.getImage();
            int i = 0;
            while ((double)icon.getIconWidth() > imageSize.getWidth() || (double)icon.getIconHeight() > imageSize.getHeight()) {
                log.debug((Object)("resizeImageIconBySize: 0) icon.getIconHeight() = " + icon.getIconHeight() + ": icon.getIconWidth() = " + icon.getIconWidth()));
                image = newimg;
                int imageWidth = (int)imageSize.getWidth() + 1;
                int imageHeight = (int)imageSize.getHeight() + 1;
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                newimg = iconWidth >= imageWidth && (iconHeight <= imageHeight || iconHeight >= imageHeight && iconHeight <= iconWidth) ? image.getScaledInstance(imageSize.width, -1, 4) : (iconHeight >= imageHeight && (iconWidth <= imageWidth || iconWidth >= imageWidth && iconHeight <= iconWidth) ? image.getScaledInstance(-1, imageSize.height, 4) : image.getScaledInstance(imageSize.width, -1, 4));
                icon = new ImageIcon(newimg);
                if (i > 2) {
                    log.debug((Object)"resizeImageIconBySize: break resize, too much approach");
                    return icon;
                }
                ++i;
            }
            log.debug((Object)("resizeImageIconBySize: icon.getIconHeight() = " + icon.getIconHeight() + ": icon.getIconWidth() = " + icon.getIconWidth()));
        }
        return icon;
    }

    public ImageIcon getButtonImageWithSize(String path, String name, String size, Dimension imageSize, boolean pressed) {
        try {
            SoftReference<ImageIcon> iconsr;
            if (name == null || name.isEmpty()) {
                return null;
            }
            if (pressed && this.iconsPressMap != null && this.iconsPressMap.get(name) != null ? (iconsr = this.iconsPressMap.get(name).get(size)) != null && iconsr.get() != null : !pressed && this.iconsMap != null && this.iconsMap.get(name) != null && (iconsr = this.iconsMap.get(name).get(size)) != null && iconsr.get() != null) {
                return this.resizeImageIconBySize(imageSize, iconsr.get());
            }
            int index = name.contains(".png") ? name.indexOf(".png") : (name.contains(".jpg") ? name.indexOf(".jpg") : name.length());
            ImageIcon iconL = null;
            HashMap<String, SoftReference<ImageIcon>> sizeMap = new HashMap<String, SoftReference<ImageIcon>>();
            Image logoL = this.getImage(path + name.substring(0, index) + imagePrefixL + name.substring(index));
            if (logoL != null) {
                iconL = new ImageIcon(logoL);
                sizeMap.put(imagePrefixL, new SoftReference<ImageIcon>(iconL));
            }
            ImageIcon iconS = null;
            Image logoS = this.getImage(path + name.substring(0, index) + imagePrefixS + name.substring(index));
            if (logoS != null) {
                iconS = new ImageIcon(logoS);
                sizeMap.put(imagePrefixS, new SoftReference<ImageIcon>(iconS));
            }
            Image logoM = this.getImage(path + name.substring(0, index) + imagePrefixM + name.substring(index));
            Image logo = this.getImage(path + name);
            if (logo == null && logoM == null && size.equals(imagePrefixM)) {
                return null;
            }
            ImageIcon icon = null;
            if (logo != null) {
                icon = new ImageIcon(logo);
            }
            ImageIcon iconM = null;
            if (logoM != null) {
                iconM = new ImageIcon(logoM);
                sizeMap.put(imagePrefixM, new SoftReference<ImageIcon>(iconM));
            } else if (logo != null) {
                sizeMap.put(imagePrefixM, new SoftReference<ImageIcon>(icon));
            }
            if (pressed) {
                this.iconsPressMap.put(name, sizeMap);
            } else {
                this.iconsMap.put(name, sizeMap);
            }
            if (imagePrefixL.equals(size) && iconL != null) {
                return this.resizeImageIconBySize(imageSize, iconL);
            }
            if (imagePrefixS.equals(size) && iconS != null) {
                return this.resizeImageIconBySize(imageSize, iconS);
            }
            if (imagePrefixM.equals(size) && iconM != null) {
                return this.resizeImageIconBySize(imageSize, iconM);
            }
            if (icon != null) {
                return this.resizeImageIconBySize(imageSize, icon);
            }
            return icon;
        }
        catch (Exception ex) {
            log.warn((Object)"getButtonImageWithSize", (Throwable)ex);
            return null;
        }
    }

    public Icon getMiniGroupButtonImage(String name) {
        if (name == null || name.isEmpty()) {
            return this.operatorUpIcon;
        }
        SoftReference<ImageIcon> iconRef = this.miniGroupButtonIcons.get(name);
        if (iconRef != null && iconRef.get() != null) {
            return iconRef.get();
        }
        Image logo = this.getImage(imageServicePath + name);
        if (logo == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(ImageUtil.mixImage((Image)this.operatorUp, (Image)logo, (int)Scaler.x((int)10), (float)1.0f));
        if (icon != null) {
            this.miniGroupButtonIcons.put(name, new SoftReference<ImageIcon>(icon));
        }
        return icon;
    }

    public Icon getMiniGroupButtonPressImage(String name) {
        if (name == null || name.isEmpty()) {
            return this.operatorDownIcon;
        }
        SoftReference<ImageIcon> iconRef = this.miniGroupButtonIconsPress.get(name);
        if (iconRef != null && iconRef.get() != null) {
            return iconRef.get();
        }
        Image logo = this.getImage(imageServicePath + name);
        if (logo == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(ImageUtil.mixImage((Image)this.operatorDown, (Image)logo, (int)Scaler.x((int)10), (float)0.5f));
        if (icon != null) {
            this.miniGroupButtonIconsPress.put(name, new SoftReference<ImageIcon>(icon));
        }
        return icon;
    }

    public Icon getOperatorIcon(String name) {
        SoftReference<Icon> iconRef = this.operatorIcon.get(name);
        if (iconRef != null && iconRef.get() != null) {
            return iconRef.get();
        }
        Image img = this.getImage(imageServicePath + name);
        if (img == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(img);
        this.operatorIcon.put(name, new SoftReference<ImageIcon>(icon));
        return icon;
    }
}

