/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.fs.client;

import java.io.IOException;
import java.util.LinkedHashMap;
import ru.softlogic.fs.client.FiscalClient;
import ru.softlogic.fs.client.RestClient;
import ru.softlogic.fs.client.model.Response;
import ru.softlogic.fs.client.model.dayreport.DayReportResponse;
import ru.softlogic.fs.client.model.dayreport.DayReportUnprintedResponse;
import ru.softlogic.fs.client.model.params.AuthParams;
import ru.softlogic.fs.client.model.params.PaylogicParams;
import ru.softlogic.fs.client.model.payment.FiscalRequest;
import ru.softlogic.fs.client.model.payment.PaymentRequest;
import ru.softlogic.fs.client.model.payment.PaymentResponse;
import ru.softlogic.fs.client.model.producers.AuthParamsProducer;
import ru.softlogic.fs.client.model.producers.PaylogicParamsProducer;

public class HttpFiscalClient
implements FiscalClient {
    private final AuthParamsProducer authParamsProducer;
    private PaylogicParamsProducer paylogicParamsProducer;
    private final RestClient restClient;

    public HttpFiscalClient(AuthParamsProducer authParamsProducer) throws IOException {
        if (authParamsProducer == null) {
            throw new NullPointerException("Authorization parameters producer is null");
        }
        this.authParamsProducer = authParamsProducer;
        this.restClient = new RestClient();
    }

    public HttpFiscalClient(AuthParamsProducer authParamsProducer, PaylogicParamsProducer paylogicParamsProducer) throws IOException {
        this(authParamsProducer);
        if (paylogicParamsProducer == null) {
            throw new NullPointerException("Paylogic parameters producer is null");
        }
        this.paylogicParamsProducer = paylogicParamsProducer;
    }

    @Override
    public Response devicesAvailable() throws IOException {
        this.validateAuthParams(this.authParamsProducer.getParams());
        return this.restClient.getEntity(Response.class, this.authParamsProducer.getParams().getUrl(), "/devices/is-available", this.authParamsProducer.getParams().getId(), this.authParamsProducer.getParams().getApiKey(), null);
    }

    @Override
    public PaymentResponse pcPay(PaymentRequest paymentRequest) throws IOException {
        this.validateAuthParams(this.authParamsProducer.getParams());
        this.validatePaylogicParams(this.paylogicParamsProducer.getParams());
        this.validatePaymentRequest(paymentRequest);
        FiscalRequest fiscalRequest = new FiscalRequest(paymentRequest, this.paylogicParamsProducer.getParams());
        return this.restClient.postEntity(PaymentResponse.class, this.authParamsProducer.getParams().getUrl(), "/fs/payment", this.authParamsProducer.getParams().getId(), this.authParamsProducer.getParams().getApiKey(), null, fiscalRequest);
    }

    @Override
    public DayReportUnprintedResponse getUnprintedDayReports() throws IOException {
        this.validateAuthParams(this.authParamsProducer.getParams());
        return this.restClient.getEntity(DayReportUnprintedResponse.class, this.authParamsProducer.getParams().getUrl(), "/day-report/unprinted", this.authParamsProducer.getParams().getId(), this.authParamsProducer.getParams().getApiKey(), null);
    }

    @Override
    public DayReportResponse getDayReportData(int reportId) throws IOException {
        this.validateAuthParams(this.authParamsProducer.getParams());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("report_id", Integer.toString(reportId));
        return this.restClient.getEntity(DayReportResponse.class, this.authParamsProducer.getParams().getUrl(), "/day-report/data", this.authParamsProducer.getParams().getId(), this.authParamsProducer.getParams().getApiKey(), params);
    }

    @Override
    public Response setDayReportPrinted(int reportId) throws IOException {
        this.validateAuthParams(this.authParamsProducer.getParams());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("report_id", Integer.toString(reportId));
        return this.restClient.putEntity(Response.class, this.authParamsProducer.getParams().getUrl(), "/day-report/set-printed", this.authParamsProducer.getParams().getId(), this.authParamsProducer.getParams().getApiKey(), params, null);
    }

    private void validateAuthParams(AuthParams authParams) {
        if (authParams == null) {
            throw new NullPointerException("Authorization parameters is null");
        }
        if (authParams.getUrl() == null || authParams.getUrl().isEmpty()) {
            throw new IllegalArgumentException("Url parameter is null or empty");
        }
        if (authParams.getApiKey() == null || authParams.getApiKey().isEmpty()) {
            throw new IllegalArgumentException("Api_key parameter is null or empty");
        }
        if (authParams.getId() < 1) {
            throw new IllegalArgumentException("Id less one");
        }
    }

    private void validatePaylogicParams(PaylogicParams paylogicParams) {
        if (paylogicParams.getServer() == null || paylogicParams.getServer().isEmpty()) {
            throw new IllegalArgumentException("Server is null or empty");
        }
        if (paylogicParams.getAgentId() < 1) {
            throw new IllegalArgumentException("Agent_id less one");
        }
        if (paylogicParams.getPointNum() < 1) {
            throw new IllegalArgumentException("Point_num less one");
        }
    }

    private void validatePaymentRequest(PaymentRequest paymentRequest) {
        if (paymentRequest == null) {
            throw new NullPointerException("PaymentRequest");
        }
        if (paymentRequest.getAccount() == null || paymentRequest.getAccount().isEmpty()) {
            throw new IllegalArgumentException("Account is null or empty");
        }
        if (paymentRequest.getServiceName() == null || paymentRequest.getServiceName().isEmpty()) {
            throw new IllegalArgumentException("Service_name is null or empty");
        }
        if (paymentRequest.getSumIn() <= 0) {
            throw new IllegalArgumentException("Sum_in must be greater than 0");
        }
        if (paymentRequest.getSumOut() <= 0) {
            throw new IllegalArgumentException("Sum_out must be greater than 0");
        }
        if (paymentRequest.getSumComm() < 0) {
            throw new IllegalArgumentException("Sum_comm must be at least 0");
        }
        if (paymentRequest.getSumChange() < 0) {
            throw new IllegalArgumentException("Sum_change must be at least 0");
        }
        int sumInCalculated = paymentRequest.getSumOut() + paymentRequest.getSumComm() + paymentRequest.getSumChange();
        if (paymentRequest.getSumIn() != sumInCalculated) {
            throw new IllegalArgumentException("Sum_in is not equal to the sum (out + comm + change)");
        }
    }
}

