/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.util.logger;

import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class MaskedPatternLayout
extends EnhancedPatternLayout
implements Serializable {
    private String mask;
    private String[] masks;
    private String replace;
    private String[] replaces;

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
        if (mask != null) {
            this.masks = mask.split("\n");
        }
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
        if (replace != null) {
            this.replaces = replace.split("\n");
        }
    }

    public String format(LoggingEvent event) {
        return super.format((LoggingEvent)new MaskedLoggingEvent(event));
    }

    private class MaskedLoggingEvent
    extends LoggingEvent {
        public MaskedLoggingEvent(LoggingEvent event) {
            this(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), event.getLevel(), event.getMessage(), event.getThreadName(), event.getThrowableInformation(), event.getNDC(), event.getLocationInformation(), event.getProperties());
        }

        public MaskedLoggingEvent(String fqnOfCategoryClass, Category logger, Priority level, Object message, Throwable throwable) {
            super(fqnOfCategoryClass, logger, level, message, throwable);
        }

        public MaskedLoggingEvent(String fqnOfCategoryClass, Category logger, long timeStamp, Priority level, Object message, Throwable throwable) {
            super(fqnOfCategoryClass, logger, timeStamp, level, message, throwable);
        }

        public MaskedLoggingEvent(String fqnOfCategoryClass, Category logger, long timeStamp, Level level, Object message, String threadName, ThrowableInformation throwable, String ndc, LocationInfo info, Map properties) {
            super(fqnOfCategoryClass, logger, timeStamp, level, message, threadName, throwable, ndc, info, properties);
        }

        public String getRenderedMessage() {
            String res = super.getRenderedMessage();
            if (res != null && MaskedPatternLayout.this.masks != null && MaskedPatternLayout.this.replaces != null && MaskedPatternLayout.this.masks.length == MaskedPatternLayout.this.replaces.length) {
                for (int i = 0; i < MaskedPatternLayout.this.masks.length; ++i) {
                    res = res.replaceAll(MaskedPatternLayout.this.masks[i], MaskedPatternLayout.this.replaces[i]);
                }
            }
            return res;
        }
    }
}

