/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.fraud;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import ru.softlogic.application.QueueAgentListener;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.system.util.ThreadUtil;
import ru.softlogic.system.util.fraud.FraudQueue;

public class FraudQueueAgent
implements Runnable {
    private FraudQueue queue;
    private ClientInterface clientInterface;
    private Logger log;
    private LinkedHashSet<QueueAgentListener> agentListeners;

    public FraudQueueAgent(FraudQueue queue, ClientInterface clientInterface) {
        if (queue == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 FraudQueue");
        }
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ClientInterface");
        }
        this.queue = queue;
        this.clientInterface = clientInterface;
        this.agentListeners = new LinkedHashSet();
        this.log = Logger.getLogger((String)"net");
        this.log.setAdditivity(false);
    }

    public void addAgentListener(QueueAgentListener listener) {
        if (listener != null) {
            this.agentListeners.add(listener);
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"Start FraudQueueAgent thread ");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.processInfo();
                this.process();
                this.processGroup();
                this.processMoneyCollections();
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable ex) {
                this.log.error((Object)ex, ex);
                ThreadUtil.sleep((long)10000L);
            }
        }
        this.queue.close();
        this.log.info((Object)"Stop thread");
    }

    private void processInfo() {
        try {
            Operation[] operations = (Operation[])ArrayUtils.addAll((Object[])this.queue.getOperations(), (Object[])this.clientInterface.getQueue().getOperations());
            GroupOperation[] groupOperations = (GroupOperation[])ArrayUtils.addAll((Object[])this.queue.getGroupOperations(), (Object[])this.clientInterface.getQueue().getGroupOperations());
            MoneyCollection[] moneyCollections = (MoneyCollection[])ArrayUtils.addAll((Object[])this.queue.getMoneyCollections(), (Object[])this.clientInterface.getQueue().getMoneyCollections());
            for (QueueAgentListener qal : this.agentListeners) {
                qal.onPaymentsInfo(operations, groupOperations, moneyCollections);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    private void process() throws ConnectorException {
        Operation[] operations = this.queue.getOperations();
        if (operations != null && operations.length > 0) {
            int errors = CashManager.getDefaultInstance().getFraudOfflineErrorCount();
            if (errors > 0) {
                this.log.info((Object)("\u041e\u0448\u0438\u0431\u043e\u043a \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 " + errors + ", \u0441\u0442\u0430\u0432\u043b\u044e \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0443 fraud"));
                for (Operation op : operations) {
                    op.setFlags(op.getFlags() | 0x40);
                    this.clientInterface.process(op);
                }
                this.queue.deleteOperations(operations);
            } else {
                LinkedList<Operation> opers = new LinkedList<Operation>();
                for (Operation op : operations) {
                    if (op.getFraudControlRule() != null && System.currentTimeMillis() <= op.getDate().getTime() + (long)(op.getFraudControlRule().getSendTimeout() * 1000)) continue;
                    opers.add(op);
                    this.clientInterface.process(op);
                }
                this.queue.deleteOperations(opers.toArray(new Operation[opers.size()]));
            }
        }
    }

    private void processGroup() throws ConnectorException {
        GroupOperation[] operations = this.queue.getGroupOperations();
        if (operations != null && operations.length > 0) {
            int errors = CashManager.getDefaultInstance().getFraudOfflineErrorCount();
            if (errors > 0) {
                this.log.info((Object)("\u041e\u0448\u0438\u0431\u043e\u043a \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 " + errors + ", \u0441\u0442\u0430\u0432\u043b\u044e \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0443 fraud"));
                for (GroupOperation gp : operations) {
                    gp.setFlags(gp.getFlags() | 0x40);
                    this.clientInterface.process((Operation)gp);
                }
                this.queue.deleteGroupOperations(operations);
            } else {
                LinkedList<GroupOperation> opers = new LinkedList<GroupOperation>();
                for (GroupOperation op : operations) {
                    if (op.getFraudControlRule() != null && System.currentTimeMillis() <= op.getDate().getTime() + (long)(op.getFraudControlRule().getSendTimeout() * 1000)) continue;
                    opers.add(op);
                    this.clientInterface.process((Operation)op);
                }
                this.queue.deleteGroupOperations(opers.toArray(new GroupOperation[opers.size()]));
            }
        }
    }

    private void processMoneyCollections() throws ConnectorException {
        Operation[] ops = this.queue.getOperations();
        GroupOperation[] gops = this.queue.getGroupOperations();
        if (!(ops != null && ops.length != 0 || gops != null && gops.length != 0)) {
            MoneyCollection[] moneyCollections = this.queue.getMoneyCollections();
            if (moneyCollections != null && moneyCollections.length > 0) {
                for (MoneyCollection mc : moneyCollections) {
                    this.clientInterface.sendMoneyCollection(mc);
                }
            }
            this.queue.deleteMoneyCollections(moneyCollections);
        }
    }
}

