/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import org.apache.log4j.Logger;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.EventNotifier;

public class EventNotifierImpl
extends EventNotifier {
    private final Logger log;
    private ClientInterface server;

    public EventNotifierImpl(ClientInterface server, Logger log) {
        if (server == null) {
            throw new NullPointerException("ClientInterface is not set");
        }
        if (log == null) {
            throw new NullPointerException("Log is not set");
        }
        this.server = server;
        this.log = log;
    }

    @Override
    public void onError(Throwable ex) {
        this.log.error((Object)ex, ex);
        this.server.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
    }

    @Override
    public void onError(String message) {
        this.log.error((Object)message);
        this.server.sendEvent(new Event(EventType.SoftwareFault, message));
    }

    @Override
    public void onProblem(String message) {
        this.log.warn((Object)message);
        this.server.sendEvent(new Event(EventType.Warning, message));
    }

    @Override
    protected void onRequestRestart(String cause) {
        this.log.error((Object)("Software fault, needs restart. Cause: " + cause));
        this.server.sendEvent(new Event(EventType.SoftwareFault, "Reboot requested: " + cause));
        SafeReboot.getInstance().restart(cause);
    }
}

