/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.system.util.PathUtils;

public class AppUtils {
    public static List<File> getDumps() {
        HashSet<File> paths = new HashSet<File>();
        paths.add(new File(PathUtils.getAppHome()));
        paths.add(new File(SystemProp.getUserHome()));
        paths.add(new File(SystemProp.getUserDir()));
        LinkedList<File> res = new LinkedList<File>();
        for (File path : paths) {
            res.addAll(AppUtils.getFiles(path));
        }
        Collections.sort(res, new Sorter());
        return res;
    }

    private static List<File> getFiles(File path) {
        Logger.getLogger((String)"app").debug((Object)("AppUtils.getFiles: " + path));
        File[] files = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getAbsolutePath().matches(".*hs_err_pid\\d{1,5}\\.log");
            }
        });
        return Arrays.asList(files);
    }

    private static class Sorter
    implements Comparator<File> {
        private Sorter() {
        }

        @Override
        public int compare(File o1, File o2) {
            return Long.valueOf(o1.lastModified()).compareTo(o2.lastModified());
        }
    }
}

