/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.reinit.redirect;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.reinit.redirect.Clear;
import ru.softlogic.module.reinit.redirect.Modify;
import ru.softlogic.module.reinit.redirect.Rule;
import ru.softlogic.parser.ParseException;

public class RulesParser {
    public static List<Rule> getRules(File file, String fromId, String toId) throws ParseException {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(file);
            List list = document.selectNodes("//rule[@from='" + fromId + "'][@to='" + toId + "' ]");
            if (list == null || list.isEmpty()) {
                list = document.selectNodes("//rule[@from='" + fromId + "']");
            }
            if (list == null || list.isEmpty()) {
                list = document.selectNodes("//rule-default");
            }
            if (list != null && list.size() == 1) {
                Element element = (Element)list.get(0);
                List childs = element.elements();
                if (childs == null || childs.isEmpty()) {
                    throw new ParseException("Rule has no elements");
                }
                LinkedList<Rule> rules = new LinkedList<Rule>();
                for (Element e : childs) {
                    if ("clear".equals(e.getName())) {
                        rules.add(RulesParser.getClear(e));
                        continue;
                    }
                    if (!"modify".equals(e.getName())) continue;
                    rules.add(RulesParser.getModify(e));
                }
                return rules;
            }
            if (list == null || list.isEmpty()) {
                throw new ParseException("Rule not found");
            }
            throw new ParseException("Too many Rules found. Count=" + list.size());
        }
        catch (DocumentException ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    private static Rule getClear(Element e) {
        Clear clear = new Clear();
        clear.setRegex(e.valueOf("regex"));
        return clear;
    }

    private static Rule getModify(Element e) {
        Modify modify = new Modify();
        modify.setSrcKey(e.attributeValue("src-key"));
        InputElement ie = new InputElement();
        ie.setKey(e.attributeValue("t-key"));
        ie.setKeyTitle(e.attributeValue("t-key-title"));
        ie.setOriginalValue(e.attributeValue("t-original-value"));
        ie.setValue(e.attributeValue("t-value"));
        ie.setValueTitle(e.attributeValue("t-value-title"));
        modify.setTarget(ie);
        ie = new InputElement();
        ie.setKey(e.attributeValue("v-key"));
        ie.setKeyTitle(e.attributeValue("v-key-title"));
        ie.setOriginalValue(e.attributeValue("v-original-value"));
        ie.setValue(e.attributeValue("v-value"));
        ie.setValueTitle(e.attributeValue("v-value-title"));
        modify.setValue(ie);
        return modify;
    }
}

