/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing;

import i18n.B;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.processing.PU;
import ru.softlogic.module.processing.ProcessingModule;
import ru.softlogic.parser.ParseException;

public abstract class BaseProcessingModule
implements ProcessingModule {
    protected final Logger log = LoggerId.PAY;
    protected ApplicationContext context;
    private CommonScreen smsScreen;
    private LocalScreenListener smsListener;
    private int timeout;
    private Environment env;

    public BaseProcessingModule(ApplicationContext context) {
        this.context = context;
        this.timeout = -1;
        this.smsListener = new LocalScreenListener();
        try {
            this.smsScreen = CommonScreenStore.getScreen((String)"digital");
        }
        catch (Exception ex) {
            this.log.warn((Object)("BaseProcessingModule screen create exception -> " + ex.getMessage()));
        }
    }

    @Override
    public final void process(Environment environment) {
        this.log.info((Object)B.get((String)"Module.processing", (Locale)environment.getLocale()));
        this.context.setModule(this);
        this.timeout = -1;
        this.env = environment;
        if (this.smsScreen != null && PU.isNeedSmsPhone(environment)) {
            try {
                this.smsScreen.setListener((ScreenListener)this.smsListener);
                PU.showScreen(this.smsScreen, PU.createSmsSD(this.env), this.env, this.context);
                this.timeout = 60;
            }
            catch (ParseException ex) {
                this.timeout = -1;
                this.log.warn((Object)("BaseProcessingModule parse exception -> " + ex.getMessage()));
                this._process(this.env);
            }
        } else {
            this._process(this.env);
        }
    }

    protected abstract void _process(Environment var1);

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public int getInactivityTimeout() {
        return this.timeout;
    }

    @Override
    public void cancel(Intent intent) {
        ModuleHelper.releaseDevices();
        if (this.timeout > 0) {
            this.timeout = -1;
            this._process(this.env);
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                String ssp = BaseProcessingModule.this.env.getMenuItem().getService().getSuccessSmsPhone();
                InputElement ie = (InputElement)data.get(ssp);
                BaseProcessingModule.this.log.info((Object)ie);
                if (ie != null && ie.getOriginalValue() != null && !ie.getOriginalValue().isEmpty()) {
                    ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData().put(ssp, ie);
                }
            }
            BaseProcessingModule.this._process(BaseProcessingModule.this.env);
        }
    }
}

