/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing;

import i18n.B;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdwbridge.HardwareException;
import ru.softlogic.hdwbridge.sc.CardOperation;
import ru.softlogic.hdwbridge.sc.SmartCardProcessor;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.advanced.CardProcessorStore;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class AzersuCardProcessingModule
extends ObsoleteProcessingModule {
    protected final CardReader crd = CardProcessorStore.getInstance().getCardReader();
    private boolean printOnlineOp;
    private Operation printOperation;

    public AzersuCardProcessingModule(ApplicationContext context) {
        super(context);
    }

    protected Task createProcessTask(Sum out) {
        return new ProcessTask(out);
    }

    @Override
    protected void _process(Environment environment) {
        this.environment = environment;
        this.printOnlineOp = false;
        this.printOperation = null;
        try {
            Sum out;
            Pack pack = Session.getInstance().getPack();
            SumResult sumResult = Session.getInstance().getPack().getSumResult();
            if (sumResult != null && !pack.isCancel() && pack.getPaymentType() == 0 && (out = sumResult.getOut()) != null && !out.isEmpty()) {
                log.info((Object)"Run smartcard payment processing");
                this.context.getTaskExecutor().execute(this.createProcessTask(out));
                return;
            }
            log.info((Object)"Run no smartcard payment processing");
            super._process(this.environment);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            ProblemNotifier.notifyProblem((String)("Error in smartcard payment processing: " + e.getMessage()));
            ModuleHelper.cancelPack(Session.getInstance().getPack());
            super._process(this.environment);
        }
    }

    protected void realProcess(Environment env) {
        Pack pack = Session.getInstance().getPack();
        SumResult sumResult = pack.getSumResult();
        sumResult.setChange(new Sum());
        sumResult.setCommission(new Sum());
        sumResult.setOut(new Sum());
        sumResult.setOutProv(new Sum());
        if (pack.getPayments() != null) {
            for (Payment p : pack.getPayments()) {
                p.setSumOut(new Sum());
            }
        }
        pack.setSumResult(sumResult);
        pack.setZeroAmount(true);
        super._process(env);
    }

    @Override
    protected void endProcess() {
        if (this.printOnlineOp) {
            this.environment.setPrintOperation(this.printOperation);
        }
        super.endProcess();
    }

    protected class ProcessTask
    implements Task {
        protected final String ATTR_RECEIPT = "receipt";
        protected final String ATTR_DATA_TO_CARD = "data-to-card";
        protected final String ATTR_CARD_UPDATED = "card-updated";
        protected static final int STATUS_OK = 0;
        protected static final int ERROR_PAY_REQUEST = 1;
        protected static final int ERROR_PAY_DATA = 2;
        protected static final int ERROR_WRITE_TO_CARD = 3;
        protected final Sum amount;

        protected ProcessTask(Sum amount) {
            this.amount = amount;
        }

        @Override
        public Object execute() {
            try {
                InputElement ieDataToCard;
                InputElement ieReceipt;
                Operation operation;
                Map data;
                block12: {
                    ObsoleteProcessingModule.log.debug((Object)"Get payment data");
                    Pack pack = Session.getInstance().getPack();
                    data = ((Payment)pack.getPayments().get(0)).getData();
                    ObsoleteProcessingModule.log.debug((Object)("data: " + data));
                    operation = this.createOperation(pack, new Date(), this.amount);
                    ieReceipt = null;
                    ieDataToCard = null;
                    try {
                        ObsoleteProcessingModule.log.info((Object)"Run online payment processing");
                        Session.getInstance().setOnlinePaymentStart(true);
                        Session.getInstance().flush();
                        ObsoleteProcessingModule.log.info((Object)"Process request");
                        final ProcessingResult pr = AzersuCardProcessingModule.this.context.getServerConnector().process(operation);
                        ObsoleteProcessingModule.log.info((Object)("Processing result: " + pr));
                        if (pr.getType() == ProcessingResultType.Ok) {
                            Session.getInstance().setOnlinePaymentStart(false);
                            if (pr.getDataItems() != null) {
                                for (DataItem di : pr.getDataItems()) {
                                    if (ieReceipt == null && "receipt".equals(di.getKey())) {
                                        ieReceipt = new InputElement("receipt", "receipt", di.getValue());
                                    }
                                    if (ieDataToCard == null && "data-to-card".equals(di.getKey())) {
                                        ieDataToCard = new InputElement("data-to-card", "data-to-card", di.getValue());
                                        continue;
                                    }
                                    data.put(di.getKey(), new InputElement(di.getKey(), di.getKey(), di.getValue()));
                                }
                            }
                            break block12;
                        }
                        ObsoleteProcessingModule.log.info((Object)"Ask about action");
                        if (Session.getInstance().getPack().getCashlessData() != null) {
                            ObsoleteProcessingModule.log.info((Object)"It's card payment, cant to back");
                            this.fullPayout(pr.getErrorText());
                        } else {
                            String errorText = pr.getErrorText();
                            String msg = errorText != null && !errorText.trim().isEmpty() ? MessageFormat.format(B.get((String)"Module.processing.online.error.action.text", (Locale)AzersuCardProcessingModule.this.environment.getLocale()), errorText) : B.get((String)"Module.processing.online.error.action", (Locale)AzersuCardProcessingModule.this.environment.getLocale());
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, msg, 20, DC.cases((int)17, (Locale)AzersuCardProcessingModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    ObsoleteProcessingModule.log.info((Object)("User make choise " + userCase));
                                    if (userCase == UserCase.Ok) {
                                        ObsoleteProcessingModule.log.info((Object)"Go to input module");
                                        AzersuCardProcessingModule.this.environment.getInputModule().restore();
                                    } else {
                                        ProcessTask.this.fullPayout(pr.getErrorText());
                                    }
                                }
                            });
                            dialog.show(AzersuCardProcessingModule.this.context.getShell());
                        }
                        return 1;
                    }
                    catch (ConnectorException ex) {
                        ObsoleteProcessingModule.log.error((Object)ex, (Throwable)ex);
                        AzersuCardProcessingModule.this.processingFinished(null, operation);
                        return 1;
                    }
                }
                return this.postExecute(ieDataToCard, ieReceipt, operation, data);
            }
            catch (HardwareException ex) {
                return 3;
            }
            catch (Exception ex) {
                return ex;
            }
        }

        protected Object postExecute(InputElement ieDataToCard, InputElement ieReceipt, Operation operation, Map<String, Object> data) throws HardwareException {
            if (ieDataToCard == null || ieReceipt == null) {
                return 2;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(ieDataToCard.getKey(), ieDataToCard.getValue());
            CardProcessorStore cpStore = CardProcessorStore.getInstance();
            SmartCardProcessor processor = cpStore.getProcessor();
            processor.process(AzersuCardProcessingModule.this.crd, new CardOperation(this.amount.getBasicSum(), params));
            AzersuCardProcessingModule.this.printOperation = operation;
            AzersuCardProcessingModule.this.printOnlineOp = true;
            return 0;
        }

        @Override
        public void onResult(Object object) {
            ObsoleteProcessingModule.log.info((Object)("Processing result: " + object));
            if (object instanceof Integer) {
                int errorCode = (Integer)object;
                switch (errorCode) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        InputElement ie = new InputElement("card-updated", "card-updated", "true");
                        Pack pack = Session.getInstance().getPack();
                        Map data = ((Payment)pack.getPayments().get(0)).getData();
                        data.put(ie.getKey(), ie);
                    }
                    case 2: 
                    case 3: {
                        AzersuCardProcessingModule.this.realProcess(AzersuCardProcessingModule.this.environment);
                    }
                }
            } else {
                if (object instanceof Throwable) {
                    ObsoleteProcessingModule.log.error((Object)((Throwable)object));
                }
                ModuleHelper.cancelPack(Session.getInstance().getPack());
                AzersuCardProcessingModule.this.realProcess(AzersuCardProcessingModule.this.environment);
            }
            this.cardReaderRelease();
        }

        @Override
        public String getMessage() {
            int id = Session.getInstance().getPack().getService().getId();
            String defaultValue = B.get((String)"Request.process.wait", (Locale)AzersuCardProcessingModule.this.environment.getLocale());
            return B.get((String)("Request.process.wait." + id), (Locale)AzersuCardProcessingModule.this.environment.getLocale(), (String)defaultValue);
        }

        protected Operation createOperation(Pack pack, Date operationDate, Sum sum) {
            InputElement ie;
            Object smsAgreeKeyObj;
            ProcessingType processingType;
            Random random = new Random();
            Payment payment = (Payment)pack.getPayments().get(0);
            int id = SequenceManager.getValueQuietly((String)"operation-id");
            payment.setId(id % 32000);
            if (AppDefaults.getInstance().getBooleanProperty("Module.processing.change.old-check", false)) {
                Operation lp = Session.getInstance().getLastPayment();
                if (pack.getKeeper().getCashSum().isEmpty() && lp != null) {
                    payment.setDoc(lp.getCheckNumber());
                } else {
                    payment.setDoc(random.nextInt(32000));
                }
            } else {
                payment.setDoc(random.nextInt(32000));
            }
            payment.setDate(new Date());
            Operation operation = new Operation();
            operation.setFeHash(PaymentHelper.getFeHash());
            operation.setService(pack.getService());
            operation.setCommission(pack.getCommission());
            operation.setIdOperation(payment.getId());
            operation.setCheckNumber(payment.getDoc());
            operation.setDate(payment.getDate());
            operation.setDealer(AzersuCardProcessingModule.this.environment.getDealer());
            operation.setPoint(AzersuCardProcessingModule.this.environment.getPoint());
            operation.setPaymentSystem(AzersuCardProcessingModule.this.environment.getPaymentSystem());
            operation.setServiceType(AzersuCardProcessingModule.this.environment.getServiceType());
            operation.setPaymentTool(pack.getPaymentTool());
            operation.setCashlessData(pack.getCashlessData());
            operation.setPaybackType(pack.getPaybackType());
            operation.setChangeDispenseError(pack.isChangeDispenseError());
            operation.setFraudControlRule(pack.getFraudControlRule());
            if (pack.getCbc() != null) {
                operation.setPinCode(pack.getCbc().getPincode());
                operation.setPinCodeNominal(pack.getCbc().getNominal());
            }
            operation.setLocale(AzersuCardProcessingModule.this.environment.getLocale());
            for (InputElement ie2 : StoreHelper.clear((Map)payment.getData()).values()) {
                operation.getForm().put(ie2.getKey(), ie2.getValue());
                operation.getViews().put(ie2.getKey(), ie2.getValueTitle());
                operation.getTitles().put(ie2.getKey(), ie2.getKeyTitle());
                operation.getInputElements().put(ie2.getKey(), ie2);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            operation.getInputElements().put("amount", new InputElement("amount", "amount", "" + (float)sum.getBasicSum() / 100.0f));
            operation.getInputElements().put("payment-date", new InputElement("payment-date", "payment-date", dateFormat.format(operationDate)));
            operation.getInputElements().put("payment-time", new InputElement("payment-time", "payment-time", timeFormat.format(operationDate)));
            if (pack.isZeroAmount()) {
                Sum s0 = new Sum();
                SumResult voidSumResult = new SumResult(s0, s0, s0, s0, s0, s0, null, null);
                operation.setSumResult(voidSumResult);
                operation.setKeeper(new Keeper());
                pack.setSumResult(voidSumResult);
            } else {
                SumResult sr = pack.getSumResult();
                SumResult sumResult = new SumResult(sr.getCash(), sr.getCashLess(), payment.getSumOut(), sr.getOutProv(), sr.getCommission(), sr.getChange(), sr.getProviderFee(), null);
                operation.setSumResult(sumResult);
                operation.setKeeper(pack.getKeeper());
            }
            int flags = 0;
            if (AzersuCardProcessingModule.this.environment.isPrinterError()) {
                flags |= 1;
                if (pack.getService().getPaperRequire() == 4) {
                    flags |= 0x200;
                }
            }
            if (pack.getService().getPaperRequire() == 3) {
                flags |= 0x200;
            }
            if (pack.getService().isFiscalService()) {
                flags |= 0x20;
            }
            if ((processingType = pack.getService().getProcessingType()) == ProcessingType.Online || processingType == ProcessingType.HalfOnline) {
                flags |= 0x10;
            }
            if (pack.isFraud()) {
                flags |= 0x40;
            }
            if (pack.isZeroAmount()) {
                flags |= 0x400;
            }
            if (pack.isFixedSum()) {
                flags |= 0x800;
            }
            if (pack.isPersonalComm()) {
                flags |= 0x4000;
            }
            if ((smsAgreeKeyObj = payment.getData().get("sms-agree")) instanceof InputElement && "1".equals((ie = (InputElement)smsAgreeKeyObj).getValue())) {
                flags |= 0x80;
            }
            operation.setChange(pack.getChange());
            SumResult sumRes = operation.getSumResult();
            if (sumRes.getOut().isEmpty() && pack.getPaybackType() == 5) {
                flags |= 0x100;
                ObsoleteProcessingModule.log.info((Object)"Set payment to safe change service");
                operation.setSumResult(new SumResult(sumRes.getCash(), sumRes.getCashLess(), sumRes.getChange(), new Sum(), new Sum(), new Sum(), null, null));
                operation.setCommission(new Commission(1));
                operation.setChange(new Keeper());
                pack.setSumResult(new SumResult(sumRes.getCash(), sumRes.getCashLess(), sumRes.getChange(), new Sum(), new Sum(), new Sum(), null, null));
            }
            if (!operation.getKeeper().getVirtualSum().isEmpty() && Session.getInstance().getChangeDate() != null) {
                operation.setChangeDate(Session.getInstance().getChangeDate());
            }
            operation.setFlags(flags);
            return operation;
        }

        protected void cardReaderRelease() {
            try {
                AzersuCardProcessingModule.this.crd.ejectCard();
                if (AzersuCardProcessingModule.this.crd.isEnabled()) {
                    AzersuCardProcessingModule.this.crd.disableDevice();
                }
                AzersuCardProcessingModule.this.crd.release();
            }
            catch (CardReaderException ex) {
                ObsoleteProcessingModule.log.error((Object)("Card was not eject. Reason: " + ex.getMessage()));
            }
        }

        private void fullPayout(String errorText) {
            ObsoleteProcessingModule.log.info((Object)"Make full payout");
            SumResult sr = Session.getInstance().getPack().getSumResult();
            Session.getInstance().getPack().setCancel(true);
            sr.setCommission(new Sum());
            sr.setOut(new Sum());
            sr.setOutProv(new Sum());
            sr.setChange(sr.getCash().add(sr.getCashLess()));
            Payment firstPayment = (Payment)Session.getInstance().getPack().getPayments().get(0);
            firstPayment.setSumOut(new Sum());
            if (errorText != null) {
                firstPayment.getData().put("online-error-text", new InputElement("online-error-text", "Error Text", errorText));
            }
            AzersuCardProcessingModule.this.environment.getPayoutModule().startPayout(AzersuCardProcessingModule.this.environment);
        }
    }
}

