/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing;

import java.util.Date;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdwbridge.HardwareException;
import ru.softlogic.hdwbridge.sc.CardOperation;
import ru.softlogic.hdwbridge.sc.SmartCardProcessor;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.module.input.advanced.CardProcessorStore;
import ru.softlogic.module.processing.AzersuCardProcessingModule;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.operation.Operation;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;

public class AzerigasCardProcessingModule
extends AzersuCardProcessingModule {
    public AzerigasCardProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected Task createProcessTask(Sum out) {
        return new AzersuCardProcessingModule.ProcessTask(out){

            @Override
            protected Object postExecute(InputElement ieDataToCard, InputElement ieReceipt, Operation operation, Map<String, Object> data) throws HardwareException {
                Map params = StoreHelper.convertDep(data);
                CardProcessorStore cpStore = CardProcessorStore.getInstance();
                SmartCardProcessor processor = cpStore.getProcessor();
                processor.process(AzerigasCardProcessingModule.this.crd, new CardOperation(this.amount.getBasicSum(), params));
                return 0;
            }

            @Override
            public void onResult(Object object) {
                ObsoleteProcessingModule.log.info((Object)("Processing result: " + object));
                if (object instanceof Integer) {
                    int errorCode = (Integer)object;
                    switch (errorCode) {
                        case 1: {
                            break;
                        }
                        case 0: 
                        case 2: 
                        case 3: {
                            Pack pack = Session.getInstance().getPack();
                            AzerigasCardProcessingModule.this.processingFinished(new ProcessingResult(ProcessingResultType.Ok), this.createOperation(pack, new Date(), this.amount));
                        }
                    }
                } else if (object instanceof Throwable) {
                    Throwable ex = (Throwable)object;
                    ObsoleteProcessingModule.log.error((Object)ex, ex);
                    AzerigasCardProcessingModule.this.processingFinished(null, this.createOperation(Session.getInstance().getPack(), new Date(), this.amount));
                }
                this.cardReaderRelease();
            }
        };
    }
}

