/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.present;

import i18n.B;
import java.awt.EventQueue;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.CashBackCard;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.hardware.device.present.Dispenser;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.module.ending.PresentEndingModule;
import ru.softlogic.module.ending.PresentGiftEndingModule;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.module.present.BasePresentModule;
import ru.softlogic.module.present.PresetHelper;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.reference.adv.Bonus;
import ru.softlogic.reference.adv.Promo;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.ws.stub.BonusResult;
import ru.softlogic.statistic.PromoStatistic;
import ru.softlogic.statistic.PromoStatisticStore;
import ru.softlogic.system.util.PinCodeGenerator;

public class MainPresentModule
extends BasePresentModule {
    private Logger log = Logger.getLogger((String)"pay");

    public MainPresentModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _takePresent(Environment environment) {
        if (Session.getInstance().getPack().getPaymentType() == 1 || Session.getInstance().getPack().getSumResult().getOut().isEmpty() || Session.getInstance().getPack().getPaybackType() == 3 || Session.getInstance().getPack().getPaybackType() == 6 || Session.getInstance().getPack().getPaybackType() == 8) {
            if (Session.getInstance().getPack().getSumResult().getOut().isEmpty() || Session.getInstance().getPack().getPaybackType() == 3) {
                this.log.info((Object)"Goto main menu");
                this.context.toMainMenu();
                Logger.getLogger((String)"pay").info((Object)B.get((String)"Module.finish", (Locale)environment.getLocale()));
            } else {
                environment.getCompletiveModule().start(environment);
            }
        } else {
            Thread th = new Thread((Runnable)new LocalRunner(environment), "PresentThread");
            th.start();
        }
    }

    private boolean isUsed(Date date, Promo promo, Sum sum, int sumPrize, String account, int serviceId, int code, int pointId) {
        SecureRandom rand;
        boolean isIn;
        String[] split;
        this.log.info((Object)("Verify prize date = " + date + " promo " + promo + " payment-sum " + sum + " sum-prize " + sumPrize));
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        if (promo.getBegin() == null || promo.getBegin().after(date)) {
            this.log.info((Object)"Cancel by begin promo date");
            return false;
        }
        if (promo.getEnd() != null && promo.getEnd().before(date)) {
            this.log.info((Object)"Cancel by end promo date");
            return false;
        }
        if (promo.getPaymentSum() > sum.getBasicSum()) {
            this.log.info((Object)"Cancel by promo sum");
            return false;
        }
        if (promo.getServices() != null && !promo.getServices().trim().isEmpty()) {
            split = promo.getServices().split(",");
            isIn = false;
            for (String service : split) {
                try {
                    if (Integer.parseInt(service.trim()) != serviceId) continue;
                    isIn = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isIn) {
                this.log.info((Object)"Cancel by promo service");
                return false;
            }
        } else if (promo.getCodes() != null && !promo.getCodes().trim().isEmpty()) {
            split = promo.getCodes().split(",");
            isIn = false;
            for (String c : split) {
                try {
                    if (Integer.parseInt(c.trim()) != code) continue;
                    isIn = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isIn) {
                this.log.info((Object)"Cancel by promo service code");
                return false;
            }
        }
        try {
            if (promo.getTimeBegin() != null && promo.getTimeBegin().after(sdf.parse(sdf.format(date)))) {
                this.log.info((Object)("Cancel begin promo time " + promo.getTimeBegin() + " " + sdf.parse(sdf.format(date))));
                return false;
            }
            if (promo.getTimeEnd() != null && promo.getTimeEnd().before(sdf.parse(sdf.format(date)))) {
                this.log.info((Object)("Cancel by end promo time " + promo.getTimeEnd() + " " + sdf.parse(sdf.format(date))));
                return false;
            }
            if (promo.getDayLimit() > 0) {
                PromoStatistic pst = PromoStatisticStore.getInstance(null).getPromoStatistic();
                if (pst == null || pst.getPeriod() == null) {
                    this.log.info((Object)"Cancel by promo statistic");
                    return false;
                }
                if (!pst.getDateFormatter().format(pst.getPeriod()).equals(pst.getDateFormatter().format(date))) {
                    this.log.info((Object)"Cancel by promo statistic day");
                    return false;
                }
                if (promo.getDayLimitType() == 0) {
                    if ((double)pst.getSumTotal() * ((double)promo.getDayLimit() / 100.0) <= (double)(pst.getSumPrize() + sumPrize)) {
                        this.log.info((Object)"Cancel by promo statistic sum-total");
                        return false;
                    }
                } else if (promo.getDayLimitType() == 1 && (double)pst.getSumComm() * ((double)promo.getDayLimit() / 100.0) <= (double)(pst.getSumPrize() + sumPrize)) {
                    this.log.info((Object)"Cancel by promo statistic commission-total");
                    return false;
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return false;
        }
        if (promo.getClientPaymentNumber() != 0) {
            int paymentsCount = -2;
            try {
                paymentsCount = this.context.getServerConnector().getPaymentsAmount(account, serviceId, Short.valueOf((short)pointId), promo.getId(), promo.getPaymentSum(), date);
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            this.log.info((Object)("payments-count-online  " + paymentsCount));
            if (promo.isClientPaymentCyclic()) {
                if ((paymentsCount + 1) % promo.getClientPaymentNumber() != 0) {
                    this.log.info((Object)"Cancel by user pyments-count cycl");
                    return false;
                }
            } else if (paymentsCount + 1 != promo.getClientPaymentNumber()) {
                this.log.info((Object)"Cancel by user pyments-count eq");
                return false;
            }
        }
        if (promo.getPrizeProbability() != 0 && (rand = new SecureRandom()).nextInt() % 100 > promo.getPrizeProbability()) {
            this.log.info((Object)"Cancel by random");
            return false;
        }
        return true;
    }

    private boolean isUsedBonus(Date date, Bonus bonus, int serviceId, int codeId) {
        String[] split;
        this.log.info((Object)("Verify prize date = " + date + " bonus " + bonus));
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        if (bonus.getBegin() == null || bonus.getBegin().after(date)) {
            this.log.info((Object)"Cancel by begin bonus date");
            return false;
        }
        if (bonus.getEnd() != null && bonus.getEnd().before(date)) {
            this.log.info((Object)"Cancel by end bonus date");
            return false;
        }
        if (bonus.getServices() != null && !bonus.getServices().trim().isEmpty()) {
            split = bonus.getServices().split(",");
            boolean isIn = false;
            for (String service : split) {
                try {
                    int val = Integer.parseInt(service.trim());
                    if (val != serviceId && val != codeId) continue;
                    isIn = true;
                    break;
                }
                catch (Exception val) {
                    // empty catch block
                }
            }
            if (!isIn) {
                this.log.info((Object)"Cancel by bonus service");
                return false;
            }
        } else if (bonus.getCodes() != null && !bonus.getCodes().trim().isEmpty()) {
            split = bonus.getCodes().split(",");
            boolean isIn = false;
            for (String c : split) {
                try {
                    int val = Integer.parseInt(c.trim());
                    if (val != codeId) continue;
                    isIn = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isIn) {
                this.log.info((Object)"Cancel by bonus service code");
                return false;
            }
        }
        try {
            if (bonus.getTimeBegin() != null && bonus.getTimeBegin().after(sdf.parse(sdf.format(date)))) {
                this.log.info((Object)("Cancel begin bonus time " + bonus.getTimeBegin() + " " + sdf.parse(sdf.format(date))));
                return false;
            }
            if (bonus.getTimeEnd() != null && bonus.getTimeEnd().before(sdf.parse(sdf.format(date)))) {
                this.log.info((Object)("Cancel by end bonus time " + bonus.getTimeEnd() + " " + sdf.parse(sdf.format(date))));
                return false;
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean checkPaymentSum(int sumPrize, Environment env) {
        MenuItem mi = env.getMenuItem();
        Service s = Session.getInstance().getPack().getService() == null ? mi.getService() : Session.getInstance().getPack().getService();
        Commission c = Session.getInstance().getPack().getCommission() == null ? mi.getCommission() : Session.getInstance().getPack().getCommission();
        PayDetector detector = new PayDetector(s, c, s.getMinSum(), s.getMaxSum(), null, env.getDateOfStartPayment(), null, mi.isIgnoreMinMaxCommission(), Session.getInstance().getPack().getProviderFee());
        Keeper keeper = new Keeper();
        keeper.addPayback(new Sum(sumPrize));
        SumResult calculate = detector.calculate(keeper);
        this.log.info((Object)("pay-detector result " + calculate));
        return detector.canPay(calculate);
    }

    private boolean givePrize(int prizeType, int sumPrize, Short cbcService, String actionName, Environment env, int promoId) {
        boolean result = false;
        Pack pack = Session.getInstance().getPack();
        if (prizeType == 1) {
            if (Dispenser.getInstance() == null) {
                this.log.info((Object)"Present dispenser is not set");
            } else {
                this.log.info((Object)"Present dispenser is set");
                int cost = Dispenser.getInstance().getPresentCost(1);
                if (cost < 1) {
                    cost = 100;
                }
                int prizes = sumPrize / cost;
                this.log.info((Object)("Present dispenser cost: " + cost + " sumPrize: " + sumPrize + " prize: " + prizes));
                if (prizes > 100) {
                    prizes = 100;
                }
                if (prizes > 0) {
                    Dispenser.getInstance().givePresent(prizes);
                    this.log.info((Object)"Done");
                    pack.getPayments().clear();
                    pack.setKeeper(new Keeper());
                    env.setEndingModule(new PresentGiftEndingModule(this.context));
                    env.getEndingModule().end(env);
                    result = true;
                    LinkedList<Integer> list = new LinkedList<Integer>();
                    for (int i = 0; i < prizes; ++i) {
                        list.add(promoId);
                    }
                    AppEnvironment.getInstance().addAdvEvent(list, AdvStatisticType.Present);
                }
            }
        } else if (prizeType == 2 || prizeType == 0) {
            this.log.info((Object)("Preset payment " + sumPrize));
            result = true;
            Payment payment = (Payment)pack.getPayments().get(0);
            pack.getPayments().clear();
            pack.setKeeper(new Keeper());
            pack.getKeeper().addPayback(new Sum(sumPrize));
            env.setEndingModule(new PresentEndingModule(this.context));
            pack.setService(pack.getService() == null ? env.getMenuItem().getService() : pack.getService());
            pack.setPaymentType(1);
            pack.setCommission(env.getMenuItem().getCommission());
            pack.getPayments().add(payment);
            if (prizeType == 2) {
                if (cbcService != null) {
                    MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor((int)cbcService.shortValue());
                    MenuUtils.processMenu((MenuVisitor)visitor);
                    if (visitor.getMenuItem() != null) {
                        this.log.info((Object)("Change cbc service to " + visitor.getMenuItem().getService()));
                        env.setMenuItem(visitor.getMenuItem());
                        pack.setService(visitor.getMenuItem().getService());
                    } else {
                        this.log.info((Object)("Service " + cbcService + " not found"));
                    }
                }
                pack.setCbc(new CashBackCard(PinCodeGenerator.generate(), new Sum(sumPrize)));
                pack.setSumResult(new SumResult(new Sum(), new Sum(), new Sum(), new Sum(), new Sum(), new Sum(sumPrize), pack.getProviderFee(), null));
                pack.setPaybackType(1);
                payment.setSumOut(new Sum());
            } else {
                MenuItem mi = env.getMenuItem();
                Service s = pack.getService() == null ? mi.getService() : pack.getService();
                Commission c = pack.getCommission() == null ? mi.getCommission() : pack.getCommission();
                SumResult sumResult = CommissionCalculator.calculate((Sum)new Sum(sumPrize), (Keeper)pack.getKeeper(), (Commission)c, (Commission)s.getMinComm(), (Commission)s.getCommission(), null, null, null, (Date)env.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee(), null);
                Session.getInstance().getPack().setSumResult(sumResult);
                payment.setSumOut(sumResult.getOut());
            }
            payment.getData().put("gift", new InputElement("gift", "", MessageFormat.format(B.get((String)"Module.present.bonus.text"), actionName)));
            env.getProcessingModule().process(env);
        }
        return result;
    }

    private class LocalRunner
    implements Runnable {
        Environment environment;

        public LocalRunner(Environment environment) {
            this.environment = environment;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            if (Session.getInstance().getPack().getSumResult() != null && !Session.getInstance().getPack().getSumResult().getOut().isEmpty()) {
                PromoStatistic pst;
                int sumPrize;
                Sum sum;
                boolean noPrize = true;
                Date date = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getDate();
                if (date == null) {
                    date = Session.getInstance().getPack().getDate();
                }
                if (date == null) {
                    date = new Date();
                }
                if (this.environment.getPromos() != null) {
                    void var8_14;
                    MainPresentModule.this.log.info((Object)("Promos: " + Arrays.toString(this.environment.getPromos())));
                    sum = Session.getInstance().getPack().getSumResult().getOut();
                    MainPresentModule.this.log.info((Object)("Pack sum: " + sum));
                    boolean needWaitScreeen = false;
                    for (Promo promo : this.environment.getPromos()) {
                        if (promo.getClientPaymentNumber() == 0) continue;
                        needWaitScreeen = true;
                        break;
                    }
                    if (needWaitScreeen) {
                        PresetHelper.showWait(MainPresentModule.this.context);
                    }
                    Map paymentData = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
                    Promo[] promoArray = this.environment.getPromos();
                    int n = promoArray.length;
                    boolean bl = false;
                    while (var8_14 < n) {
                        Promo promo2 = promoArray[var8_14];
                        sumPrize = promo2.getPrizeFixed();
                        if (sumPrize == 0) {
                            sumPrize = (int)((double)sum.getBasicSum() * (promo2.getPrizePercent() / 100.0));
                        }
                        if (promo2.isRoundCents()) {
                            sumPrize = sumPrize / 100 * 100;
                        }
                        if (sumPrize != 0 && MainPresentModule.this.isUsed(date, promo2, sum, sumPrize, StoreHelper.getElement((String)"id1", (Map)paymentData).getValue(), Session.getInstance().getPack().getService().getId(), Session.getInstance().getPack().getService().getCode(), this.environment.getPoint().getId())) {
                            if (promo2.getPrizeType() != 0 || MainPresentModule.this.checkPaymentSum(sumPrize, this.environment)) {
                                if (MainPresentModule.this.givePrize(promo2.getPrizeType(), sumPrize, promo2.getCbcService(), promo2.getName(), this.environment, promo2.getId())) {
                                    noPrize = false;
                                    break;
                                }
                            } else {
                                MainPresentModule.this.log.info((Object)"Cancel by prize-payment detector");
                            }
                        }
                        ++var8_14;
                    }
                    if (noPrize && needWaitScreeen) {
                        PresetHelper.clearWait(MainPresentModule.this.context);
                    }
                }
                if (noPrize && this.environment.getBonuses() != null) {
                    MainPresentModule.this.log.info((Object)("Bonuses: " + Arrays.toString(this.environment.getBonuses())));
                    sum = Session.getInstance().getPack().getSumResult().getOut();
                    MainPresentModule.this.log.info((Object)("Pack sum: " + sum));
                    Map paymentData = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
                    for (Promo promo : this.environment.getBonuses()) {
                        if (!MainPresentModule.this.isUsedBonus(date, (Bonus)promo, Session.getInstance().getPack().getService().getId(), Session.getInstance().getPack().getService().getCode())) continue;
                        try {
                            PresetHelper.showWait(MainPresentModule.this.context);
                            BonusResult res = MainPresentModule.this.context.getServerConnector().registerBonus(StoreHelper.getElement((String)"id1", (Map)paymentData).getValue(), promo.getId(), sum.getBasicSum(), date);
                            MainPresentModule.this.log.info((Object)("Bonus result: " + res));
                            PresetHelper.clearWait(MainPresentModule.this.context);
                            sumPrize = res.getBalance() * promo.getBonusCost() / 100;
                            if (promo.isRoundCents()) {
                                sumPrize = sumPrize / 100 * 100;
                            }
                            MainPresentModule.this.log.info((Object)("sumPrize = " + sumPrize));
                            if (sumPrize == 0) continue;
                            if (promo.getPrizeType() != 0 || MainPresentModule.this.checkPaymentSum(sumPrize, this.environment)) {
                                boolean canUse = true;
                                if (promo.getPrizeType() == 2 && promo.getCbcService() != null) {
                                    MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor((int)promo.getCbcService().shortValue());
                                    MenuUtils.processMenu((MenuVisitor)visitor);
                                    if (visitor.getMenuItem() != null) {
                                        if (visitor.getMenuItem().getService().getMinSum() != null) {
                                            if (visitor.getMenuItem().getService().getMinSum().getBasicSum() > sumPrize) {
                                                MainPresentModule.this.log.info((Object)("MinSum for cbc service : " + visitor.getMenuItem().getService().getMinSum()));
                                                int needBonuses = visitor.getMenuItem().getService().getMinSum().getBasicSum() * 100 / promo.getBonusCost();
                                                if (promo.isRoundCents()) {
                                                    needBonuses = (needBonuses + 100) / 100 * 100;
                                                }
                                                final DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)"Module.present.bonus.dialog.nouse"), SumFormatter.format((double)((double)res.getBonus() / 100.0)), SumFormatter.format((double)((double)res.getBalance() / 100.0)), SumFormatter.format((double)((double)needBonuses / 100.0)), new Double((double)res.getBonus() / 100.0), (double)res.getBalance() / 100.0, (double)needBonuses / 100.0), 20, DC.cases((int)8), UserCase.Ok);
                                                dialog.addListener((DialogListener)new BonusEmptyDialogListener(this.environment));
                                                EventQueue.invokeLater(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        MainPresentModule.this.context.showDialog((DialogInterface)dialog);
                                                    }
                                                });
                                                canUse = false;
                                            }
                                        } else {
                                            MainPresentModule.this.log.info((Object)"MinSum not set. User can use bonuses.");
                                        }
                                    } else {
                                        MainPresentModule.this.log.info((Object)("Service " + promo.getCbcService() + " for cbc not found. User can use bonuses."));
                                    }
                                }
                                if (canUse) {
                                    final DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Module.present.bonus.dialog"), SumFormatter.format((double)((double)res.getBonus() / 100.0)), SumFormatter.format((double)((double)res.getBalance() / 100.0)), new Sum(sumPrize), new Double((double)res.getBonus() / 100.0), new Double((double)res.getBalance() / 100.0)), 20, DC.cases((int)2), UserCase.Cancel);
                                    dialog.addListener((DialogListener)new BonusDialogListener(sumPrize, this.environment, (Bonus)promo));
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MainPresentModule.this.context.showDialog((DialogInterface)dialog);
                                        }
                                    });
                                }
                                noPrize = false;
                                break;
                            }
                            MainPresentModule.this.log.info((Object)"Cancel by prize-payment detector");
                        }
                        catch (Exception ex) {
                            MainPresentModule.this.log.error((Object)ex, (Throwable)ex);
                        }
                    }
                }
                if ((pst = PromoStatisticStore.getInstance(null).getPromoStatistic()) == null) {
                    pst = new PromoStatistic();
                }
                Pack pack = Session.getInstance().getPack();
                pst.updateSums(pack.getDate(), pack.getSumResult().getOut().getBasicSum(), pack.getSumResult().getCommission().getBasicSum());
                PromoStatisticStore.getInstance(null).setPromoStatistic(pst);
                if (noPrize) {
                    this.environment.getCompletiveModule().start(this.environment);
                }
            }
        }
    }

    private class BonusEmptyDialogListener
    implements DialogListener {
        private Environment environment;

        private BonusEmptyDialogListener(Environment environment) {
            this.environment = environment;
        }

        public void dialogClosed(UserCase userCase) {
            MainPresentModule.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
            this.environment.getCompletiveModule().start(this.environment);
        }
    }

    private class BonusDialogListener
    implements DialogListener {
        private int sumPrize;
        private Environment environment;
        private Bonus bonus;

        public BonusDialogListener(int sumPrize, Environment environment, Bonus bonus) {
            this.sumPrize = sumPrize;
            this.environment = environment;
            this.bonus = bonus;
        }

        public void dialogClosed(UserCase userCase) {
            MainPresentModule.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
            boolean noPrize = true;
            boolean isDespenserPrize = false;
            if (userCase == UserCase.Ok) {
                Map paymentData = ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData();
                try {
                    PresetHelper.showWait(MainPresentModule.this.context);
                    int bonuses = MainPresentModule.this.context.getServerConnector().useBonus(StoreHelper.getElement((String)"id1", (Map)paymentData).getValue());
                    MainPresentModule.this.log.info((Object)("Bonuses after use " + bonuses));
                    this.sumPrize = bonuses * this.bonus.getBonusCost() / 100;
                    if (this.bonus.isRoundCents()) {
                        this.sumPrize = this.sumPrize / 100 * 100;
                    }
                    MainPresentModule.this.log.info((Object)("sumPrize after use = " + this.sumPrize));
                    PresetHelper.clearWait(MainPresentModule.this.context);
                    if (this.sumPrize > 0 && MainPresentModule.this.givePrize(this.bonus.getPrizeType(), this.sumPrize, this.bonus.getCbcService(), this.bonus.getName(), this.environment, this.bonus.getId())) {
                        noPrize = false;
                        if (this.bonus.getPrizeType() == 1) {
                            isDespenserPrize = true;
                        }
                    }
                }
                catch (ConnectorException ex) {
                    MainPresentModule.this.log.error((Object)ex, (Throwable)ex);
                    PresetHelper.clearWait(MainPresentModule.this.context);
                    final DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.present.bonus.server.error"), 15, DC.cases((int)8), UserCase.Ok);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainPresentModule.this.context.showDialog((DialogInterface)dialog);
                        }
                    });
                }
            }
            if (noPrize || isDespenserPrize) {
                this.environment.getCompletiveModule().start(this.environment);
            }
        }
    }
}

