/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.module.PackUtility;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;

public class PayDetector {
    private final Service service;
    private final Commission commission;
    private Sum min;
    private Sum max;
    private final Date dateOfStartPayment;
    private final List<Sum> packSums;
    private final boolean ignoreMMC;
    private final FeeSum providerFee;
    private Sum maxDiffSum;
    private Sum operationSum;
    private Sum smsSum;

    public PayDetector(Service service, Commission commission, Sum min, Sum max, Sum operationSum, Date dateOfStartPayment, List<Sum> packSums, boolean ignoreMMC, FeeSum providerFee) {
        this.service = service;
        this.commission = commission;
        this.min = min;
        this.max = max;
        this.operationSum = operationSum;
        this.dateOfStartPayment = dateOfStartPayment;
        this.packSums = packSums;
        this.ignoreMMC = ignoreMMC;
        this.providerFee = providerFee;
    }

    public Sum getMin() {
        return this.min;
    }

    public void setMin(Sum min) {
        this.min = min;
    }

    public Sum getMax() {
        return this.max;
    }

    public void setMax(Sum max) {
        this.max = max;
    }

    public SumResult calculate(Keeper keeper) {
        Sum divSum;
        Sum sum = divSum = this.service.getDivideSum() == null || this.service.getDivideSum().isEmpty() ? null : this.service.getDivideSum();
        if (this.service.isGroupPaymentDividedCommission() && this.operationSum == null && (this.maxDiffSum == null || this.maxDiffSum.isEmpty()) && (divSum != null || this.packSums != null && !this.packSums.isEmpty())) {
            if (divSum == null) {
                divSum = this.max;
            }
            return CommissionCalculator.calculatePack((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), this.packSums, (Sum)divSum, (Sum)this.max, (Sum)this.maxDiffSum, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (Sum)this.smsSum);
        }
        Sum trade = this.maxDiffSum != null && this.operationSum == null ? this.maxDiffSum : this.operationSum;
        return CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)trade, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum);
    }

    public SumResult calculateWithoutChange(Keeper keeper) {
        Sum trade = this.maxDiffSum != null && this.operationSum == null ? this.maxDiffSum : this.operationSum;
        return CommissionCalculator.calculateWithoutChange((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)trade, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee);
    }

    public SumResult calculatePayPartSum(Keeper keeper) {
        return CommissionCalculator.calculatePayPart((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.max, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee);
    }

    public boolean canCalculatePayPartSumResult(Keeper keeper) {
        return !this.isUndrawnFunds(keeper, true) && this.canPayPart(keeper, true);
    }

    public SumResult calculate2(Keeper keeper) {
        Sum divSum;
        Sum sum = divSum = this.service.getDivideSum() == null || this.service.getDivideSum().isEmpty() ? null : this.service.getDivideSum();
        if (this.service.isGroupPaymentDividedCommission() && divSum != null) {
            return CommissionCalculator.calculatePack((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), this.packSums, (Sum)divSum, (Sum)this.max, (Sum)this.maxDiffSum, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (Sum)this.smsSum);
        }
        Sum trade = this.maxDiffSum != null && this.operationSum == null ? this.maxDiffSum : this.operationSum;
        return CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)trade, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum);
    }

    public List<SumResult> calculateList(Keeper keeper) {
        Sum divSum;
        Sum sum = divSum = this.service.getDivideSum() == null || this.service.getDivideSum().isEmpty() ? null : this.service.getDivideSum();
        if (this.service.isGroupPaymentDividedCommission() && this.operationSum == null && (this.maxDiffSum == null || this.maxDiffSum.isEmpty()) && (divSum != null || this.packSums != null && !this.packSums.isEmpty())) {
            if (divSum == null) {
                divSum = this.max;
            }
            return CommissionCalculator.calculatePackForList((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), this.packSums, (Sum)divSum, (Sum)this.max, (Sum)this.maxDiffSum, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (Sum)this.smsSum);
        }
        return Collections.singletonList(CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.operationSum, (Sum)this.max, (Sum)this.maxDiffSum, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum));
    }

    public List<SumResult> calculateList2(Keeper keeper) {
        if (this.service.isGroupPaymentDividedCommission()) {
            Sum divSum = this.service.getDivideSum() == null || this.service.getDivideSum().isEmpty() ? this.max : this.service.getDivideSum();
            return CommissionCalculator.calculatePackForList((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), this.packSums, (Sum)divSum, (Sum)this.max, (Sum)this.maxDiffSum, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (Sum)this.smsSum);
        }
        return Collections.singletonList(CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.operationSum, (Sum)this.max, (Sum)this.maxDiffSum, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum));
    }

    public SumResult calculateNoDiff(Keeper keeper) {
        if (this.service.isGroupPaymentDividedCommission() && this.operationSum == null) {
            Sum divSum = this.service.getDivideSum() == null || this.service.getDivideSum().isEmpty() ? this.max : this.service.getDivideSum();
            return CommissionCalculator.calculatePack((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), this.packSums, (Sum)divSum, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (Sum)this.smsSum);
        }
        return CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.operationSum, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum);
    }

    public boolean canPay(SumResult sr) {
        return !sr.getOut().isEmpty() && sr.getOut().compareTo(this.min) >= 0;
    }

    public boolean isDisableTakeBills(SumResult sr, Integer use) {
        if (use == null || use == 0) {
            return false;
        }
        return !sr.getOut().isEmpty() && sr.getOut().compareTo(this.min) >= 0;
    }

    public boolean isUndrawnFunds(Keeper keeper, boolean byTimeout) {
        Sum operationSumComm;
        Logger log = Logger.getLogger((String)"pay");
        Sum minSumComm = CommissionCalculator.calculateCommission((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.min, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum);
        if (this.min.add(minSumComm).compareTo(keeper.getSum()) > 0) {
            log.info((Object)"isUndrawnFunds:(min+minSumComm > sumIn) result = true");
            return true;
        }
        if (this.operationSum != null && this.operationSum.add(operationSumComm = CommissionCalculator.calculateCommission((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.operationSum, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum)).compareTo(keeper.getSum()) > 0) {
            if (this.service.getLimitForUndrawnFunds() <= this.service.getMinSum().getBasicSum()) {
                log.info((Object)"isUndrawnFunds: (limit \u043d\u0435 \u0437\u0430\u0434\u0430\u043d && fixedSum > sumIn) result = true");
                return true;
            }
            if (Session.getInstance().getPack().getPayments() != null && Session.getInstance().getPack().getPayments().size() > 1 || !this.service.getDivideSum().isEmpty() && this.service.getDivideSum().compareTo(keeper.getSum()) < 0) {
                log.info((Object)"isUndrawnFunds:(fixedSum > sumIn && isGroupPay) result = true");
                return true;
            }
            if (keeper.getSum().getBasicSum() < this.service.getLimitForUndrawnFunds()) {
                log.info((Object)"isUndrawnFunds: (fixedSum > sumIn && sumIn < limit) result = true");
                return true;
            }
            if (byTimeout) {
                log.info((Object)"isUndrawnFunds:(sumIn > limit && timeout && sumIn < fixedSum -> partPay need) result = false");
                return false;
            }
            log.info((Object)"isUndrawnFunds:(sumIn < fixedSum) result = false");
            return false;
        }
        log.info((Object)"isUndrawnFunds: result = false");
        return false;
    }

    public boolean canPayPart(Keeper keeper, boolean byTimeout) {
        Logger log = Logger.getLogger((String)"pay");
        if (this.service.getLimitForUndrawnFunds() > this.service.getMinSum().getBasicSum()) {
            Sum operationSumComm;
            Sum minSumComm = CommissionCalculator.calculateCommission((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.min, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum);
            if (this.min.add(minSumComm).compareTo(keeper.getSum()) > 0) {
                log.info((Object)"canPayPart:(sumIn < min) result = false");
                return false;
            }
            if (Session.getInstance().getPack().getPayments() != null && Session.getInstance().getPack().getPayments().size() > 1 || !this.service.getDivideSum().isEmpty() && this.service.getDivideSum().compareTo(keeper.getSum()) < 0) {
                log.info((Object)"canPayPart:(fixedSum > sumIn && groupPayment) result = false");
                return false;
            }
            if (this.operationSum != null && this.operationSum.add(operationSumComm = CommissionCalculator.calculateCommission((Sum)keeper.getSum(), (Keeper)keeper, (Commission)this.commission, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Sum)this.operationSum, (Sum)this.max, null, (Date)this.dateOfStartPayment, (String)"CASH", (boolean)this.ignoreMMC, (FeeSum)this.providerFee, (Sum)this.smsSum)).compareTo(keeper.getSum()) > 0) {
                if (byTimeout && keeper.getSum().getBasicSum() >= this.service.getLimitForUndrawnFunds()) {
                    log.info((Object)"canPayPart:(fixedSum > sumIn && timeout && sumIn >= limit) result = true");
                    return true;
                }
                log.info((Object)"canPayPart:(fixedSum > sumIn) result = false");
                return false;
            }
        }
        log.info((Object)"canPayPart: result = false");
        return false;
    }

    public void setMaxDiffSum(Sum maxDiffSum) {
        this.maxDiffSum = maxDiffSum;
    }

    public Sum getMaxDiffSum() {
        return this.maxDiffSum;
    }

    public Sum getOperationSum() {
        return this.operationSum;
    }

    public void setOperationSum(Sum operationSum) {
        this.operationSum = operationSum;
    }

    public static Sum calculateRequierSum(Pack pack, Sum opr, Commission commission, Service service, Date dateOffStartPayment, boolean ignoreMinMaxCommission, Sum min, FeeSum providerFee) {
        try {
            boolean groupPaymentDividedCommission = service.isGroupPaymentDividedCommission();
            List<Object> packSums = new ArrayList();
            if (pack != null) {
                packSums = PackUtility.getPackSums(pack);
            }
            if (groupPaymentDividedCommission && packSums != null && (opr == null || opr.isEmpty())) {
                return CommissionCalculator.calculate(packSums, (Commission)commission, (Commission)service.getCommission(), (Date)dateOffStartPayment, (String)"CASH", (boolean)ignoreMinMaxCommission, (FeeSum)providerFee);
            }
            if (groupPaymentDividedCommission && service.getDivideSum() != null && !service.getDivideSum().isEmpty()) {
                if (opr == null || opr.isEmpty()) {
                    return CommissionCalculator.calculate((Sum)min, (Sum)service.getDivideSum(), (Commission)commission, (Commission)service.getCommission(), (Date)dateOffStartPayment, (String)"CASH", (boolean)ignoreMinMaxCommission, (FeeSum)providerFee);
                }
                if (pack != null) {
                    packSums = PackUtility.getPackDivSums(pack);
                } else {
                    Pack pack2 = new Pack();
                    pack2.setService(service);
                    pack2.setOperationSum(opr);
                    packSums = PackUtility.getPackDivSums(pack2);
                }
                return CommissionCalculator.calculate(packSums, (Commission)commission, (Commission)service.getCommission(), (Commission)service.getMinComm(), (Date)dateOffStartPayment, (String)"CASH", (boolean)ignoreMinMaxCommission, (FeeSum)providerFee);
            }
            if (opr != null && !opr.isEmpty()) {
                return CommissionCalculator.calculate((Sum)opr, (Commission)commission, (Commission)service.getMinComm(), (Commission)service.getCommission(), (Date)dateOffStartPayment, (String)"CASH", (boolean)ignoreMinMaxCommission, (FeeSum)providerFee);
            }
        }
        catch (Exception ex) {
            Logger.getLogger((String)"pay").info((Object)ex.getMessage());
            Logger.getLogger((String)"pay").info((Object)Arrays.toString(ex.getStackTrace()));
        }
        return null;
    }

    public Sum getSmsSum() {
        return this.smsSum;
    }

    public void setSmsSum(Sum smsSum) {
        this.smsSum = smsSum;
    }
}

