/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.KeeperObserver;

public class KeeperObserverProxy
implements KeeperObserver {
    private KeeperObserver baseObserver;
    private KeeperObserver externalObserver;

    public KeeperObserverProxy(KeeperObserver baseObserver, KeeperObserver externalObserver) {
        this.baseObserver = baseObserver;
        this.externalObserver = externalObserver;
    }

    public void update(Keeper keeper, Sum sum) {
        KeeperObserver k = this.baseObserver;
        if (k != null) {
            k.update(keeper, sum);
        }
        if ((k = this.externalObserver) != null) {
            k.update(keeper, sum);
        }
    }

    public void notifyNoMoreNeed() {
        KeeperObserver k = this.baseObserver;
        if (k != null) {
            k.notifyNoMoreNeed();
        }
        if ((k = this.externalObserver) != null) {
            k.notifyNoMoreNeed();
        }
    }

    public String toString() {
        return "KeeperObserverProxy{baseObserver=" + this.baseObserver + ", externalObserver=" + this.externalObserver + '}';
    }
}

