/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.FraudListener;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.cbc.BasePinCodeScreen;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CompleteInit;
import ru.softlogic.gui.screen.popup.dialog.custom.CompletePanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPopupDialog;
import ru.softlogic.gui.utils.SmsSuccessVerifier;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonDynamicScreen;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.intent.BackIntent;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.Module;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.advanced.AdvancedInputModule;
import ru.softlogic.module.payment.BaseKeeperListener;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.module.payment.KeeperObserverProxy;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLimit;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.connector.ConnectorException;

public class CashPaymentModule
extends BasePaymentModule {
    private static final Logger log = LoggerId.PAY;
    private final BasePinCodeScreen pinScreen = (BasePinCodeScreen)ComponentFactory.getInstance().createDialogPanel("cbc");
    private final ScreenListener listener = new LocalScreenListener();
    private final CompletePanel commissionPanel = (CompletePanel)ComponentFactory.getInstance().createDialogPanel("commission");
    private final CommonDynamicScreen diffScreen = (CommonDynamicScreen)CommonScreenStore.getScreen((String)"digital-diff");
    private final FraudListener fraudListener = new LocalFraudListener();
    protected CommonSumScreen sumScreen;
    private Runnable cancelListener;
    private KeeperObserver keeperListener;
    private BaseKeeperListener baseKeeperListener;
    private PayDetector payDetector;
    private Keeper cbcKeeper;
    private Service service;
    private ServiceLimit payToolServiceLimit;
    private Sum max;
    private Sum maxPay;
    private Sum min;
    private Sum requireDiffSum;
    private Sum firstMinNominal;
    private FraudControlRule fcr;

    public CashPaymentModule(ApplicationContext context) {
        super(context);
    }

    @Override
    public int getInactivityTimeout() {
        if (this.service != null && this.service.getAutoProcessDueToInactivity() != null && this.service.getAutoProcessDueToInactivity() >= 20 && this.service.getAutoProcessDueToInactivity() <= 120 && this.payDetector.canPay(this.payDetector.calculate(CashManager.getDefaultInstance().current()))) {
            return this.service.getAutoProcessDueToInactivity();
        }
        return super.getInactivityTimeout();
    }

    @Override
    public void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        Sum wantSum;
        Sum opr;
        Session.getInstance().setCorrectPack(Session.getInstance().getPack());
        this.environment = environment;
        this.sumScreen = sumScreen;
        this.context.setModule(this);
        this.cbcKeeper = null;
        log.info((Object)"Open payment module");
        Pack pack = Session.getInstance().getPack();
        PackUtility.printPack("Payment pack", pack);
        MenuItem mi = environment.getMenuItem();
        this.service = pack.getService() == null ? mi.getService() : pack.getService();
        this.fcr = ModuleHelper.getFraudControlRule(this.service.getId());
        pack.setFraudControlRule(this.fcr);
        this.firstMinNominal = this.service.isFirstBillEqualsMinSum() ? this.service.getMinSum() : null;
        Commission c = pack.getCommission() == null ? mi.getCommission() : pack.getCommission();
        this.min = pack.getMinSum() != null ? pack.getMinSum() : this.service.getMinSum();
        this.maxPay = pack.getMaxSum() != null ? pack.getMaxSum() : this.service.getMaxSum();
        this.max = this.service.getMaxInputSum();
        if (this.max == null || this.max.isEmpty()) {
            this.max = this.service.getMaxSum();
        }
        if ((opr = pack.getOperationSum()) != null && opr.getBasicSum() < 0) {
            ProblemNotifier.notifyProblem((String)(environment.getMenuItem().getService().getId() + "->TransactionSumError: " + opr));
            this.context.toMainMenu();
            return;
        }
        if (this.min == null) {
            this.min = new Sum();
        }
        log.info((Object)("min sum=" + this.min + ", max=" + this.max + ", max payment sum=" + this.maxPay + ", max input sum=" + this.service.getMaxInputSum() + ", operation sum=" + opr));
        if (opr != null && opr.compareTo(this.min) < 0) {
            log.info((Object)("Fix min sum to=" + opr));
            this.min = opr;
        }
        Sum requireSum = PayDetector.calculateRequierSum(pack, opr, c, this.service, environment.getDateOfStartPayment(), mi.isIgnoreMinMaxCommission(), this.min, pack.getProviderFee());
        this.requireDiffSum = new Sum();
        List<Sum> packSums = PackUtility.getPackSums(pack);
        if (this.service.isGroupPaymentDividedCommission() && this.service.getDivideSum() != null && !this.service.getDivideSum().isEmpty() && opr != null && !opr.isEmpty()) {
            packSums = PackUtility.getPackDivSums(pack);
            requireSum = CommissionCalculator.calculate(packSums, (Commission)c, (Commission)this.service.getCommission(), (Commission)this.service.getMinComm(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
        }
        Sum requireSumNoRounding = requireSum;
        this.requireDiffSum = this.roundRequireDiffSum(requireSum);
        if ((requireSum = this.roundRequireSum(requireSum)) == null && this.min.equals((Object)this.maxPay)) {
            requireSumNoRounding = requireSum = CommissionCalculator.calculate((Sum)this.min, (double)1.0, (Commission)c, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
            this.requireDiffSum = this.roundRequireDiffSum(requireSum);
            requireSum = this.roundRequireSum(requireSum);
        }
        if (requireSum == null && !this.min.isEmpty()) {
            requireSumNoRounding = requireSum = CommissionCalculator.calculate((Sum)this.min, (double)1.0, (Commission)c, (Commission)this.service.getMinComm(), (Commission)this.service.getCommission(), (Date)environment.getDateOfStartPayment(), (String)"CASH", (boolean)mi.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
            this.requireDiffSum = this.roundRequireDiffSum(requireSum);
            requireSum = this.roundRequireSum(requireSum);
        }
        if (requireSum != null) {
            log.info((Object)("Required sum: " + requireSum));
        }
        if (requireSum != null && !requireSum.isEmpty() && requireSum.compareTo(this.max) > 0) {
            DialogScreen ds;
            String msg;
            String errorMsg = "Required sum exceeds the MAX_SUM = " + this.max + ". Service id:" + this.service.getId() + ". Required sum: " + requireSum;
            final InputModule im = environment.getInputModule();
            if (im instanceof AdvancedInputModule) {
                msg = MessageFormat.format(B.get((String)"Module.payment.sum.exceeded.error", (Locale)environment.getLocale()), this.max);
                ds = ComponentFactory.getInstance().createDialog(DialogType.Error, msg, 10, DC.cases((int)8, (Locale)environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                ds.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        CashPaymentModule.this.context.toMainMenu();
                    }
                });
                this.context.showDialog((DialogInterface)ds);
            }
            msg = MessageFormat.format(B.get((String)"Module.payment.sum.exceeded", (Locale)environment.getLocale()), this.max);
            ds = ComponentFactory.getInstance().createDialog(DialogType.Error, msg, 10, DC.cases((int)8, (Locale)environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            ds.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    CashPaymentModule.this.cancel(new BackIntent(im));
                }
            });
            this.context.showDialog((DialogInterface)ds);
            return;
        }
        sumScreen.setListener(this.listener);
        this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)sumScreen));
        boolean enabled = false;
        boolean selected = false;
        Point point = environment.getPoint();
        List payments = Session.getInstance().getPack().getPayments();
        if (payments != null && payments.size() > 0) {
            enabled = SmsSuccessVerifier.isEnabled((Service)this.service, (Point)point, (Map)((Payment)payments.get(0)).getData());
            selected = SmsSuccessVerifier.isSelected((Service)this.service, (Commission)c, (Map)((Payment)payments.get(0)).getData());
        }
        this.payDetector = new PayDetector(this.service, c, this.min, this.maxPay, opr, environment.getDateOfStartPayment(), packSums, mi.isIgnoreMinMaxCommission(), pack.getProviderFee());
        if (enabled && selected) {
            log.info((Object)"Sms success enabled and selected.");
            Sum smsSum = SmsSuccessVerifier.getSmsCost((Point)point);
            log.info((Object)("Sms cost = " + smsSum));
            this.payDetector.setSmsSum(smsSum);
        }
        if ((wantSum = pack.getMinSum()) == null || wantSum.isEmpty()) {
            wantSum = pack.getMaxSum();
        }
        Sum reqSum = AppDefaults.getInstance().getBooleanProperty("Cash.payment.requaired.rounding", true) ? requireSum : requireSumNoRounding;
        this.baseKeeperListener = new BaseKeeperListener(this.context, environment.getLocale(), sumScreen, reqSum, wantSum, this.service, this.payDetector, this.service.isAutoFinishPayment(), this.listener, pack.isAllowReturn());
        this.keeperListener = new KeeperObserverProxy(this.baseKeeperListener, externalObserver);
        log.info((Object)"Try enable cash manager");
        this.enableCashManager(Session.getInstance().getCurrentKeeper());
        MediaPlayer.getInstance().play("pay_data.mp3");
    }

    @Override
    public void cancel(Intent intent) {
        if (intent != null) {
            this._cancel(intent);
        } else {
            this.context.toMainMenu();
        }
    }

    private void enableCashManager(Keeper parent) {
        Integer rejectKol = null;
        Integer minNominalNote = null;
        Integer timeout = null;
        Boolean optionalSuccess = null;
        if (this.fcr != null) {
            rejectKol = this.fcr.getRejectKol() == 0 ? null : Integer.valueOf(this.fcr.getRejectKol());
            minNominalNote = this.fcr.getMinNominalNote() == 0 ? null : Integer.valueOf(this.fcr.getMinNominalNote());
            timeout = this.fcr.getTimeout() == 0 ? null : Integer.valueOf(this.fcr.getTimeout());
            optionalSuccess = this.fcr.isOptionalSuccess();
        }
        if (parent != null) {
            log.info((Object)("Enable cash manager with keeper: " + parent + ", fraudrejectKol: " + rejectKol + ", fraudMinNominalNote" + minNominalNote + ", fraudTimeout: " + timeout + ", fraudOptionalSuccess: " + optionalSuccess));
        }
        CashManager.getDefaultInstance().enable(parent, this.max, this.environment.getAllowedNotes(), this.environment.getAllowedCoins(), this.keeperListener, CashMobuleHelper.getAllowDevices(this.service, parent == null ? false : !parent.getCashBackCards().isEmpty()), rejectKol, minNominalNote, timeout, optionalSuccess, this.fraudListener, false, this.firstMinNominal);
    }

    @Override
    public synchronized boolean cancelRequest() {
        Keeper keeper;
        log.info((Object)"Try to cancel payment module");
        Keeper keep = this.cbcKeeper;
        if (keep != null) {
            this.enableCashManager(keep);
        }
        if ((keeper = CashManager.getDefaultInstance().disable()) == null || keeper.getSum().isEmpty()) {
            return true;
        }
        log.info((Object)"Can't invoke CancelRequest");
        this.enableCashManager(keeper);
        return false;
    }

    private synchronized void _cancel(Intent intent) {
        block24: {
            Keeper current;
            log.info((Object)"Cancel was requested on payment module");
            final boolean timeout = intent.getType() == 0;
            log.info((Object)("timout: " + timeout));
            log.info((Object)("AutoProcessDueToInactivity: " + (this.service == null ? "null" : this.service.getAutoProcessDueToInactivity())));
            log.info((Object)("isProcessLessMinimumPayments = " + this.environment.getPaymentSystem().isProcessLessMinimumPayments()));
            Keeper keep = this.cbcKeeper;
            if (keep != null) {
                this.enableCashManager(keep);
            }
            if ((current = CashManager.getDefaultInstance().current()) == null || current.getSum().isEmpty()) {
                log.info((Object)"Keeper is empty. Disable cash devices");
                final Keeper keeper = CashManager.getDefaultInstance().disable();
                if (keeper == null || keeper.getSum().isEmpty()) {
                    log.info((Object)"Keeper is empty. Process intent");
                    Session.getInstance().getPack().setKeeper(keeper);
                    try {
                        CardModuleStore cmStore = CardModuleStore.getInstance();
                        if (cmStore.getCurrentSession() != null) {
                            cmStore.clearCashRequireListener();
                            cmStore.clearBankCashRequireListener();
                            cmStore.invokeOutCancelListener(intent);
                            break block24;
                        }
                        intent.process();
                    }
                    catch (Throwable e) {
                        intent.process();
                    }
                } else {
                    log.info((Object)("New keeper state: " + keeper));
                    if (intent.getType() == 3) {
                        log.info((Object)"Can't do back action. Enable devices again");
                        this.enableCashManager(keeper);
                        ModuleHelper.invoke(this.cancelListener);
                    } else if (this.payDetector.canPay(this.payDetector.calculate(keeper))) {
                        if (timeout && this.service != null && this.service.getAutoProcessDueToInactivity() != null) {
                            log.info((Object)"Exit by timeout, but payment can be processed. Process payment without question.");
                            this.process(keeper, UserCase.Ok, timeout);
                        } else {
                            log.info((Object)"Payment can be processed, ask question");
                            final String messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)CashPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)CashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                                    dialog.addListener(new DialogListener(){

                                        public void dialogClosed(UserCase userCase) {
                                            boolean group;
                                            log.info((Object)("User make choise " + userCase));
                                            boolean isUndrawnFunds = CashPaymentModule.this.payDetector.isUndrawnFunds(keeper, userCase == UserCase.Timeout && timeout);
                                            boolean bl = group = Session.getInstance().getPack().getPayments().size() > 1;
                                            if (!group && (userCase == UserCase.Timeout || userCase == UserCase.Cancel) && CashPaymentModule.this.environment.getPaymentSystem().isProcessLessMinimumPayments() && isUndrawnFunds) {
                                                log.info((Object)"UndrawnFundsSum");
                                                Session.getInstance().getPack().setUndrawnFundsSum(true);
                                                CashPaymentModule.this.process(keeper, UserCase.Ok, timeout);
                                            } else if ((userCase == UserCase.Timeout || timeout) && CashPaymentModule.this.environment.getPaymentSystem().isProcessLessMinimumPayments() && !isUndrawnFunds && CashPaymentModule.this.payDetector.canPayPart(keeper, true)) {
                                                log.info((Object)"PayPart");
                                                Session.getInstance().getPack().setPartPaySum(true);
                                                CashPaymentModule.this.process(keeper, UserCase.Ok, timeout);
                                            } else if (userCase == UserCase.Cancel || userCase == UserCase.Timeout) {
                                                log.info((Object)"Process cancel");
                                                CashPaymentModule.this.process(keeper, userCase, timeout);
                                            } else {
                                                log.info((Object)"Enable devices again");
                                                CashPaymentModule.this.enableCashManager(keeper);
                                                ModuleHelper.invoke(CashPaymentModule.this.cancelListener);
                                            }
                                        }
                                    });
                                    dialog.show(CashPaymentModule.this.context.getShell());
                                }
                            });
                        }
                    } else {
                        log.info((Object)"Payment can't be processed. Cancel payment");
                        if (this.environment.getPaymentSystem().isProcessLessMinimumPayments() && this.payDetector.isUndrawnFunds(keeper, timeout)) {
                            log.info((Object)"UndrawnFundsSum");
                            Session.getInstance().getPack().setUndrawnFundsSum(true);
                            this.process(keeper, UserCase.Ok, timeout);
                        } else {
                            this.process(keeper, UserCase.Cancel, timeout);
                        }
                    }
                }
            } else {
                log.info((Object)"Keeper is not empty. Disable cash devices");
                if (this.payDetector.canPay(this.payDetector.calculate(current))) {
                    final Keeper keeper = CashManager.getDefaultInstance().disable();
                    if (timeout && this.service != null && this.service.getAutoProcessDueToInactivity() != null) {
                        log.info((Object)"Exit by timeout, but the amount is sufficient for the payment. Process payment without question.");
                        this.process(keeper, UserCase.Ok, timeout);
                    } else if (intent.getType() == 3) {
                        Session.getInstance().getPack().setKeeper(keeper);
                        intent.process();
                    } else {
                        log.info((Object)"The amount is sufficient for the payment, ask question");
                        final String messageId = timeout ? "Dialog.payment.timeout" : "Dialog.payment.cancel";
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)messageId, (Locale)CashPaymentModule.this.environment.getLocale()), 20, DC.cases((int)4, (Locale)CashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                                dialog.addListener(new DialogListener(){

                                    public void dialogClosed(UserCase userCase) {
                                        boolean group;
                                        log.info((Object)("User make choise " + userCase));
                                        boolean isUndrawnFunds = CashPaymentModule.this.payDetector.isUndrawnFunds(keeper, userCase == UserCase.Timeout && timeout);
                                        log.info((Object)("isUndrawnFunds = " + isUndrawnFunds));
                                        boolean bl = group = Session.getInstance().getPack().getPayments().size() > 1;
                                        if (!group && (userCase == UserCase.Timeout || userCase == UserCase.Cancel) && CashPaymentModule.this.environment.getPaymentSystem().isProcessLessMinimumPayments() && isUndrawnFunds) {
                                            log.info((Object)"UndrawnFundsSum");
                                            Session.getInstance().getPack().setUndrawnFundsSum(true);
                                            CashPaymentModule.this.process(keeper, UserCase.Ok, timeout);
                                        } else if (timeout && CashPaymentModule.this.environment.getPaymentSystem().isProcessLessMinimumPayments() && !isUndrawnFunds && CashPaymentModule.this.payDetector.canPayPart(keeper, true)) {
                                            log.info((Object)"PayPart");
                                            Session.getInstance().getPack().setPartPaySum(true);
                                            CashPaymentModule.this.process(keeper, UserCase.Ok, timeout);
                                        } else {
                                            CashPaymentModule.this.process(keeper, userCase, timeout);
                                        }
                                    }
                                });
                                dialog.show(CashPaymentModule.this.context.getShell());
                            }
                        });
                    }
                } else {
                    log.info((Object)"The amount is NOT sufficient for the payment, ask question");
                    final Keeper keeper = CashManager.getDefaultInstance().disable();
                    if (intent.getType() == 3) {
                        Session.getInstance().getPack().setKeeper(keeper);
                        intent.process();
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Dialog.payment.cancel.continue", (Locale)CashPaymentModule.this.environment.getLocale()), 20, DC.cases((int)5, (Locale)CashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Timeout);
                                dialog.addListener(new DialogListener(){

                                    public void dialogClosed(UserCase userCase) {
                                        boolean group;
                                        log.info((Object)("User make choise " + userCase));
                                        boolean isUndrawnFunds = CashPaymentModule.this.payDetector.isUndrawnFunds(keeper, userCase == UserCase.Timeout && timeout);
                                        boolean bl = group = Session.getInstance().getPack().getPayments().size() > 1;
                                        if (!group && (userCase == UserCase.Timeout || userCase == UserCase.Cancel) && CashPaymentModule.this.environment.getPaymentSystem().isProcessLessMinimumPayments() && isUndrawnFunds) {
                                            log.info((Object)"UndrawnFundsSum");
                                            Session.getInstance().getPack().setUndrawnFundsSum(true);
                                            Sum divSum = Session.getInstance().getPack().getService().getDivideSum();
                                            if (divSum != null && !divSum.isEmpty()) {
                                                Session.getInstance().getPack().setUndrawnFundsSum(false);
                                            }
                                            CashPaymentModule.this.process(keeper, UserCase.Ok, timeout);
                                        } else if (timeout && CashPaymentModule.this.environment.getPaymentSystem().isProcessLessMinimumPayments() && !isUndrawnFunds && CashPaymentModule.this.payDetector.canPayPart(keeper, true)) {
                                            log.info((Object)"PayPart");
                                            Session.getInstance().getPack().setPartPaySum(true);
                                            CashPaymentModule.this.process(keeper, UserCase.Ok, timeout);
                                        } else if (userCase == UserCase.Cancel || userCase == UserCase.Timeout) {
                                            log.info((Object)"Disable cash devices");
                                            CashPaymentModule.this.process(keeper, userCase, timeout);
                                        } else {
                                            CashPaymentModule.this.enableCashManager(keeper);
                                            ModuleHelper.invoke(CashPaymentModule.this.cancelListener);
                                        }
                                    }
                                });
                                dialog.show(CashPaymentModule.this.context.getShell());
                            }
                        });
                    }
                }
            }
        }
    }

    private void blockPayment() {
        log.info((Object)"Block payment on payment module");
        Keeper current = CashManager.getDefaultInstance().current();
        if (current.getSum().isEmpty()) {
            log.info((Object)"Keeper is empty. Disable cash devices");
            Keeper keeper = CashManager.getDefaultInstance().disable();
            if (keeper.getSum().isEmpty()) {
                log.info((Object)"Keeper is empty. Process intent");
                try {
                    if (CardModuleStore.getInstance().getCurrentSession() != null) {
                        CardModuleStore.getInstance().closeSession(true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.context.toMainMenu();
            } else {
                log.info((Object)"Payment can't be processed. Cancel payment");
                Session.getInstance().getPack().setFraud(true);
                this.process(keeper, UserCase.Ok, false);
            }
        } else {
            log.info((Object)"Keeper is not empty. Disable cash devices");
            Keeper keeper = CashManager.getDefaultInstance().disable();
            Session.getInstance().getPack().setFraud(true);
            this.process(keeper, UserCase.Ok, false);
        }
    }

    private void process(Keeper keeper, UserCase userCase, boolean timeout) {
        Sum totalInput;
        log.info((Object)("Begin process payment, action=" + userCase + ", timeout=" + timeout));
        ServiceZReportStorage.getInstance().getCurrentSnapshot().addZCashSum(keeper);
        if (keeper.getSum().isEmpty()) {
            ProblemNotifier.getDefaultNotifier().onProblem("#001");
            log.error((Object)"Double click?");
            return;
        }
        Pack pkg = Session.getInstance().getPack();
        pkg.setKeeper(keeper);
        SumResult sumResult = pkg.isUndrawnFundsSum() || pkg.isPartPaySum() ? this.payDetector.calculatePayPartSum(keeper) : this.payDetector.calculate(keeper);
        this.subSmsCommission(sumResult);
        Sum divSum = pkg.getService().getDivideSum();
        Sum os = pkg.getOperationSum();
        pkg.setFixedSum(os != null && !os.isEmpty());
        if ((os == null || os.isEmpty()) && (divSum != null && !divSum.isEmpty() && pkg.getPayments().size() == 1 || this.service.isGroupPaymentDividedCommission()) && pkg.getProviderFee() == null && userCase == UserCase.Ok && !pkg.isPartPaySum()) {
            if (this.service.isGroupPaymentDividedCommission()) {
                Payment firstPayment = null;
                List<SumResult> calculateList = this.payDetector.calculateList(keeper);
                if (pkg.getPayments().size() == 1) {
                    for (SumResult sr : calculateList) {
                        this.subSmsCommission(sr);
                        if (firstPayment == null) {
                            Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                            payment.setSumOut(sr.getOut());
                            payment.setSum\u0421omm(sr.getCommission());
                            firstPayment = payment;
                            continue;
                        }
                        Payment p = new Payment();
                        p.setData(firstPayment.getData());
                        p.setSumOut(sr.getOut());
                        p.setSum\u0421omm(sr.getCommission());
                        Session.getInstance().getPack().getPayments().add(p);
                    }
                } else {
                    int idx = 0;
                    for (SumResult sr : calculateList) {
                        this.subSmsCommission(sr);
                        Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(idx);
                        payment.setSumOut(sr.getOut());
                        payment.setSum\u0421omm(sr.getCommission());
                        ++idx;
                    }
                }
                if (userCase == UserCase.Ok) {
                    pkg.setSumResult(sumResult);
                    pkg.setCancel(false);
                } else {
                    sumResult.setChange(sumResult.getIncome());
                    sumResult.setCommission(new Sum());
                    sumResult.setOut(new Sum());
                    PackUtility.cancelPackage(pkg);
                    pkg.setSumResult(sumResult);
                    pkg.setCancel(true);
                }
                this.startPayout(this.environment);
                return;
            }
            if (divSum != null && !divSum.isEmpty()) {
                totalInput = new Sum(sumResult.getOut());
                log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
                int count = totalInput.getBasicSum() / divSum.getBasicSum();
                if (!totalInput.divRest(divSum).isEmpty()) {
                    ++count;
                }
                --count;
                Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                payment.setOperationSum(divSum);
                for (int i = 0; i < count; ++i) {
                    Payment payment1 = new Payment();
                    payment1.setData(payment.getData());
                    payment1.setOperationSum(divSum);
                    Session.getInstance().getPack().getPayments().add(payment1);
                }
                Session.getInstance().getPack().setSumDistributionType("consistent");
            }
        } else if (!(os == null || os.isEmpty() || divSum == null || divSum.isEmpty() || pkg.getPayments().size() != 1 || pkg.getProviderFee() != null || userCase != UserCase.Ok || pkg.isPartPaySum())) {
            sumResult = this.payDetector.calculate2(keeper);
            if (this.service.isGroupPaymentDividedCommission()) {
                Payment firstPayment = null;
                List<SumResult> calculateList = this.payDetector.calculateList2(keeper);
                if (pkg.getPayments().size() == 1) {
                    for (SumResult sr : calculateList) {
                        if (firstPayment == null) {
                            Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                            payment.setSumOut(sr.getOut());
                            payment.setSum\u0421omm(sr.getCommission());
                            firstPayment = payment;
                            continue;
                        }
                        Payment p = new Payment();
                        p.setData(firstPayment.getData());
                        p.setSumOut(sr.getOut());
                        p.setSum\u0421omm(sr.getCommission());
                        Session.getInstance().getPack().getPayments().add(p);
                    }
                } else {
                    int idx = 0;
                    for (SumResult sr : calculateList) {
                        Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(idx);
                        payment.setSumOut(sr.getOut());
                        payment.setSum\u0421omm(sr.getCommission());
                        ++idx;
                    }
                }
                pkg.setSumResult(sumResult);
                pkg.setCancel(false);
                this.startPayout(this.environment);
                return;
            }
            if (divSum != null && !divSum.isEmpty()) {
                totalInput = new Sum(sumResult.getOut());
                log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
                int count = totalInput.getBasicSum() / divSum.getBasicSum();
                if (!totalInput.divRest(divSum).isEmpty()) {
                    ++count;
                }
                --count;
                Payment payment = (Payment)Session.getInstance().getPack().getPayments().get(0);
                payment.setOperationSum(divSum);
                for (int i = 0; i < count; ++i) {
                    Payment payment1 = new Payment();
                    payment1.setData(payment.getData());
                    payment1.setOperationSum(divSum);
                    Session.getInstance().getPack().getPayments().add(payment1);
                }
                Session.getInstance().getPack().setSumDistributionType("consistent");
            }
        }
        if (pkg.getPayments().size() == 1) {
            log.info((Object)"Process single operation pack");
            Payment p = (Payment)pkg.getPayments().get(0);
            if (userCase == UserCase.Ok) {
                p.setSumOut(sumResult.getOut());
                pkg.setSumResult(sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                sumResult.setOutProv(new Sum());
                sumResult.setCommService(null);
                p.setSumOut(new Sum());
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        } else {
            log.info((Object)("Pack size: " + pkg.getPayments().size()));
            if (userCase == UserCase.Ok) {
                pkg.setSumResult(sumResult);
                PackUtility.distributeSum(pkg, sumResult);
                pkg.setCancel(false);
            } else {
                sumResult.setChange(sumResult.getIncome());
                sumResult.setCommission(new Sum());
                sumResult.setOut(new Sum());
                sumResult.setOutProv(new Sum());
                sumResult.setCommService(null);
                PackUtility.cancelPackage(pkg);
                pkg.setSumResult(sumResult);
                pkg.setCancel(true);
            }
        }
        this.startPayout(this.environment);
    }

    private void subSmsCommission(SumResult sumResult) {
        Sum commService = sumResult.getCommService();
        if (commService != null) {
            Sum commission = sumResult.getCommission();
            sumResult.setCommission(commission.sub(commService));
        }
    }

    private Sum roundRequireSum(Sum requireSum) {
        int ost;
        CashUnit[] cashUnits;
        if (requireSum == null) {
            return requireSum;
        }
        if (CashDeviceManager.getInstance().getDefaultCoinValidator() == null && (cashUnits = CashFactory.getDefaultInstance().getCashUnits()) != null && cashUnits.length > 0 && (ost = requireSum.getBasicSum() % cashUnits[0].getNominal().getBasicSum()) > 0) {
            return requireSum.add(cashUnits[0].getNominal().sub(new Sum(ost)));
        }
        return requireSum;
    }

    private Sum roundRequireDiffSum(Sum requireSum) {
        if (requireSum == null) {
            return requireSum;
        }
        int ost = requireSum.getBasicSum() % 100;
        if (ost > 0) {
            return requireSum.add(new Sum(100 - ost));
        }
        return requireSum;
    }

    public void toDiffScreen() {
        Pack pack = Session.getInstance().getPack();
        if (pack.getOperationSum() != null && !pack.getOperationSum().isEmpty()) {
            log.info((Object)"Operation sum is set. Can't to edit max sum");
            ModuleHelper.invoke(this.cancelListener);
            return;
        }
        if (pack.getProviderFee() != null) {
            log.info((Object)"Provider fee is set, can't edit max sum");
            ModuleHelper.invoke(this.cancelListener);
            return;
        }
        this.cbcKeeper = CashManager.getDefaultInstance().disable();
        ModuleHelper.invoke(this.cancelListener);
        try {
            ModuleHelper.showDiffSumScreen((ScreenListener)new LocalDiffSumListener(), (CommonScreen)this.diffScreen, this.environment, this.context, this.cbcKeeper.getSum(), this.requireDiffSum, this);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            this.enableCashManager(this.cbcKeeper);
            this.cbcKeeper = null;
        }
    }

    @Override
    public boolean canRedirect() {
        Keeper current = CashManager.getDefaultInstance().current();
        log.info((Object)"canRedirect: Request for permission to redirect from PaymentModule");
        if (current == null || current.getSum().isEmpty()) {
            log.info((Object)"canRedirect: Keeper is empty. Disable cash devices");
            Keeper keeper = CashManager.getDefaultInstance().disable();
            if (keeper == null || keeper.getSum().isEmpty()) {
                log.info((Object)"canRedirect: Keeper is empty. Process redirect");
                return true;
            }
            log.info((Object)"canRedirect: Current keeper is not empty");
            this.enableCashManager(keeper);
            return false;
        }
        log.info((Object)"canRedirect: Current keeper is not empty. Skip redirect");
        return false;
    }

    private class LocalFraudListener
    implements FraudListener {
        private LocalFraudListener() {
        }

        public void fraudDetected(Integer fraudTimeout) {
            log.error((Object)"Fraud Detected. Block payment");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AppDefaults.getInstance().getBooleanProperty("fraud.block-on-payment", false)) {
                        Session.getInstance().getPack().setFraud(true);
                    } else {
                        CashPaymentModule.this.blockPayment();
                    }
                }
            });
        }
    }

    private class LocalDiffSumListener
    extends ScreenAdapter {
        private LocalDiffSumListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CashPaymentModule.this.cancelListener = cancelListener;
            Keeper keeper = CashPaymentModule.this.cbcKeeper;
            Sum income = CashPaymentModule.this.cbcKeeper.getSum();
            CashPaymentModule.this.cbcKeeper = null;
            ModuleHelper.invoke(cancelListener);
            if (ActionType.isPrev((String)action)) {
                CashPaymentModule.this.enableCashManager(keeper);
                CashPaymentModule.this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)CashPaymentModule.this.sumScreen));
            } else if (ActionType.isExit((String)action)) {
                CashPaymentModule.this.enableCashManager(keeper);
                CashPaymentModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                Object obj = data.get("diff-sum");
                Sum diffSum = null;
                if (obj instanceof InputElement) {
                    InputElement ie = (InputElement)obj;
                    try {
                        diffSum = new Sum(Double.parseDouble(ie.getValue()));
                        if (diffSum.equals((Object)income)) {
                            diffSum = null;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
                log.info((Object)("User diff sum: " + diffSum));
                CashPaymentModule.this.payDetector.setMaxDiffSum(diffSum);
                CashPaymentModule.this.enableCashManager(keeper);
                CashPaymentModule.this.context.showScreen(new ContentScreenAdapterKbr((CommonScreen)CashPaymentModule.this.sumScreen));
            } else if (ActionType.isEdit((String)action)) {
                CashPaymentModule.this.cbcKeeper = keeper;
                Object obj = data.get("diff-sum");
                if (obj instanceof InputElement) {
                    InputElement ie = (InputElement)obj;
                    try {
                        Sum diffSum = new Sum(Double.parseDouble(ie.getValue()));
                        Keeper k = new Keeper();
                        k.addCashBackCard(new CashBackCard(0, diffSum));
                        SumResult sr = CashPaymentModule.this.payDetector.calculateNoDiff(k);
                        CashPaymentModule.this.diffScreen.updateData(Collections.singletonMap("sum-result", sr));
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    private class DialogRunnable
    implements Runnable {
        private final String text;

        public DialogRunnable(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, this.text, 10, DC.cases((int)1, (Locale)CashPaymentModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    CashPaymentModule.this.enableCashManager(CashPaymentModule.this.cbcKeeper);
                    CashPaymentModule.this.cbcKeeper = null;
                }
            });
            CashPaymentModule.this.context.showDialog((DialogInterface)dialog);
        }
    }

    private class PincodeActivator
    implements Task {
        private final String pin;

        public PincodeActivator(String pin) {
            this.pin = pin;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.cbc.wait");
        }

        @Override
        public Object execute() {
            Sum localMaxSum;
            Sum sum = localMaxSum = CashPaymentModule.this.payToolServiceLimit != null ? CashPaymentModule.this.payToolServiceLimit.getMaxSum() : CashPaymentModule.this.max;
            if (localMaxSum == null || localMaxSum.isEmpty()) {
                log.info((Object)"Max sum is not specify. Return error");
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            if (localMaxSum.compareTo(CashPaymentModule.this.cbcKeeper.getSum()) <= 0) {
                log.info((Object)("Keeper reached max sum. Return error. Max=" + localMaxSum + ", keeper=" + CashPaymentModule.this.cbcKeeper.getSum()));
                return new ActivationResult(ActivationResultType.ErrSum, 0, null);
            }
            Sum rest = localMaxSum.sub(CashPaymentModule.this.cbcKeeper.getSum());
            log.info((Object)("Maximum nominal: " + localMaxSum));
            log.info((Object)("Allowed rest: " + rest));
            try {
                return CashPaymentModule.this.context.getServerConnector().acivateCashBackCard(this.pin, new Sum(), localMaxSum.sub(CashPaymentModule.this.cbcKeeper.getSum()), SequenceManager.getValueQuietly((String)"cbcard"));
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            String text;
            log.info((Object)("Result: " + object));
            if (object instanceof ActivationResult) {
                ActivationResult ar = (ActivationResult)object;
                if (ar.getError() == ActivationResultType.Ok) {
                    CashBackCard cbc = CashFactory.getDefaultInstance().getCashBackCard();
                    cbc.setNominal(ar.getRest());
                    cbc.setRef(ar.getIdOperation());
                    CashPaymentModule.this.cbcKeeper.addCashBackCard(cbc);
                    CashPaymentModule.this.enableCashManager(CashPaymentModule.this.cbcKeeper);
                    CashPaymentModule.this.cbcKeeper = null;
                    return;
                }
                text = B.get((String)("Request.cbc.err." + ar.getError()), (Locale)CashPaymentModule.this.environment.getLocale());
            } else {
                text = B.get((String)("Request.cbc.err." + ActivationResultType.ErrNetwork), (Locale)CashPaymentModule.this.environment.getLocale());
            }
            EventQueue.invokeLater(new DialogRunnable(text));
        }
    }

    private class LocalPinCodeListener
    implements CustomDialogListener {
        private LocalPinCodeListener() {
        }

        public void onClose(Object type) {
            ModuleHelper.invoke(CashPaymentModule.this.cancelListener);
            if (type != null) {
                String pincode = (String)type;
                log.info((Object)("Input pincode: " + pincode));
                ModuleHelper.invoke(CashPaymentModule.this.cancelListener);
                CashPaymentModule.this.context.getTaskExecutor().execute(new PincodeActivator(pincode));
            } else {
                log.info((Object)"Close pincode screen");
                ModuleHelper.invoke(CashPaymentModule.this.cancelListener);
                CashPaymentModule.this.enableCashManager(CashPaymentModule.this.cbcKeeper);
                CashPaymentModule.this.cbcKeeper = null;
                CashPaymentModule.this.context.getShell().showPopup(null);
            }
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            Module module = CashPaymentModule.this.context.getModuleStore().getModule();
            if (module != null && module.getType() != 3) {
                return;
            }
            log.info((Object)("Action on sum screen: " + action));
            CashPaymentModule.this.cancelListener = cancelListener;
            if (ActionType.isCbc((String)action)) {
                CashPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                log.info((Object)("Keeper: " + CashPaymentModule.this.cbcKeeper));
                if (!CashMobuleHelper.isAllowCBC(CashPaymentModule.this.service, !CashPaymentModule.this.cbcKeeper.getCashSum().isEmpty())) {
                    log.info((Object)"CBC disable for this service ");
                    CashPaymentModule.this.enableCashManager(CashPaymentModule.this.cbcKeeper);
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                CashPaymentModule.this.pinScreen.init(CashPaymentModule.this.environment.getLocale());
                CustomPopupDialog cpd = new CustomPopupDialog((CustomPanel)CashPaymentModule.this.pinScreen, Math.min(40, CashPaymentModule.this.getInactivityTimeout() - 5), null, true);
                cpd.addListener((CustomDialogListener)new LocalPinCodeListener());
                CashPaymentModule.this.context.showDialog((DialogInterface)cpd);
            } else if (ActionType.isExit((String)action)) {
                CashPaymentModule.this.cancel(new ExitIntent(CashPaymentModule.this.context, 2));
            } else if (ActionType.isPrev((String)action)) {
                Restorable parent = null;
                parent = CashPaymentModule.this.environment.getTemplateModule() != null && CashPaymentModule.this.environment.getTemplateModule().isActive() ? CashPaymentModule.this.environment.getTemplateModule() : CashPaymentModule.this.environment.getInputModule();
                CashPaymentModule.this.cancel(new BackIntent(parent));
            } else if (ActionType.isNext((String)action)) {
                CashPaymentModule.this.process(CashManager.getDefaultInstance().disable(), UserCase.Ok, false);
            } else if (ActionType.isPayPart((String)action)) {
                Keeper keeper = CashManager.getDefaultInstance().disable();
                log.info((Object)"ActionType.PayPart");
                Session.getInstance().getPack().setPartPaySum(true);
                CashPaymentModule.this.process(keeper, UserCase.Ok, false);
            } else if (ActionType.isCommission((String)action)) {
                if (CashPaymentModule.this.commissionPanel == null) {
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                SumResult sr = CashPaymentModule.this.payDetector.calculate(CashManager.getDefaultInstance().current());
                HashMap<String, Object> dt = new HashMap<String, Object>();
                dt.put("env", CashPaymentModule.this.environment);
                dt.put("sr", sr);
                dt.put("pack", Session.getInstance().getPack());
                if (CashManager.getDefaultInstance().current() != null) {
                    dt.put("keeper-sum", CashManager.getDefaultInstance().current().getSum());
                }
                dt.put("screen-data", data);
                try {
                    dt.put("pernumbers", ReferenceManager.getInstance().getPersonalNumbers(CashPaymentModule.this.environment.getMenuItem().getService()));
                }
                catch (ReferenceException ex) {
                    log.error((Object)ex);
                }
                CashPaymentModule.this.commissionPanel.init(new CompleteInit(null, CashPaymentModule.this.environment.getMenuItem().getService(), CashPaymentModule.this.environment.getMenuItem().getCommission(), sr, dt, CashPaymentModule.this.environment.getLocale(), CashPaymentModule.this.environment.getDateOfStartPayment(), "CASH", CashPaymentModule.this.environment.getMenuItem()));
                CashPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                CustomPopupDialog dialog = new CustomPopupDialog((CustomPanel)CashPaymentModule.this.commissionPanel, Math.min(30, CashPaymentModule.this.getInactivityTimeout() - 5));
                dialog.addListener((CustomDialogListener)new LocalPinCodeListener());
                CashPaymentModule.this.context.showDialog((DialogInterface)dialog);
            } else if (ActionType.isEdit((String)action)) {
                CashPaymentModule.this.toDiffScreen();
            } else if (ActionType.isSMSSuccess((String)action)) {
                InputElement ie;
                Sum smsSum = null;
                if (data.get("sms-check") != null && "1".equals((ie = (InputElement)data.get("sms-check")).getValue())) {
                    smsSum = SmsSuccessVerifier.getSmsCost((Point)CashPaymentModule.this.environment.getPoint());
                }
                CashPaymentModule.this.cbcKeeper = CashManager.getDefaultInstance().disable();
                log.info((Object)("Chanhe sms-success checkbox. sms cost=: " + smsSum));
                CashPaymentModule.this.payDetector.setSmsSum(smsSum);
                Keeper keeper = CashPaymentModule.this.cbcKeeper;
                CashPaymentModule.this.enableCashManager(keeper);
                ModuleHelper.invoke(cancelListener);
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Unknown action on sumscreen: " + action);
            }
        }

        public void onLocale(Locale locale) {
            CashPaymentModule.this.environment.setLocale(locale);
        }

        public void onRedirect(int serviceId) {
            CashPaymentModule.this._redirect(serviceId);
        }
    }
}

