/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.application.ExtKeyboardAdapter;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.Currency;
import ru.softlogic.cards.v2.connector.model.FinanceOperation;
import ru.softlogic.cards.v2.connector.model.OperationPurchaseResult;
import ru.softlogic.cards.v2.connector.model.OperationResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleCardDataListener;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboard;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboardKeyListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.BackIntent;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.io.utils.BU;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.card.CardConfirmHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.ExitRevertDialogListener;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.operation.CashlessData;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLimit;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public class CardPaymentModule
extends BasePaymentModule {
    private static final String SUM_KEY = "sum";
    private static final Logger log = Logger.getLogger((String)"pay");
    private final WaitScreen waitScreen = ComponentFactory.getInstance().createWaitScreen("");
    private CardModule cm;
    private Sum sumIncome;
    private Sum sumOutcome;
    private Map<String, Object> data;
    private LocalGuiListener guiListener;
    private volatile boolean invokeOperation;
    private CommonSumScreen sumScreen;
    private boolean skipConfirm;
    private FinanceOperation fo;

    public CardPaymentModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _startPayment(Environment environment, CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        Pack pack = Session.getInstance().getPack();
        Session.getInstance().setCorrectPack(pack);
        this.environment = environment;
        this.sumScreen = sumScreen;
        this.guiListener = new LocalGuiListener(this.context, environment, log);
        this.skipConfirm = false;
        try {
            CardModuleStore cmStore = CardModuleStore.getInstance();
            cmStore.setReference(environment.getPoint());
            this.cm = cmStore.getCurrentSession();
            if (this.cm != null) {
                cmStore.setUserEventInterfaceListener(this.guiListener);
                this.skipConfirm = true;
            } else {
                this.cm = cmStore.openSession(this.guiListener);
            }
            if (cmStore.isNeedReverse()) {
                this.cm = null;
                ProblemNotifier.notifyProblem((String)(pack.getService().getId() + "->Need revers"));
                this.guiListener.setIntent(new ExitIntent(this.context));
                this.cancelSession(false);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.cm = null;
        }
        this.waitScreen.setText("\u041e\u0436\u0438\u0434\u0430\u0439\u0442\u0435, \u0438\u0434\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        Sum opr = pack.getOperationSum();
        log.info((Object)("Sum purchase: " + opr));
        if (this.cm == null || opr != null && opr.getBasicSum() < 0) {
            ProblemNotifier.notifyProblem((String)(pack.getService().getId() + "->TransactionSumError: " + opr));
            this.guiListener.setIntent(new ExitIntent(this.context));
            this.cancel(null);
            return;
        }
        if (opr == null || opr.isEmpty()) {
            log.info((Object)"Purchase sum is not set, open numeric screen");
            this.data = new HashMap<String, Object>();
            Sum recommendedSum = Session.getInstance().getPack().getRecommendedSum();
            log.info((Object)("Recommended sum: " + recommendedSum));
            if (recommendedSum != null) {
                this.data.put(SUM_KEY, new InputElement(SUM_KEY, SUM_KEY, Integer.toString(recommendedSum.getBasicSum() / 100)));
            }
            this.showSumScreen();
        } else {
            this.showSumConfirmScreen(opr);
        }
    }

    @Override
    public void cancel(Intent intent) {
        if (!CardModuleStore.getInstance().isOpenFromInputModule()) {
            this.cancelSession(true);
        } else {
            if (intent == null) {
                intent = new ExitIntent(this.context);
            }
            intent.process();
        }
    }

    private void cancelSession(boolean reversSave) {
        block5: {
            try {
                CardModuleStore cmStore = CardModuleStore.getInstance();
                if (cmStore.getCurrentSession() == null) break block5;
                try {
                    if (this.invokeOperation) {
                        this.cm.cancelOperation();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                cmStore.closeSessionSafe(reversSave);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showSumScreen() {
        try {
            CommonScreen cs = CommonScreenStore.getScreen((String)"digital");
            ExtKeyboard.getInstance().getFocus((ExtKeyboardKeyListener)new ExtKeyboardAdapter(cs.getKeyboardListener()));
            cs.setListener((ScreenListener)new LocalSumScreenListener());
            Pack pack = Session.getInstance().getPack();
            cs.init(this.createSumScreenDescription(this.environment.getLocale(), pack.getService()), InitModuleHelper.buildScreenInit(this.environment, this.data));
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (InitException ex) {
            this.cancel(null);
            log.info((Object)ex, (Throwable)ex);
        }
    }

    private void showSumConfirmScreen(Sum opr) {
        if (AppDefaults.getInstance().getBooleanProperty("Module.payment.card.show-sum-confirm", false)) {
            try {
                Pack pack = Session.getInstance().getPack();
                SumScreenDescription sd = this.createSumConfirmScreenDescription(this.environment.getLocale());
                CommonScreen cs = CommonScreenStore.getSumScreen((SumScreenDescription)sd, (MenuItem)this.environment.getMenuItem(), (String)"cards-sum-confirm", (boolean)true);
                ExtKeyboard.getInstance().getFocus((ExtKeyboardKeyListener)new ExtKeyboardAdapter(cs.getKeyboardListener()));
                HashMap<String, Object> d = new HashMap<String, Object>(((Payment)pack.getPayments().get(0)).getData());
                this.sumIncome = CommissionCalculator.calculate((Sum)opr, (Commission)pack.getCommission(), (Commission)pack.getService().getCommission(), (Date)this.environment.getDateOfStartPayment(), (String)"BANKCARD", (boolean)this.environment.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
                Sum comm = this.sumIncome.sub(opr);
                Sum sumIncome1 = this.sumIncome;
                if (!this.equalsCommStep(pack.getCommission()) || !this.equalsCommStep(pack.getService().getCommission())) {
                    log.info((Object)">>> steps is not equals");
                    comm = null;
                    sumIncome1 = new Sum(opr);
                }
                log.info((Object)(">>> sumIncome1=" + sumIncome1));
                log.info((Object)(">>> opr=" + opr));
                log.info((Object)(">>> comm=" + comm));
                d.put("#income", sumIncome1);
                d.put("#outcome", opr);
                d.put("#comm", comm);
                cs.setListener((ScreenListener)new LocalSumConfirmScreenListener(opr));
                cs.init((ScreenDescription)sd, InitModuleHelper.buildScreenInit(this.environment, d));
                this.context.showScreen(new ContentScreenAdapterKbr(cs));
            }
            catch (InitException ex) {
                this.cancel(null);
                log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showConfirmScreen(opr);
        }
    }

    private String getProperty(String key) {
        return (String)Session.getInstance().getPack().getService().getProperties().get(key);
    }

    private void beginBankOperation(final Sum sum) {
        this.cm.getCardData(new CardModuleCardDataListener(){

            public void onError(CardModuleError cme, String string) {
                CardPaymentModule.this.toError();
            }

            public void onCardData(CardData cd) {
                Service service = Session.getInstance().getPack().getService();
                List paymentSources = service.getPaymentSources();
                log.info((Object)("Payment sources: " + service.getPaymentSources()));
                log.info((Object)("Is IIN card: " + cd.isIinCard()));
                if (!cd.isIinCard() && (paymentSources == null || paymentSources.contains("BANKCARD_OTHER")) || cd.isIinCard() && (paymentSources == null || paymentSources.contains("BANKCARD"))) {
                    CardPaymentModule.this.purchace(sum, cd);
                } else {
                    CardPaymentModule.this.toError();
                }
            }
        });
    }

    private void purchace(Sum sum, CardData cd) {
        log.info((Object)("Start card operation, sum outcome=" + sum));
        this.sumOutcome = sum;
        this.sumIncome = CommissionCalculator.calculate((Sum)sum, (Commission)Session.getInstance().getPack().getCommission(), (Commission)Session.getInstance().getPack().getService().getCommission(), (Date)this.environment.getDateOfStartPayment(), (String)(cd.isIinCard() ? "BANKCARD" : "BANKCARD_OTHER"), (boolean)this.environment.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee());
        log.info((Object)("Sum income: " + this.sumIncome));
        this.fo = new FinanceOperation(StoreHelper.convertDep(PackUtility.getData(Session.getInstance().getPack())), (long)this.sumIncome.getBasicSum(), (long)this.sumIncome.sub(this.sumOutcome).getBasicSum(), null, this.getProperty("mcc"), this.getProperty("merchant-id") == null ? this.getProperty("vendor") : this.getProperty("merchant-id"));
        this.invokeOperation = true;
        if (AppDefaults.getInstance().getBooleanProperty("card.payment.fake", false)) {
            this.cm.getCardData(new CardModuleCardDataListener(){

                public void onError(CardModuleError cme, String string) {
                    if (cme == CardModuleError.ERROR_USER_CANCEL) {
                        log.info((Object)"Operation canceled by user, show dialog");
                        CardPaymentModule.this.context.showWait(null);
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.error1", (Locale)CardPaymentModule.this.environment.getLocale()), 20, DC.cases((int)8), UserCase.Ok);
                        dialog.addListener((DialogListener)new ExitRevertDialogListener(CardPaymentModule.this.context));
                        CardPaymentModule.this.context.showDialog((DialogInterface)dialog);
                    } else {
                        CardPaymentModule.this.toError();
                    }
                }

                public void onCardData(CardData cd) {
                    CardPaymentModule.this.toError();
                }
            });
        } else {
            this.cm.purchase(this.fo, (CardModuleResultListener)new LocalPurchaseListener());
        }
        log.info((Object)"Done");
    }

    private void toError() {
        DialogScreen dialog;
        boolean cashinError;
        this.context.showWait(null);
        Service service = Session.getInstance().getPack().getService();
        boolean bl = cashinError = (StateFacade.getState().getWarningMask() & 0x20) > 0;
        if ((service.getPaymentSchemaFlags() & 1) > 0 && !cashinError) {
            dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Provider.card.error2.tocash", (Locale)this.environment.getLocale()), 20, DC.cases((int)24), UserCase.Cancel);
            dialog.addListener((DialogListener)new ToCashDialogListener(this.context));
        } else {
            dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.error2", (Locale)this.environment.getLocale()), 20, DC.cases((int)8), UserCase.Ok);
            dialog.addListener((DialogListener)new ExitRevertDialogListener(this.context));
        }
        this.context.showDialog((DialogInterface)dialog);
    }

    private void showConfirmScreen(Sum opr) {
        Pack pack = Session.getInstance().getPack();
        if (pack.getKeeper() != null) {
            log.info((Object)("Current keeper: " + pack.getKeeper() + " sum-oper: " + opr + "."));
            this.sumIncome = CommissionCalculator.calculate((Sum)opr, (Commission)pack.getCommission(), (Commission)pack.getService().getCommission(), (Date)this.environment.getDateOfStartPayment(), (String)"BANKCARD", (boolean)this.environment.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
            log.info((Object)("Sum income: " + this.sumIncome));
            if (pack.getKeeper().getSum().compareTo(this.sumIncome) >= 0) {
                log.info((Object)("Sum income: " + this.sumIncome + ".No need card trans."));
                Keeper keeper = pack.getKeeper();
                Payment p = (Payment)pack.getPayments().get(0);
                p.setSumOut(this.sumOutcome);
                pack.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), this.sumOutcome, this.sumOutcome, this.sumIncome.sub(this.sumOutcome), keeper.getSum().sub(this.sumIncome), pack.getProviderFee(), null));
                pack.setKeeper(keeper);
                Intent i = new Intent(){

                    @Override
                    public void process() {
                        CardPaymentModule.this.environment.getProcessingModule().process(CardPaymentModule.this.environment);
                    }

                    @Override
                    public int getType() {
                        return 1;
                    }
                };
                this.guiListener.setIntent(i);
                CardModuleStore.getInstance().closeSessionSafe(true);
                return;
            }
        }
        if (this.skipConfirm) {
            this.context.showWait(this.waitScreen);
            this.beginBankOperation(opr);
        } else {
            CardConfirmHelper.showConfirm(this.environment, this.context, (ScreenListener)new LocalConfirmScreenListener(opr), log);
        }
    }

    protected void fillCardInfo(Map<String, Object> data, CardInfo ci, Locale locale) {
        InputElement cashless = new InputElement("is-cashless", B.get((String)"Module.card.cashless", (Locale)locale, (String)"\u0411\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u0430\u044f \u043e\u043f\u043b\u0430\u0442\u0430 "), "true");
        InputElement pan = new InputElement("account-client", B.get((String)"Module.card.pan", (Locale)locale, (String)"PAN"), ci.getPan());
        InputElement hash = new InputElement("hash-pan", B.get((String)"Module.card.hash", (Locale)locale, (String)"hash-pan"), BU.toHexString((byte[])ci.getPanHash().getSha1()));
        InputElement curr = new InputElement("curr", "", "810");
        String terminalId = ci.getTerminal().isEmpty() ? String.valueOf(this.environment.getPoint().getId()) : ci.getTerminal();
        InputElement terminal = new InputElement("terminal", B.get((String)"Module.card.cardinfo.terminal", (Locale)locale), terminalId);
        data.put("is-cashless", cashless);
        data.put("account-client", pan);
        data.put("hash-pan", hash);
        data.put("terminal", terminal);
        data.put("curr", curr);
    }

    protected void fillCardInfo(Map<String, Object> data, OperationResult t, CardInfo ci, Locale locale) {
        Currency currency;
        log.info((Object)("OperationPurchaseResult: " + t));
        if (t.getAuthIdentResponse() != null) {
            data.put("auth", new InputElement("auth", B.get((String)"Module.card.cardinfo.auth", (Locale)locale), t.getAuthIdentResponse()));
        }
        if (t.getRrn() != null) {
            data.put("rrn", new InputElement("rrn", B.get((String)"Module.card.cardinfo.rrn", (Locale)locale), t.getRrn()));
        }
        InputElement curr = (currency = t.getCurrency()) != null ? new InputElement("curr", B.get((String)"Module.card.account.currency", (Locale)locale), B.get((String)("Module.card.currency.code." + t.getCurrency().getDigitCode()), (Locale)locale, (String)(t.getCurrency() == null ? "" : t.getCurrency().getDigitCode()))) : new InputElement("curr", "", "810");
        InputElement merchant = new InputElement("merchant", B.get((String)"Module.card.cardinfo.merchant", (Locale)locale), t.getMerchant());
        InputElement stan = new InputElement("stan", B.get((String)"Module.card.cardinfo.stan", (Locale)locale), t.getStan());
        InputElement terminal = new InputElement("terminal", B.get((String)"Module.card.cardinfo.terminal", (Locale)locale), t.getTerminal());
        InputElement cashless = new InputElement("is-cashless", B.get((String)"Module.card.cashless", (Locale)locale, (String)"\u0411\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u0430\u044f \u043e\u043f\u043b\u0430\u0442\u0430 "), "true");
        InputElement pan = new InputElement("account-client", B.get((String)"Module.card.pan", (Locale)locale, (String)"PAN"), ci.getPan());
        InputElement hash = new InputElement("hash-pan", B.get((String)"Module.card.hash", (Locale)locale, (String)"hash-pan"), BU.toHexString((byte[])ci.getPanHash().getSha1()));
        data.put("curr", curr);
        data.put("merchant", merchant);
        data.put("stan", stan);
        data.put("terminal", terminal);
        data.put("is-cashless", cashless);
        data.put("account-client", pan);
        data.put("hash-pan", hash);
        Map additionalData = t.getAdditionalData();
        if (additionalData != null) {
            for (String key : additionalData.keySet()) {
                InputElement ie = new InputElement(key, key, (String)additionalData.get(key));
                data.put(key, ie);
            }
            String commission = (String)additionalData.get("CardCommission");
            if (commission != null) {
                InputElement comm = new InputElement("CardCommission", B.get((String)"Module.card.commission", (Locale)locale, (String)"C\u043f\u0438\u0441\u0430\u043d\u043e \u0437\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u043a\u0430\u0440\u0442\u0435: "), commission);
                data.put("cardCommission", comm);
            }
        }
    }

    private ScreenDescription createSumScreenDescription(Locale locale, Service s) {
        ScreenDescription sd = new ScreenDescription("digital");
        sd.setTitle(B.get((String)"Module.payment.card.set-sum.title", (Locale)locale));
        sd.setDecor(AppDefaults.getInstance().getProperty("Module.payment.card.sum-set.screen.decor", "commission"));
        sd.setButtons(null);
        NumericField nf = new NumericField();
        nf.setId(SUM_KEY);
        nf.setUnitCount(5);
        nf.setDecimalCount(2);
        nf.setKeyboard(new Keyboard(KeyboardType.Digital, Character.valueOf('.')));
        nf.setFlags(2);
        double min = 1.0;
        double max = 1.0;
        if (s != null) {
            if (s.getMaxSum() != null) {
                max = s.getMaxSum().getSum();
            }
            if (s.getMinSum() != null) {
                min = s.getMinSum().getSum();
            }
            if (s.getLimits() != null) {
                for (ServiceLimit ls : s.getLimits()) {
                    if (ls.getPaymentSchema() != 2) continue;
                    max = ls.getMaxSum().getSum();
                    min = ls.getMinSum().getSum();
                }
            }
        }
        nf.setValidator((Validator)new NumericRangeValidator(Arrays.asList(new Range((float)min, (float)max))));
        nf.setTitle(B.get((String)"Module.payment.card.set-sum.message", (Locale)locale));
        nf.setHelp(MessageFormat.format(B.get((String)"Module.payment.card.set-sum.help", (Locale)locale), min, max));
        sd.setSequence(new FieldSequence(Arrays.asList(nf)));
        return sd;
    }

    private SumScreenDescription createSumConfirmScreenDescription(Locale locale) {
        SumScreenDescription sd = new SumScreenDescription();
        sd.setType("cards-sum-confirm");
        sd.setTitle(B.get((String)"Module.payment.card.confirm-sum.title", (Locale)locale));
        sd.setDecor(AppDefaults.getInstance().getProperty("Module.payment.card.confirm-sum.screen.decor", "commission"));
        sd.setButtons(null);
        return sd;
    }

    private boolean equalsCommStep(Commission commission) {
        if (commission != null && commission.getSteps() != null && !commission.getSteps().isEmpty()) {
            ArrayList<CommissionStep> bank = new ArrayList<CommissionStep>();
            ArrayList<CommissionStep> bankOther = new ArrayList<CommissionStep>();
            for (CommissionStep step : commission.getSteps()) {
                if ("BANKCARD".equals(step.getPaymentSource())) {
                    bank.add(step);
                    continue;
                }
                if (!"BANKCARD_OTHER".equals(step.getPaymentSource())) continue;
                bankOther.add(step);
            }
            if (bank.size() != bankOther.size()) {
                return false;
            }
            for (CommissionStep step : bank) {
                boolean findStep = false;
                for (CommissionStep stepOth : bankOther) {
                    if (!step.getSum().equals((Object)stepOth.getSum())) continue;
                    findStep = true;
                    if (step.getFixedValue().equals((Object)stepOth.getFixedValue()) && Double.compare(step.getPercentValue(), stepOth.getPercentValue()) == 0) continue;
                    return false;
                }
                if (findStep) continue;
                return false;
            }
        }
        return true;
    }

    public class ToCashIntent
    implements Intent {
        @Override
        public void process() {
            CardPaymentModule.this.environment.getPaymentModule().startPaymentByCash(CardPaymentModule.this.environment, CardPaymentModule.this.sumScreen);
        }

        @Override
        public int getType() {
            return 1;
        }
    }

    public class ToCashDialogListener
    implements DialogListener {
        private final ApplicationContext context;

        public ToCashDialogListener(ApplicationContext context) {
            this.context = context;
        }

        public void dialogClosed(UserCase userCase) {
            if (userCase == UserCase.Ok) {
                CardPaymentModule.this.guiListener.setIntent(new ToCashIntent());
            }
            CardModuleStore.getInstance().closeSessionSafe(false);
            CardModuleStore.getInstance().reverse();
        }
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        private Intent intent;

        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        public void setIntent(Intent intent) {
            this.intent = intent;
        }

        @Override
        public synchronized void _onClosed() {
            Intent i = this.intent;
            if (i == null) {
                i = new ExitIntent(CardPaymentModule.this.context);
            }
            i.process();
            this.intent = null;
        }
    }

    private class LocalConfirmScreenListener
    extends ScreenAdapter {
        private final Sum opr;

        public LocalConfirmScreenListener(Sum opr) {
            this.opr = opr;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            log.info((Object)("Action on confirm input screen: " + action));
            if (ActionType.isExit((String)action)) {
                CardPaymentModule.this.guiListener.setIntent(new ExitIntent(CardPaymentModule.this.context));
                CardPaymentModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                CardPaymentModule.this.context.showWait(CardPaymentModule.this.waitScreen);
                CardPaymentModule.this.beginBankOperation(this.opr);
            } else if (ActionType.isPrev((String)action)) {
                Sum os = Session.getInstance().getPack().getOperationSum();
                if (os == null || os.isEmpty()) {
                    if (AppDefaults.getInstance().getBooleanProperty("Module.payment.card.show-sum-confirm", false)) {
                        CardPaymentModule.this.showSumConfirmScreen(this.opr);
                    } else {
                        CardPaymentModule.this.showSumScreen();
                    }
                } else {
                    CardPaymentModule.this.guiListener.setIntent(new BackIntent(CardPaymentModule.this.environment.getInputModule()));
                    CardPaymentModule.this.cancel(null);
                }
            }
        }
    }

    private class LocalSumConfirmScreenListener
    extends ScreenAdapter {
        private final Sum sum;

        public LocalSumConfirmScreenListener(Sum sum) {
            this.sum = sum;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            log.info((Object)("Action on sum input screen: " + action));
            if (ActionType.isExit((String)action)) {
                CardPaymentModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                CardPaymentModule.this.showConfirmScreen(this.sum);
            } else if (ActionType.isPrev((String)action)) {
                Sum os = Session.getInstance().getPack().getOperationSum();
                if (os == null || os.isEmpty()) {
                    CardPaymentModule.this.showSumScreen();
                } else {
                    CardPaymentModule.this.guiListener.setIntent(new BackIntent(CardPaymentModule.this.environment.getInputModule()));
                    CardPaymentModule.this.cancel(null);
                }
            }
        }
    }

    private class LocalSumScreenListener
    extends ScreenAdapter {
        private LocalSumScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            log.info((Object)("Action on sum input screen: " + action));
            if (ActionType.isExit((String)action)) {
                ExitIntent exitIntent = new ExitIntent(CardPaymentModule.this.context);
                CardPaymentModule.this.guiListener.setIntent(exitIntent);
                CardPaymentModule.this.cancel(exitIntent);
            } else if (ActionType.isNext((String)action)) {
                CardPaymentModule.this.data = data;
                CardPaymentModule.this.showSumConfirmScreen(new Sum(Double.parseDouble(((InputElement)data.get(CardPaymentModule.SUM_KEY)).getValue())));
            } else if (ActionType.isPrev((String)action)) {
                BackIntent backIntent = new BackIntent(CardPaymentModule.this.environment.getInputModule());
                if (!CardModuleStore.getInstance().isOpenFromInputModule()) {
                    CardPaymentModule.this.guiListener.setIntent(backIntent);
                }
                CardPaymentModule.this.cancel(backIntent);
            }
        }
    }

    private class LocalPurchaseListener
    implements CardModuleResultListener<OperationPurchaseResult> {
        private LocalPurchaseListener() {
        }

        public void onError(CardModuleError cme, String message, CardInfo cardInfo) {
            DialogScreen dialog;
            CardPaymentModule.this.invokeOperation = false;
            log.info((Object)(">>>onError " + cme + ", " + message + " CardInfo: " + cardInfo));
            if (cardInfo != null) {
                Pack pack = Session.getInstance().getPack();
                Payment p = (Payment)pack.getPayments().get(0);
                p.setSumOut(CardPaymentModule.this.sumOutcome);
                CardPaymentModule.this.fillCardInfo(p.getData(), cardInfo, CardPaymentModule.this.environment.getLocale());
                CashlessData cashlessData = new CashlessData(cardInfo.getPan(), cardInfo.getCardholderName() == null ? "-" : cardInfo.getCardholderName(), Integer.toString(CardPaymentModule.this.environment.getPoint().getId()), "", "", "", "", "");
                try {
                    cashlessData.setRawCheque(cardInfo.getRawCheque());
                }
                catch (NoSuchMethodError ex) {
                    log.info((Object)"There is no bankcard raw cheque.");
                }
                pack.setCashlessData(cashlessData);
            }
            UserAction.getInstance().update();
            CardPaymentModule.this.context.getServerConnector().sendEvent(new Event(EventType.Warning, "CardPaymentError(initiator=" + message + ")"));
            if (cme == CardModuleError.ERROR_WRONG_PIN) {
                log.info((Object)"Wrong pin, show dialog");
                CardPaymentModule.this.context.showWait(null);
                dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.pin-wrong", (Locale)CardPaymentModule.this.environment.getLocale()), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        log.info((Object)"Wrong pin dialog closed. Start card operation");
                        CardPaymentModule.this.invokeOperation = true;
                        CardPaymentModule.this.cm.purchase(CardPaymentModule.this.fo, (CardModuleResultListener)new LocalPurchaseListener());
                        log.info((Object)"Done");
                    }
                });
                CardPaymentModule.this.context.showDialog((DialogInterface)dialog);
            } else if (cme == CardModuleError.ERROR_USER_CANCEL) {
                log.info((Object)"Operation canceled by user, show dialog");
                CardPaymentModule.this.context.showWait(null);
                dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.error1", (Locale)CardPaymentModule.this.environment.getLocale()), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitRevertDialogListener(CardPaymentModule.this.context));
                CardPaymentModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                CardPaymentModule.this.context.showWait(null);
                boolean cashinError = (StateFacade.getState().getWarningMask() & 0x20) > 0;
                Service service = Session.getInstance().getPack().getService();
                if ((service.getPaymentSchemaFlags() & 1) > 0 && !cashinError) {
                    if (message == null || message.isEmpty()) {
                        dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Provider.card.error2.tocash", (Locale)CardPaymentModule.this.environment.getLocale()), 20, DC.cases((int)24), UserCase.Cancel);
                        dialog.addListener((DialogListener)new ToCashDialogListener(CardPaymentModule.this.context));
                    } else {
                        dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Provider.card.error3.tocash", (Locale)CardPaymentModule.this.environment.getLocale()), B.get((String)message, (Locale)CardPaymentModule.this.environment.getLocale(), (String)message)), 20, DC.cases((int)24), UserCase.Cancel);
                        dialog.addListener((DialogListener)new ToCashDialogListener(CardPaymentModule.this.context));
                    }
                } else if (message == null || message.isEmpty()) {
                    dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.error2", (Locale)CardPaymentModule.this.environment.getLocale()), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitRevertDialogListener(CardPaymentModule.this.context));
                } else {
                    dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Provider.card.error3", (Locale)CardPaymentModule.this.environment.getLocale()), B.get((String)message, (Locale)CardPaymentModule.this.environment.getLocale(), (String)message)), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitRevertDialogListener(CardPaymentModule.this.context));
                }
            }
            CardPaymentModule.this.context.showDialog((DialogInterface)dialog);
        }

        public void onResult(OperationPurchaseResult t, CardInfo ci) {
            CardPaymentModule.this.invokeOperation = false;
            UserAction.getInstance().update();
            log.info((Object)">>>onSuccess");
            CardPaymentModule.this.context.showWait(null);
            Keeper keeper = new Keeper();
            Pack pack = Session.getInstance().getPack();
            if (pack.getKeeper() != null) {
                keeper = pack.getKeeper();
            }
            keeper.addPayback(CardPaymentModule.this.sumIncome);
            ServiceZReportStorage.getInstance().getCurrentSnapshot().addZCashlessSum(CardPaymentModule.this.sumIncome);
            SumResult sr = new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), CardPaymentModule.this.sumOutcome, CardPaymentModule.this.sumOutcome, CardPaymentModule.this.sumIncome.sub(CardPaymentModule.this.sumOutcome), keeper.getSum().sub(CardPaymentModule.this.sumIncome), pack.getProviderFee(), null);
            pack.setSumResult(sr);
            if (pack.getPayments().size() > 1) {
                log.info((Object)"Processing single operation pack (card)");
                PackUtility.distributeSum(pack, sr);
                for (Payment p : pack.getPayments()) {
                    CardPaymentModule.this.fillCardInfo(p.getData(), (OperationResult)t, ci, CardPaymentModule.this.environment.getLocale());
                }
            } else {
                log.info((Object)"Processing multi operation pack (card)");
                Payment p = (Payment)pack.getPayments().get(0);
                p.setSumOut(CardPaymentModule.this.sumOutcome);
                CardPaymentModule.this.fillCardInfo(p.getData(), (OperationResult)t, ci, CardPaymentModule.this.environment.getLocale());
            }
            pack.setKeeper(keeper);
            pack.setPaymentTool(ci.isIinCard() ? 2 : 3);
            CashlessData cashlessData = new CashlessData(ci.getPan(), ci.getCardholderName() == null ? "-" : ci.getCardholderName(), Integer.toString(CardPaymentModule.this.environment.getPoint().getId()), "", "", "", t.getRrn(), t.getAuthIdentResponse());
            try {
                cashlessData.setRawCheque(ci.getRawCheque());
            }
            catch (NoSuchMethodError ex) {
                log.info((Object)"There is no bankcard raw cheque.");
            }
            pack.setCashlessData(cashlessData);
            if (ModuleHelper.isCardRevert()) {
                CardPaymentModule.this.context.getTaskExecutor().submit(new Callable(){

                    public Object call() throws Exception {
                        CardPaymentModule.this.environment.getProcessingModule().process(CardPaymentModule.this.environment);
                        return null;
                    }
                });
            } else {
                Intent i = new Intent(){

                    @Override
                    public void process() {
                        CardPaymentModule.this.environment.getProcessingModule().process(CardPaymentModule.this.environment);
                    }

                    @Override
                    public int getType() {
                        return 1;
                    }
                };
                CardPaymentModule.this.guiListener.setIntent(i);
                CardModuleStore.getInstance().closeSessionSafe(true);
            }
        }

        public void onCardData(CardData cd) {
        }
    }
}

