/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.awt.EventQueue;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;

public class BaseKeeperListener
implements KeeperObserver {
    private static final Logger log = LoggerId.PAY;
    private final CommonSumScreen css;
    private Sum minLimit;
    private final Service service;
    private final PayDetector detector;
    private final boolean autoFinishPayment;
    private final ScreenListener listener;
    private final ApplicationContext context;
    private final Locale locale;
    private final boolean allowReturn;
    private Sum requireSum;
    private Sum fullComm;

    public BaseKeeperListener(ApplicationContext context, Locale locale, CommonSumScreen css, Sum requireSum, Sum minLimit, Service service, PayDetector detector, boolean autoFinishPayment, ScreenListener listener, boolean allowReturn) {
        this.context = context;
        this.locale = locale;
        this.css = css;
        this.requireSum = requireSum;
        this.minLimit = minLimit;
        this.service = service;
        this.detector = detector;
        this.autoFinishPayment = autoFinishPayment;
        this.listener = listener;
        this.allowReturn = allowReturn;
    }

    public void updateLimits(Keeper keeper, Sum maxSum, Sum minSum, Sum newRequiredSum) {
        if (newRequiredSum != null) {
            this.requireSum = newRequiredSum;
        }
        this.detector.setMax(maxSum);
        this.detector.setMin(minSum);
        this.minLimit = minSum;
        SumResult sr = this.detector.canCalculatePayPartSumResult(keeper) ? this.detector.calculatePayPartSum(keeper) : this.detector.calculate(keeper);
        EventQueue.invokeLater(new ViewUpdater(keeper, sr, this.fullComm, this.detector.canPay(sr)));
    }

    public void update(Keeper keeper, Sum sum) {
        SumResult sr;
        Session.getInstance().setCurrentKeeper(keeper);
        boolean canPayPart = this.detector.canCalculatePayPartSumResult(keeper);
        if (this.fullComm == null) {
            Keeper k = new Keeper();
            k.addCashBackCard(new CashBackCard(0, this.requireSum == null ? new Sum(1000) : this.requireSum));
            this.fullComm = this.detector.canCalculatePayPartSumResult(k) ? this.detector.calculatePayPartSum(k).getCommission() : this.detector.calculate2(k).getCommission();
        }
        SumResult sumResult = sr = canPayPart ? this.detector.calculatePayPartSum(keeper) : this.detector.calculate2(keeper);
        if (!keeper.getSum().isEmpty()) {
            log.info((Object)("--> Get sum : " + sum));
            log.info((Object)("Keeper      : " + keeper.getSum() + ", " + keeper));
            log.info((Object)("Amount      : " + sr));
        }
        CashManager.getDefaultInstance().setNotTakeBills(this.detector.isDisableTakeBills(sr, this.service.getNotTakeMoneyReachesAmount()));
        EventQueue.invokeLater(new ViewUpdater(keeper, sr, this.fullComm, this.detector.canPay(sr) && !canPayPart));
    }

    public void notifyNoMoreNeed() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.payment.keeper.no-need-more", (Locale)BaseKeeperListener.this.locale), 20, DC.cases((int)4, (Locale)BaseKeeperListener.this.locale, (Object[])new Object[0]), UserCase.Ok);
                dialog.show(BaseKeeperListener.this.context.getShell());
            }
        });
    }

    public void setRequireSum(Sum requireSum) {
        this.requireSum = requireSum;
    }

    private class ViewUpdater
    implements Runnable {
        private final Keeper keeper;
        private final SumResult sr;
        private final boolean canPay;

        public ViewUpdater(Keeper keeper, SumResult sr, Sum fullComm, boolean canPay) {
            this.keeper = keeper;
            this.sr = sr;
            this.canPay = canPay;
        }

        @Override
        public void run() {
            Sum mds;
            Sum addReqSumm = new Sum();
            if (BaseKeeperListener.this.detector.getSmsSum() != null) {
                addReqSumm = BaseKeeperListener.this.detector.getSmsSum();
            }
            if ((mds = BaseKeeperListener.this.detector.getMaxDiffSum()) == null || mds.isEmpty()) {
                BaseKeeperListener.this.css.updateSums(this.keeper.getSum(), BaseKeeperListener.this.detector.getOperationSum(), BaseKeeperListener.this.requireSum.add(addReqSumm), BaseKeeperListener.this.minLimit, this.sr, BaseKeeperListener.this.fullComm, this.canPay, this.sr.getIncome().isEmpty() || BaseKeeperListener.this.allowReturn, CashMobuleHelper.isAllowCBC(BaseKeeperListener.this.service, this.keeper == null ? false : !this.keeper.getCashSum().isEmpty()));
            } else {
                BaseKeeperListener.this.css.updateSums(this.keeper.getSum(), new Sum(), mds.add(addReqSumm), BaseKeeperListener.this.minLimit, this.sr, BaseKeeperListener.this.fullComm, this.canPay, this.sr.getIncome().isEmpty() || BaseKeeperListener.this.allowReturn, CashMobuleHelper.isAllowCBC(BaseKeeperListener.this.service, this.keeper == null ? false : !this.keeper.getCashSum().isEmpty()));
            }
            if (BaseKeeperListener.this.autoFinishPayment && this.canPay) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BaseKeeperListener.this.listener.onAction("Next", null, new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                    }
                });
            }
        }
    }
}

