/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.lock;

import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.lock.LockModule;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.Point;

public abstract class BaseLockModule
implements LockModule {
    protected ApplicationContext context;
    private TerminalState state;
    private Logger log;

    public BaseLockModule(ApplicationContext context) {
        this.context = context;
        this.log = Logger.getLogger((String)"gui");
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getInactivityTimeout() {
        return 1;
    }

    @Override
    public void start() {
        this.state = StateFacade.getState();
        this._start(ModuleHelper.getDefaultLocale(), ModuleHelper.getDealer(), ModuleHelper.getPoint(), this.state);
        this.context.setModule(this);
    }

    protected abstract void _start(Locale var1, Dealer var2, Point var3, TerminalState var4);

    @Override
    public void cancel(Intent intent) {
        TerminalState ts = StateFacade.getState();
        if (!ts.equals((Object)this.state)) {
            this.log.info((Object)("State was changed: " + this.state + "->" + ts + ", go to main menu"));
            this.state = ts;
            this.context.getShell().showPopup(null);
            intent.process();
        }
    }
}

