/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.template;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.Parser;
import ru.softlogic.system.util.PathUtils;

public class UtilityHelper {
    private static Map<String, SoftReference<Scenario>> forms = new HashMap<String, SoftReference<Scenario>>();
    private static Logger log = Logger.getLogger((String)"pay");
    private String path;

    public UtilityHelper(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path require");
        }
        this.path = path;
    }

    public Scenario getScenario(Locale locale) throws Exception {
        Scenario form;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((form = this.getScenario("_" + locale.getLanguage())) != null) {
            return form;
        }
        form = this.getScenario("");
        if (form != null) {
            return form;
        }
        throw new Exception("Can't parce form");
    }

    private Scenario getScenario(String suffix) {
        String id = "" + this.path + suffix;
        log.info((Object)("Search: " + id));
        if (forms.containsKey(id)) {
            SoftReference<Scenario> srf = forms.get(id);
            if (srf != null) {
                Scenario f = srf.get();
                if (f == null) {
                    log.info((Object)("SoftReference go out: " + this.path + suffix));
                    f = this.readScenarioRes(suffix);
                    forms.put(id, new SoftReference<Scenario>(f));
                }
                return f;
            }
        } else {
            Scenario f = this.readScenarioRes(suffix);
            if (f != null) {
                forms.put(id, new SoftReference<Scenario>(f));
                return f;
            }
            forms.put(id, null);
        }
        return null;
    }

    private Scenario readScenarioRes(String postfix) {
        try {
            return Parser.parse((File)new File(PathUtils.getAppHome() + "/resources/utility/scenario/" + this.path + postfix + ".xml"));
        }
        catch (ParseException ex) {
            log.error((Object)("Error on parsing: " + ex.getMessage()));
            return null;
        }
    }
}

